/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.io.IOException;
import java.io.Writer;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntitySetInfo;
import org.apache.olingo.odata2.api.edm.EdmServiceMetadata;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class JsonServiceDocumentProducer {
    public static void writeServiceDocument(Writer writer, Edm edm) throws EntityProviderException {
        EdmServiceMetadata serviceMetadata = edm.getServiceMetadata();
        JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
        try {
            jsonStreamWriter.beginObject().name("d").beginObject().name("EntitySets").beginArray();
            boolean first = true;
            for (EdmEntitySetInfo info : serviceMetadata.getEntitySetInfos()) {
                if (first) {
                    first = false;
                } else {
                    jsonStreamWriter.separator();
                }
                jsonStreamWriter.stringValue(JsonServiceDocumentProducer.createEntitySetName(info));
            }
            jsonStreamWriter.endArray().endObject().endObject();
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{e.getClass().getSimpleName()}), (Throwable)e);
        }
        catch (ODataException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(new Object[]{((Object)((Object)e)).getClass().getSimpleName()}), (Throwable)e);
        }
    }

    private static String createEntitySetName(EdmEntitySetInfo info) {
        String entitySetName = info.isDefaultEntityContainer() ? info.getEntitySetName() : info.getEntityContainerName() + "." + info.getEntitySetName();
        return entitySetName;
    }
}

