/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataNotFoundException;
import org.apache.olingo.odata2.api.exception.ODataUnsupportedMediaTypeException;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.core.ODataPathSegmentImpl;
import org.apache.olingo.odata2.core.PathInfoImpl;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.commons.Decoder;
import org.apache.olingo.odata2.core.rest.SubLocatorParameter;

public class RestUtil {
    public static Response convertResponse(ODataResponse odataResponse) {
        try {
            Response.ResponseBuilder responseBuilder = Response.noContent().status(odataResponse.getStatus().getStatusCode()).entity(odataResponse.getEntity());
            for (String name : odataResponse.getHeaderNames()) {
                responseBuilder = responseBuilder.header(name, (Object)odataResponse.getHeader(name));
            }
            return responseBuilder.build();
        }
        catch (RuntimeException e) {
            if (odataResponse != null) {
                try {
                    odataResponse.close();
                }
                catch (IOException inner) {
                    throw e;
                }
            }
            throw e;
        }
    }

    private static String getSafeHeader(String name, HttpHeaders headers) {
        List header = headers.getRequestHeader(name);
        if (header != null && !header.isEmpty()) {
            return (String)header.get(0);
        }
        return null;
    }

    public static ContentType extractRequestContentType(SubLocatorParameter param) throws ODataUnsupportedMediaTypeException {
        String contentType = RestUtil.getSafeHeader("Content-Type", param.getHttpHeaders());
        if (contentType == null || contentType.isEmpty()) {
            return ContentType.APPLICATION_OCTET_STREAM;
        }
        if (ContentType.isParseable(contentType)) {
            return ContentType.create(contentType);
        }
        throw new ODataUnsupportedMediaTypeException(ODataUnsupportedMediaTypeException.NOT_SUPPORTED_CONTENT_TYPE.addContent(new Object[]{contentType}));
    }

    public static ServletInputStream extractRequestContent(SubLocatorParameter param) throws ODataException {
        try {
            return param.getServletRequest().getInputStream();
        }
        catch (IOException e) {
            throw new ODataException("Error getting request content as ServletInputStream.", (Throwable)e);
        }
    }

    public static <T> InputStream contentAsStream(T content) throws ODataException {
        InputStream inputStream;
        if (content == null) {
            throw new ODataBadRequestException(ODataBadRequestException.COMMON);
        }
        if (content instanceof InputStream) {
            inputStream = (InputStream)content;
        } else if (content instanceof String) {
            try {
                inputStream = new ByteArrayInputStream(((String)content).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new ODataBadRequestException(ODataBadRequestException.COMMON, (Throwable)e);
            }
        } else {
            throw new ODataBadRequestException(ODataBadRequestException.COMMON);
        }
        return inputStream;
    }

    public static List<String> extractAcceptHeaders(SubLocatorParameter param) throws ODataBadRequestException {
        List acceptHeaders = param.getHttpHeaders().getRequestHeader("Accept");
        LinkedList<String> toSort = new LinkedList<String>();
        if (acceptHeaders != null) {
            for (String acceptHeader : acceptHeaders) {
                String[] contentTypes;
                for (String contentType : contentTypes = acceptHeader.split(",")) {
                    toSort.add(contentType.trim());
                }
            }
        }
        ContentType.sortForQParameter(toSort);
        return toSort;
    }

    public static Map<String, String> extractRequestHeaders(HttpHeaders httpHeaders) {
        MultivaluedMap headers = httpHeaders.getRequestHeaders();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String key : headers.keySet()) {
            String value = RestUtil.getSafeHeader(key, httpHeaders);
            if (value == null || "".equals(value)) continue;
            headerMap.put(key, value);
        }
        return headerMap;
    }

    public static PathInfoImpl buildODataPathInfo(SubLocatorParameter param) throws ODataException {
        PathInfoImpl pathInfo = RestUtil.splitPath(param);
        pathInfo.setServiceRoot(RestUtil.buildBaseUri(param.getUriInfo(), param.getServletRequest(), pathInfo.getPrecedingSegments()));
        pathInfo.setRequestUri(RestUtil.buildRequestUri(param.getServletRequest()));
        return pathInfo;
    }

    private static PathInfoImpl splitPath(SubLocatorParameter param) throws ODataException {
        List<PathSegment> pathSegments;
        List<PathSegment> precedingPathSegments;
        PathInfoImpl pathInfo = new PathInfoImpl();
        if (param.getPathSplit() == 0) {
            precedingPathSegments = Collections.emptyList();
            pathSegments = param.getPathSegments();
        } else {
            if (param.getPathSegments().size() < param.getPathSplit()) {
                throw new ODataBadRequestException(ODataBadRequestException.URLTOOSHORT);
            }
            precedingPathSegments = param.getPathSegments().subList(0, param.getPathSplit());
            int pathSegmentCount = param.getPathSegments().size();
            pathSegments = param.getPathSegments().subList(param.getPathSplit(), pathSegmentCount);
        }
        pathInfo.setPrecedingPathSegment(RestUtil.convertPathSegmentList(precedingPathSegments));
        ArrayList<org.apache.olingo.odata2.api.uri.PathSegment> odataSegments = new ArrayList<org.apache.olingo.odata2.api.uri.PathSegment>();
        for (PathSegment segment : pathSegments) {
            if (segment.getMatrixParameters() == null || segment.getMatrixParameters().isEmpty()) {
                odataSegments.add(new ODataPathSegmentImpl(segment.getPath(), null));
                continue;
            }
            throw new ODataNotFoundException(ODataNotFoundException.MATRIX.addContent(new Object[]{segment.getMatrixParameters().keySet(), segment.getPath()}));
        }
        pathInfo.setODataPathSegment(odataSegments);
        return pathInfo;
    }

    private static URI buildBaseUri(UriInfo uriInfo, HttpServletRequest request, List<org.apache.olingo.odata2.api.uri.PathSegment> precedingPathSegments) throws ODataException {
        try {
            String path = uriInfo.getBaseUri().getPath();
            UriBuilder uriBuilder = UriBuilder.fromUri((String)path);
            for (org.apache.olingo.odata2.api.uri.PathSegment ps : precedingPathSegments) {
                uriBuilder = uriBuilder.path(ps.getPath());
                for (String key : ps.getMatrixParameters().keySet()) {
                    Object[] v = ((List)ps.getMatrixParameters().get(key)).toArray();
                    uriBuilder = uriBuilder.matrixParam(key, v);
                }
            }
            uriBuilder.host(request.getServerName()).port(request.getServerPort());
            uriBuilder.scheme(request.getScheme());
            String uriString = uriBuilder.build(new Object[0]).toString();
            if (!uriString.endsWith("/")) {
                uriString = uriString + "/";
            }
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new ODataException((Throwable)e);
        }
    }

    private static URI buildRequestUri(HttpServletRequest servletRequest) {
        StringBuffer buf = servletRequest.getRequestURL();
        String queryString = servletRequest.getQueryString();
        if (queryString != null) {
            buf.append("?");
            buf.append(queryString);
        }
        String requestUriString = buf.toString();
        URI requestUri = URI.create(requestUriString);
        return requestUri;
    }

    private static List<org.apache.olingo.odata2.api.uri.PathSegment> convertPathSegmentList(List<PathSegment> pathSegments) {
        ArrayList<org.apache.olingo.odata2.api.uri.PathSegment> converted = new ArrayList<org.apache.olingo.odata2.api.uri.PathSegment>();
        for (PathSegment pathSegment : pathSegments) {
            ODataPathSegmentImpl segment = new ODataPathSegmentImpl(Decoder.decode(pathSegment.getPath()), (Map<String, List<String>>)pathSegment.getMatrixParameters());
            converted.add(segment);
        }
        return converted;
    }

    public static Map<String, String> convertToSinglevaluedMap(MultivaluedMap<String, String> multi) {
        HashMap<String, String> single = new HashMap<String, String>();
        for (String key : multi.keySet()) {
            String value = (String)multi.getFirst((Object)key);
            single.put(key, value);
        }
        return single;
    }
}

