/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmComplexType;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.BinaryOperator;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.ExpressionParserException;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodOperator;
import org.apache.olingo.odata2.api.uri.expression.UnaryExpression;
import org.apache.olingo.odata2.api.uri.expression.UnaryOperator;
import org.apache.olingo.odata2.core.edm.EdmBoolean;
import org.apache.olingo.odata2.core.edm.EdmSimpleTypeFacadeImpl;
import org.apache.olingo.odata2.core.uri.expression.ActualBinaryOperator;
import org.apache.olingo.odata2.core.uri.expression.BinaryExpressionImpl;
import org.apache.olingo.odata2.core.uri.expression.ExpressionParserInternalError;
import org.apache.olingo.odata2.core.uri.expression.FilterExpressionImpl;
import org.apache.olingo.odata2.core.uri.expression.FilterParser;
import org.apache.olingo.odata2.core.uri.expression.FilterParserExceptionImpl;
import org.apache.olingo.odata2.core.uri.expression.InfoBinaryOperator;
import org.apache.olingo.odata2.core.uri.expression.InfoMethod;
import org.apache.olingo.odata2.core.uri.expression.InfoUnaryOperator;
import org.apache.olingo.odata2.core.uri.expression.LiteralExpressionImpl;
import org.apache.olingo.odata2.core.uri.expression.MemberExpressionImpl;
import org.apache.olingo.odata2.core.uri.expression.MethodExpressionImpl;
import org.apache.olingo.odata2.core.uri.expression.ParameterSet;
import org.apache.olingo.odata2.core.uri.expression.ParameterSetCombination;
import org.apache.olingo.odata2.core.uri.expression.PropertyExpressionImpl;
import org.apache.olingo.odata2.core.uri.expression.Token;
import org.apache.olingo.odata2.core.uri.expression.TokenKind;
import org.apache.olingo.odata2.core.uri.expression.TokenList;
import org.apache.olingo.odata2.core.uri.expression.Tokenizer;
import org.apache.olingo.odata2.core.uri.expression.TokenizerException;
import org.apache.olingo.odata2.core.uri.expression.TokenizerExpectError;
import org.apache.olingo.odata2.core.uri.expression.UnaryExpressionImpl;

public class FilterParserImpl
implements FilterParser {
    protected static Map<String, InfoBinaryOperator> availableBinaryOperators;
    protected static Map<String, InfoMethod> availableMethods;
    protected static Map<String, InfoUnaryOperator> availableUnaryOperators;
    protected EdmEntityType resourceEntityType = null;
    protected TokenList tokenList = null;
    protected String curExpression;

    public FilterParserImpl(EdmEntityType resourceEntityType) {
        this.resourceEntityType = resourceEntityType;
    }

    @Override
    public FilterExpression parseFilterString(String filterExpression) throws ExpressionParserException, ExpressionParserInternalError {
        return this.parseFilterString(filterExpression, false);
    }

    public FilterExpression parseFilterString(String filterExpression, boolean allowOnlyBinary) throws ExpressionParserException, ExpressionParserInternalError {
        CommonExpression node = null;
        this.curExpression = filterExpression;
        try {
            this.tokenList = new Tokenizer(filterExpression).tokenize();
            if (!this.tokenList.hasTokens()) {
                return new FilterExpressionImpl(filterExpression);
            }
        }
        catch (TokenizerException tokenizerException) {
            throw FilterParserExceptionImpl.createERROR_IN_TOKENIZER(tokenizerException, this.curExpression);
        }
        try {
            CommonExpression nodeLeft = this.readElement(null);
            node = this.readElements(nodeLeft, 0);
        }
        catch (ExpressionParserException filterParserException) {
            filterParserException.setFilterTree((CommonExpression)new FilterExpressionImpl(filterExpression));
            throw filterParserException;
        }
        if (this.tokenList.tokenCount() > this.tokenList.currentToken) {
            throw FilterParserExceptionImpl.createINVALID_TRAILING_TOKEN_DETECTED_AFTER_PARSING(this.tokenList.elementAt(this.tokenList.currentToken), filterExpression);
        }
        if (allowOnlyBinary && node.getEdmType() != null && node.getEdmType() != EdmSimpleTypeKind.Boolean.getEdmSimpleTypeInstance()) {
            throw FilterParserExceptionImpl.createTYPE_EXPECTED_AT((EdmType)EdmBoolean.getInstance(), node.getEdmType(), 1, this.curExpression);
        }
        return new FilterExpressionImpl(filterExpression, node);
    }

    protected CommonExpression readElements(CommonExpression leftExpression, int priority) throws ExpressionParserException, ExpressionParserInternalError {
        Object leftNode = leftExpression;
        ActualBinaryOperator operator = this.readBinaryOperator();
        while (operator != null && operator.getOP().getPriority() >= priority) {
            this.tokenList.next();
            CommonExpression rightNode = this.readElement((CommonExpression)leftNode, operator);
            if (rightNode == null) {
                throw FilterParserExceptionImpl.createEXPRESSION_EXPECTED_AFTER_POS(operator.getToken().getPosition() + operator.getToken().getUriLiteral().length(), this.curExpression);
            }
            ActualBinaryOperator nextOperator = this.readBinaryOperator();
            while (nextOperator != null && nextOperator.getOP().getPriority() > operator.getOP().getPriority()) {
                rightNode = this.readElements(rightNode, nextOperator.getOP().getPriority());
                nextOperator = this.readBinaryOperator();
            }
            Object binaryNode = operator.getOP().getOperator() == BinaryOperator.PROPERTY_ACCESS ? new MemberExpressionImpl((CommonExpression)leftNode, rightNode) : new BinaryExpressionImpl(operator.getOP(), (CommonExpression)leftNode, rightNode, operator.getToken());
            try {
                this.validateBinaryOperatorTypes((BinaryExpression)binaryNode);
            }
            catch (ExpressionParserException expressionException) {
                expressionException.setFilterTree((CommonExpression)binaryNode);
                throw expressionException;
            }
            leftNode = binaryNode;
            operator = this.readBinaryOperator();
        }
        Token token = this.tokenList.lookToken();
        if (token != null && leftNode.getKind() == ExpressionKind.PROPERTY && this.tokenList.lookToken().getKind() == TokenKind.OPENPAREN) {
            throw FilterParserExceptionImpl.createINVALID_METHOD_CALL(leftNode, this.tokenList.lookPrevToken(), this.curExpression);
        }
        return leftNode;
    }

    protected CommonExpression readParenthesis() throws ExpressionParserException, ExpressionParserInternalError {
        Token openParenthesis = this.tokenList.expectToken(TokenKind.OPENPAREN, true);
        CommonExpression firstExpression = this.readElement(null);
        CommonExpression parenthesisExpression = this.readElements(firstExpression, 0);
        try {
            this.tokenList.expectToken(TokenKind.CLOSEPAREN);
        }
        catch (TokenizerExpectError e) {
            throw FilterParserExceptionImpl.createMISSING_CLOSING_PHARENTHESIS(openParenthesis.getPosition(), this.curExpression, e);
        }
        return parenthesisExpression;
    }

    protected MethodExpression readParameters(InfoMethod methodInfo, MethodExpressionImpl methodExpression, Token methodToken) throws ExpressionParserException, ExpressionParserInternalError {
        boolean expectAnotherExpression = false;
        boolean readComma = true;
        Token openParenthesis = this.tokenList.expectToken(TokenKind.OPENPAREN, true);
        Token token = this.tokenList.lookToken();
        if (token == null) {
            throw FilterParserExceptionImpl.createEXPRESSION_EXPECTED_AFTER_POS(openParenthesis, this.curExpression);
        }
        while (token.getKind() != TokenKind.CLOSEPAREN) {
            if (!readComma) {
                throw FilterParserExceptionImpl.createCOMMA_OR_CLOSING_PHARENTHESIS_EXPECTED_AFTER_POS(this.tokenList.lookPrevToken(), this.curExpression);
            }
            CommonExpression expression = this.readElement(null);
            if (expression != null) {
                expression = this.readElements(expression, 0);
            }
            if (expression == null && expectAnotherExpression) {
                throw FilterParserExceptionImpl.createEXPRESSION_EXPECTED_AFTER_POS(token, this.curExpression);
            }
            if (expression != null) {
                methodExpression.appendParameter(expression);
            }
            if ((token = this.tokenList.lookToken()) == null) {
                throw FilterParserExceptionImpl.createCOMMA_OR_CLOSING_PHARENTHESIS_EXPECTED_AFTER_POS(this.tokenList.lookPrevToken(), this.curExpression);
            }
            if (token.getKind() == TokenKind.COMMA) {
                expectAnotherExpression = true;
                if (expression == null) {
                    throw FilterParserExceptionImpl.createEXPRESSION_EXPECTED_AT_POS(token, this.curExpression);
                }
                this.tokenList.expectToken(",", true);
                readComma = true;
                continue;
            }
            readComma = false;
        }
        this.tokenList.expectToken(TokenKind.CLOSEPAREN, true);
        int count = methodExpression.getParameters().size();
        if (methodInfo.getMinParameter() > -1 && count < methodInfo.getMinParameter()) {
            throw FilterParserExceptionImpl.createMETHOD_WRONG_ARG_COUNT(methodExpression, methodToken, this.curExpression);
        }
        if (methodInfo.getMaxParameter() > -1 && count > methodInfo.getMaxParameter()) {
            throw FilterParserExceptionImpl.createMETHOD_WRONG_ARG_COUNT(methodExpression, methodToken, this.curExpression);
        }
        return methodExpression;
    }

    protected CommonExpression readElement(CommonExpression leftExpression) throws ExpressionParserException, ExpressionParserInternalError {
        return this.readElement(leftExpression, null);
    }

    protected CommonExpression readElement(CommonExpression leftExpression, ActualBinaryOperator leftOperator) throws ExpressionParserException, ExpressionParserInternalError {
        CommonExpression node = null;
        Token lookToken = this.tokenList.lookToken();
        if (lookToken == null) {
            return null;
        }
        switch (lookToken.getKind()) {
            case OPENPAREN: {
                node = this.readParenthesis();
                return node;
            }
            case CLOSEPAREN: 
            case COMMA: {
                return null;
            }
        }
        InfoUnaryOperator unaryOperator = this.isUnaryOperator(lookToken);
        if (unaryOperator != null) {
            return this.readUnaryoperator(lookToken, unaryOperator);
        }
        Token token = this.tokenList.expectToken(lookToken.getUriLiteral(), true);
        InfoMethod methodOperator = this.isMethod(token, lookToken = this.tokenList.lookToken());
        if (methodOperator != null) {
            return this.readMethod(token, methodOperator);
        }
        if (token.getKind() == TokenKind.SIMPLE_TYPE) {
            LiteralExpressionImpl literal = new LiteralExpressionImpl(token.getUriLiteral(), token.getJavaLiteral());
            return literal;
        }
        if (token.getKind() == TokenKind.LITERAL) {
            PropertyExpressionImpl property = new PropertyExpressionImpl(token.getUriLiteral(), token.getJavaLiteral());
            this.validateEdmProperty(leftExpression, property, token, leftOperator);
            return property;
        }
        throw ExpressionParserInternalError.createCOMMON();
    }

    protected CommonExpression readUnaryoperator(Token lookToken, InfoUnaryOperator unaryOperator) throws ExpressionParserException, ExpressionParserInternalError {
        this.tokenList.expectToken(lookToken.getUriLiteral(), true);
        CommonExpression operand = this.readElement(null);
        UnaryExpressionImpl unaryExpression = new UnaryExpressionImpl(unaryOperator, operand);
        this.validateUnaryOperatorTypes(unaryExpression);
        return unaryExpression;
    }

    protected CommonExpression readMethod(Token token, InfoMethod methodOperator) throws ExpressionParserException, ExpressionParserInternalError {
        MethodExpressionImpl method = new MethodExpressionImpl(methodOperator);
        this.readParameters(methodOperator, method, token);
        this.validateMethodTypes(method, token);
        return method;
    }

    protected ActualBinaryOperator readBinaryOperator() {
        InfoBinaryOperator operator = null;
        Token token = this.tokenList.lookToken();
        if (token == null) {
            return null;
        }
        if (token.getKind() == TokenKind.SYMBOL && token.getUriLiteral().equals("/")) {
            operator = availableBinaryOperators.get(token.getUriLiteral());
        } else if (token.getKind() == TokenKind.LITERAL) {
            operator = availableBinaryOperators.get(token.getUriLiteral());
        }
        if (operator == null) {
            return null;
        }
        return new ActualBinaryOperator(operator, token);
    }

    protected InfoUnaryOperator isUnaryOperator(Token token) {
        if (token.getKind() == TokenKind.LITERAL || token.getKind() == TokenKind.SYMBOL) {
            InfoUnaryOperator operator = availableUnaryOperators.get(token.getUriLiteral());
            return operator;
        }
        return null;
    }

    protected InfoMethod isMethod(Token token, Token lookToken) {
        if (lookToken != null && lookToken.getKind() == TokenKind.OPENPAREN) {
            return availableMethods.get(token.getUriLiteral());
        }
        return null;
    }

    protected void validateEdmProperty(CommonExpression leftExpression, PropertyExpressionImpl property, Token propertyToken, ActualBinaryOperator actBinOp) throws ExpressionParserException, ExpressionParserInternalError {
        if (this.resourceEntityType == null) {
            return;
        }
        if (leftExpression == null) {
            this.validateEdmPropertyOfStructuredType((EdmStructuralType)this.resourceEntityType, property, propertyToken);
            return;
        }
        EdmType parentType = leftExpression.getEdmType();
        if (actBinOp != null && actBinOp.operator.getOperator() != BinaryOperator.PROPERTY_ACCESS) {
            this.validateEdmPropertyOfStructuredType((EdmStructuralType)this.resourceEntityType, property, propertyToken);
            return;
        }
        if (leftExpression.getKind() != ExpressionKind.PROPERTY && leftExpression.getKind() != ExpressionKind.MEMBER) {
            if (actBinOp != null) {
                throw FilterParserExceptionImpl.createLEFT_SIDE_NOT_A_PROPERTY(actBinOp.token, this.curExpression);
            }
            throw ExpressionParserInternalError.createCOMMON();
        }
        if (parentType instanceof EdmEntityType) {
            this.validateEdmPropertyOfStructuredType((EdmStructuralType)parentType, property, propertyToken);
        } else if (parentType instanceof EdmComplexType) {
            this.validateEdmPropertyOfStructuredType((EdmStructuralType)parentType, property, propertyToken);
        } else {
            throw FilterParserExceptionImpl.createLEFT_SIDE_NOT_STRUCTURAL_TYPE(parentType, property, propertyToken, this.curExpression);
        }
    }

    protected void validateEdmPropertyOfStructuredType(EdmStructuralType parentType, PropertyExpressionImpl property, Token propertyToken) throws ExpressionParserException, ExpressionParserInternalError {
        try {
            String propertyName = property.getUriLiteral();
            EdmTyped edmProperty = parentType.getProperty(propertyName);
            if (edmProperty == null) {
                throw FilterParserExceptionImpl.createPROPERTY_NAME_NOT_FOUND_IN_TYPE(parentType, property, propertyToken, this.curExpression);
            }
            property.setEdmProperty(edmProperty);
            property.setEdmType(edmProperty.getType());
        }
        catch (EdmException e) {
            throw ExpressionParserInternalError.createERROR_ACCESSING_EDM(e);
        }
    }

    protected void validateUnaryOperatorTypes(UnaryExpression unaryExpression) throws ExpressionParserInternalError {
        InfoUnaryOperator unOpt = availableUnaryOperators.get(unaryExpression.getOperator().toUriLiteral());
        EdmType operandType = unaryExpression.getOperand().getEdmType();
        if (operandType == null && this.resourceEntityType == null) {
            return;
        }
        ArrayList<EdmType> actualParameterTypes = new ArrayList<EdmType>();
        actualParameterTypes.add(operandType);
        ParameterSet parameterSet = unOpt.validateParameterSet(actualParameterTypes);
        if (parameterSet != null) {
            unaryExpression.setEdmType(parameterSet.getReturnType());
        }
    }

    protected void validateBinaryOperatorTypes(BinaryExpression binaryExpression) throws ExpressionParserException, ExpressionParserInternalError {
        InfoBinaryOperator binOpt = availableBinaryOperators.get(binaryExpression.getOperator().toUriLiteral());
        ArrayList<EdmType> actualParameterTypes = new ArrayList<EdmType>();
        EdmType operand = binaryExpression.getLeftOperand().getEdmType();
        if (operand == null && this.resourceEntityType == null) {
            return;
        }
        actualParameterTypes.add(operand);
        operand = binaryExpression.getRightOperand().getEdmType();
        if (operand == null && this.resourceEntityType == null) {
            return;
        }
        actualParameterTypes.add(operand);
        ParameterSet parameterSet = binOpt.validateParameterSet(actualParameterTypes);
        if (parameterSet == null) {
            BinaryExpressionImpl binaryExpressionImpl = (BinaryExpressionImpl)binaryExpression;
            throw FilterParserExceptionImpl.createINVALID_TYPES_FOR_BINARY_OPERATOR(binaryExpression.getOperator(), binaryExpression.getLeftOperand().getEdmType(), binaryExpression.getRightOperand().getEdmType(), binaryExpressionImpl.getToken(), this.curExpression);
        }
        binaryExpression.setEdmType(parameterSet.getReturnType());
    }

    protected void validateMethodTypes(MethodExpression methodExpression, Token methodToken) throws ExpressionParserException, ExpressionParserInternalError {
        InfoMethod methOpt = availableMethods.get(methodExpression.getUriLiteral());
        ArrayList<EdmType> actualParameterTypes = new ArrayList<EdmType>();
        if (methodExpression.getParameters().size() == 0) {
            return;
        }
        for (CommonExpression parameter : methodExpression.getParameters()) {
            if (parameter.getEdmType() == null && this.resourceEntityType == null) {
                return;
            }
            actualParameterTypes.add(parameter.getEdmType());
        }
        ParameterSet parameterSet = methOpt.validateParameterSet(actualParameterTypes);
        if (parameterSet == null) {
            throw FilterParserExceptionImpl.createMETHOD_WRONG_INPUT_TYPE((MethodExpressionImpl)methodExpression, methodToken, this.curExpression);
        }
        methodExpression.setEdmType(parameterSet.getReturnType());
    }

    static void initAvailTables() {
        HashMap<String, InfoBinaryOperator> lAvailableBinaryOperators = new HashMap<String, InfoBinaryOperator>();
        HashMap<String, InfoMethod> lAvailableMethods = new HashMap<String, InfoMethod>();
        HashMap<String, InfoUnaryOperator> lAvailableUnaryOperators = new HashMap<String, InfoUnaryOperator>();
        ParameterSetCombination.PSCflex combination = null;
        EdmSimpleType boolean_ = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Boolean);
        EdmSimpleType sbyte = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.SByte);
        EdmSimpleType byte_ = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Byte);
        EdmSimpleType int16 = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Int16);
        EdmSimpleType int32 = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Int32);
        EdmSimpleType int64 = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Int64);
        EdmSimpleType single = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Single);
        EdmSimpleType double_ = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Double);
        EdmSimpleType decimal = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Decimal);
        EdmSimpleType string = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.String);
        EdmSimpleType time = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Time);
        EdmSimpleType datetime = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.DateTime);
        EdmSimpleType datetimeoffset = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.DateTimeOffset);
        EdmSimpleType guid = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Guid);
        EdmSimpleType binary = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Binary);
        EdmSimpleType null_ = EdmSimpleTypeFacadeImpl.getEdmSimpleType(EdmSimpleTypeKind.Null);
        lAvailableBinaryOperators.put("/", new InfoBinaryOperator(BinaryOperator.PROPERTY_ACCESS, "Primary", 100, new ParameterSetCombination.PSCReturnTypeEqLastParameter()));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet(sbyte, sbyte, sbyte));
        combination.add(new ParameterSet(byte_, byte_, byte_));
        combination.add(new ParameterSet(int16, int16, int16));
        combination.add(new ParameterSet(int32, int32, int32));
        combination.add(new ParameterSet(int64, int64, int64));
        combination.add(new ParameterSet(single, single, single));
        combination.add(new ParameterSet(double_, double_, double_));
        combination.add(new ParameterSet(decimal, decimal, decimal));
        combination.add(new ParameterSet(sbyte, sbyte, null_));
        combination.add(new ParameterSet(sbyte, null_, sbyte));
        combination.add(new ParameterSet(byte_, byte_, null_));
        combination.add(new ParameterSet(byte_, null_, byte_));
        combination.add(new ParameterSet(int16, int16, null_));
        combination.add(new ParameterSet(int16, null_, int16));
        combination.add(new ParameterSet(int32, int32, null_));
        combination.add(new ParameterSet(int32, null_, int32));
        combination.add(new ParameterSet(int64, int64, null_));
        combination.add(new ParameterSet(int64, null_, int64));
        combination.add(new ParameterSet(single, single, null_));
        combination.add(new ParameterSet(single, null_, single));
        combination.add(new ParameterSet(double_, double_, null_));
        combination.add(new ParameterSet(double_, null_, double_));
        combination.add(new ParameterSet(decimal, decimal, null_));
        combination.add(new ParameterSet(decimal, null_, decimal));
        lAvailableBinaryOperators.put(BinaryOperator.MUL.toUriLiteral(), new InfoBinaryOperator(BinaryOperator.MUL, "Multiplicative", 60, combination));
        lAvailableBinaryOperators.put(BinaryOperator.DIV.toUriLiteral(), new InfoBinaryOperator(BinaryOperator.DIV, "Multiplicative", 60, combination));
        lAvailableBinaryOperators.put(BinaryOperator.MODULO.toUriLiteral(), new InfoBinaryOperator(BinaryOperator.MODULO, "Multiplicative", 60, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet(sbyte, sbyte, sbyte));
        combination.add(new ParameterSet(byte_, byte_, byte_));
        combination.add(new ParameterSet(int16, int16, int16));
        combination.add(new ParameterSet(int32, int32, int32));
        combination.add(new ParameterSet(int64, int64, int64));
        combination.add(new ParameterSet(single, single, single));
        combination.add(new ParameterSet(double_, double_, double_));
        combination.add(new ParameterSet(decimal, decimal, decimal));
        combination.add(new ParameterSet(sbyte, sbyte, null_));
        combination.add(new ParameterSet(sbyte, null_, sbyte));
        combination.add(new ParameterSet(byte_, byte_, null_));
        combination.add(new ParameterSet(byte_, null_, byte_));
        combination.add(new ParameterSet(int16, int16, null_));
        combination.add(new ParameterSet(int16, null_, int16));
        combination.add(new ParameterSet(int32, int32, null_));
        combination.add(new ParameterSet(int32, null_, int32));
        combination.add(new ParameterSet(int64, int64, null_));
        combination.add(new ParameterSet(int64, null_, int64));
        combination.add(new ParameterSet(single, single, null_));
        combination.add(new ParameterSet(single, null_, single));
        combination.add(new ParameterSet(double_, double_, null_));
        combination.add(new ParameterSet(double_, null_, double_));
        combination.add(new ParameterSet(decimal, decimal, null_));
        combination.add(new ParameterSet(decimal, null_, decimal));
        lAvailableBinaryOperators.put(BinaryOperator.ADD.toUriLiteral(), new InfoBinaryOperator(BinaryOperator.ADD, "Additive", 50, combination));
        lAvailableBinaryOperators.put(BinaryOperator.SUB.toUriLiteral(), new InfoBinaryOperator(BinaryOperator.SUB, "Additive", 50, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet(boolean_, string, string));
        combination.add(new ParameterSet(boolean_, time, time));
        combination.add(new ParameterSet(boolean_, datetime, datetime));
        combination.add(new ParameterSet(boolean_, datetimeoffset, datetimeoffset));
        combination.add(new ParameterSet(boolean_, guid, guid));
        combination.add(new ParameterSet(boolean_, sbyte, sbyte));
        combination.add(new ParameterSet(boolean_, byte_, byte_));
        combination.add(new ParameterSet(boolean_, int16, int16));
        combination.add(new ParameterSet(boolean_, int32, int32));
        combination.add(new ParameterSet(boolean_, int64, int64));
        combination.add(new ParameterSet(boolean_, single, single));
        combination.add(new ParameterSet(boolean_, double_, double_));
        combination.add(new ParameterSet(boolean_, decimal, decimal));
        combination.add(new ParameterSet(boolean_, binary, binary));
        combination.add(new ParameterSet(boolean_, string, null_));
        combination.add(new ParameterSet(boolean_, null_, string));
        combination.add(new ParameterSet(boolean_, time, null_));
        combination.add(new ParameterSet(boolean_, null_, time));
        combination.add(new ParameterSet(boolean_, datetime, null_));
        combination.add(new ParameterSet(boolean_, null_, datetime));
        combination.add(new ParameterSet(boolean_, datetimeoffset, null_));
        combination.add(new ParameterSet(boolean_, null_, datetimeoffset));
        combination.add(new ParameterSet(boolean_, guid, null_));
        combination.add(new ParameterSet(boolean_, null_, guid));
        combination.add(new ParameterSet(boolean_, sbyte, null_));
        combination.add(new ParameterSet(boolean_, null_, sbyte));
        combination.add(new ParameterSet(boolean_, byte_, null_));
        combination.add(new ParameterSet(boolean_, null_, byte_));
        combination.add(new ParameterSet(boolean_, int16, null_));
        combination.add(new ParameterSet(boolean_, null_, int16));
        combination.add(new ParameterSet(boolean_, int32, null_));
        combination.add(new ParameterSet(boolean_, null_, int32));
        combination.add(new ParameterSet(boolean_, int64, null_));
        combination.add(new ParameterSet(boolean_, null_, int64));
        combination.add(new ParameterSet(boolean_, single, null_));
        combination.add(new ParameterSet(boolean_, null_, single));
        combination.add(new ParameterSet(boolean_, double_, null_));
        combination.add(new ParameterSet(boolean_, null_, double_));
        combination.add(new ParameterSet(boolean_, decimal, null_));
        combination.add(new ParameterSet(boolean_, null_, decimal));
        combination.add(new ParameterSet(boolean_, binary, null_));
        combination.add(new ParameterSet(boolean_, null_, binary));
        lAvailableBinaryOperators.put(BinaryOperator.LT.toUriLiteral(), new InfoBinaryOperator(BinaryOperator.LT, "Relational", 40, combination));
        lAvailableBinaryOperators.put(BinaryOperator.GT.toUriLiteral(), new InfoBinaryOperator(BinaryOperator.GT, "Relational", 40, combination));
        lAvailableBinaryOperators.put(BinaryOperator.GE.toUriLiteral(), new InfoBinaryOperator(BinaryOperator.GE, "Relational", 40, combination));
        lAvailableBinaryOperators.put(BinaryOperator.LE.toUriLiteral(), new InfoBinaryOperator(BinaryOperator.LE, "Relational", 40, combination));
        combination.addFirst(new ParameterSet(boolean_, boolean_, boolean_));
        combination.add(new ParameterSet(boolean_, boolean_, null_));
        combination.add(new ParameterSet(boolean_, null_, boolean_));
        lAvailableBinaryOperators.put(BinaryOperator.EQ.toUriLiteral(), new InfoBinaryOperator(BinaryOperator.EQ, "Equality", 30, combination));
        lAvailableBinaryOperators.put(BinaryOperator.NE.toUriLiteral(), new InfoBinaryOperator(BinaryOperator.NE, "Equality", 30, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet(boolean_, boolean_, boolean_));
        combination.add(new ParameterSet(boolean_, boolean_, null_));
        combination.add(new ParameterSet(boolean_, null_, boolean_));
        lAvailableBinaryOperators.put(BinaryOperator.AND.toUriLiteral(), new InfoBinaryOperator(BinaryOperator.AND, "Conditinal", 20, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet(boolean_, boolean_, boolean_));
        combination.add(new ParameterSet(boolean_, boolean_, null_));
        combination.add(new ParameterSet(boolean_, null_, boolean_));
        lAvailableBinaryOperators.put(BinaryOperator.OR.toUriLiteral(), new InfoBinaryOperator(BinaryOperator.OR, "Conditinal", 10, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet(boolean_, string, string));
        lAvailableMethods.put(MethodOperator.ENDSWITH.toUriLiteral(), new InfoMethod(MethodOperator.ENDSWITH, 2, 2, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet(int32, string, string));
        lAvailableMethods.put(MethodOperator.INDEXOF.toUriLiteral(), new InfoMethod(MethodOperator.INDEXOF, 2, 2, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet(boolean_, string, string));
        lAvailableMethods.put(MethodOperator.STARTSWITH.toUriLiteral(), new InfoMethod(MethodOperator.STARTSWITH, 2, 2, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)string, string));
        lAvailableMethods.put(MethodOperator.TOLOWER.toUriLiteral(), new InfoMethod(MethodOperator.TOLOWER, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)string, string));
        lAvailableMethods.put(MethodOperator.TOUPPER.toUriLiteral(), new InfoMethod(MethodOperator.TOUPPER, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)string, string));
        lAvailableMethods.put(MethodOperator.TRIM.toUriLiteral(), new InfoMethod(MethodOperator.TRIM, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet(string, string, int32));
        combination.add(new ParameterSet(string, string, int32, int32));
        lAvailableMethods.put(MethodOperator.SUBSTRING.toUriLiteral(), new InfoMethod(MethodOperator.SUBSTRING, 1, -1, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet(boolean_, string, string));
        lAvailableMethods.put(MethodOperator.SUBSTRINGOF.toUriLiteral(), new InfoMethod(MethodOperator.SUBSTRINGOF, 1, -1, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet(string, string, string).setFurtherType(string));
        lAvailableMethods.put(MethodOperator.CONCAT.toUriLiteral(), new InfoMethod(MethodOperator.CONCAT, 2, -1, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)int32, string));
        lAvailableMethods.put(MethodOperator.LENGTH.toUriLiteral(), new InfoMethod(MethodOperator.LENGTH, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)int32, datetime));
        lAvailableMethods.put(MethodOperator.YEAR.toUriLiteral(), new InfoMethod(MethodOperator.YEAR, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)int32, datetime));
        lAvailableMethods.put(MethodOperator.MONTH.toUriLiteral(), new InfoMethod(MethodOperator.MONTH, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)int32, datetime));
        lAvailableMethods.put(MethodOperator.DAY.toUriLiteral(), new InfoMethod(MethodOperator.DAY, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)int32, datetime));
        combination.add(new ParameterSet((EdmType)int32, time));
        combination.add(new ParameterSet((EdmType)int32, datetimeoffset));
        lAvailableMethods.put(MethodOperator.HOUR.toUriLiteral(), new InfoMethod(MethodOperator.HOUR, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)int32, datetime));
        combination.add(new ParameterSet((EdmType)int32, time));
        combination.add(new ParameterSet((EdmType)int32, datetimeoffset));
        lAvailableMethods.put(MethodOperator.MINUTE.toUriLiteral(), new InfoMethod(MethodOperator.MINUTE, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)int32, datetime));
        combination.add(new ParameterSet((EdmType)int32, time));
        combination.add(new ParameterSet((EdmType)int32, datetimeoffset));
        lAvailableMethods.put(MethodOperator.SECOND.toUriLiteral(), new InfoMethod(MethodOperator.SECOND, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)decimal, decimal));
        combination.add(new ParameterSet((EdmType)double_, double_));
        lAvailableMethods.put(MethodOperator.ROUND.toUriLiteral(), new InfoMethod(MethodOperator.ROUND, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)decimal, decimal));
        combination.add(new ParameterSet((EdmType)double_, double_));
        lAvailableMethods.put(MethodOperator.CEILING.toUriLiteral(), new InfoMethod(MethodOperator.CEILING, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)decimal, decimal));
        combination.add(new ParameterSet((EdmType)double_, double_));
        lAvailableMethods.put(MethodOperator.FLOOR.toUriLiteral(), new InfoMethod(MethodOperator.FLOOR, combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)sbyte, sbyte));
        combination.add(new ParameterSet((EdmType)byte_, byte_));
        combination.add(new ParameterSet((EdmType)int16, int16));
        combination.add(new ParameterSet((EdmType)int32, int32));
        combination.add(new ParameterSet((EdmType)int64, int64));
        combination.add(new ParameterSet((EdmType)single, single));
        combination.add(new ParameterSet((EdmType)double_, double_));
        combination.add(new ParameterSet((EdmType)decimal, decimal));
        combination.add(new ParameterSet((EdmType)null_, null_));
        lAvailableUnaryOperators.put(UnaryOperator.MINUS.toUriLiteral(), new InfoUnaryOperator(UnaryOperator.MINUS, "minus", combination));
        combination = new ParameterSetCombination.PSCflex();
        combination.add(new ParameterSet((EdmType)boolean_, boolean_));
        combination.add(new ParameterSet((EdmType)null_, null_));
        lAvailableUnaryOperators.put(UnaryOperator.NOT.toUriLiteral(), new InfoUnaryOperator(UnaryOperator.NOT, "not", combination));
        availableBinaryOperators = Collections.unmodifiableMap(lAvailableBinaryOperators);
        availableMethods = Collections.unmodifiableMap(lAvailableMethods);
        availableUnaryOperators = Collections.unmodifiableMap(lAvailableUnaryOperators);
    }

    static {
        FilterParserImpl.initAvailTables();
    }
}

