/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.api;

import org.apache.olingo.odata2.api.ODataCallback;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataErrorCallback;
import org.apache.olingo.odata2.api.processor.ODataSingleProcessor;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATransaction;
import org.apache.olingo.odata2.jpa.processor.api.OnJPAWriteContent;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAErrorCallback;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.factory.ODataJPAAccessFactory;
import org.apache.olingo.odata2.jpa.processor.api.factory.ODataJPAFactory;

public abstract class ODataJPAServiceFactory
extends ODataServiceFactory {
    private ODataJPAContext oDataJPAContext;
    private ODataContext oDataContext;
    private boolean setDetailErrors = false;
    private OnJPAWriteContent onJPAWriteContent = null;
    private ODataJPATransaction oDataJPATransaction = null;

    public abstract ODataJPAContext initializeODataJPAContext() throws ODataJPARuntimeException;

    public final ODataService createService(ODataContext ctx) throws ODataException {
        this.oDataContext = ctx;
        this.oDataJPAContext = this.initializeODataJPAContext();
        this.validatePreConditions();
        ODataJPAFactory factory = ODataJPAFactory.createFactory();
        ODataJPAAccessFactory accessFactory = factory.getODataJPAAccessFactory();
        if (this.oDataJPAContext.getODataContext() == null) {
            this.oDataJPAContext.setODataContext(ctx);
        }
        ODataSingleProcessor odataJPAProcessor = accessFactory.createODataProcessor(this.oDataJPAContext);
        EdmProvider edmProvider = accessFactory.createJPAEdmProvider(this.oDataJPAContext);
        return this.createODataSingleProcessorService(edmProvider, odataJPAProcessor);
    }

    public final ODataJPAContext getODataJPAContext() throws ODataJPARuntimeException {
        if (this.oDataJPAContext == null) {
            this.oDataJPAContext = ODataJPAFactory.createFactory().getODataJPAAccessFactory().createODataJPAContext();
        }
        if (this.oDataContext != null) {
            this.oDataJPAContext.setODataContext(this.oDataContext);
        }
        return this.oDataJPAContext;
    }

    public <T extends ODataCallback> T getCallback(Class<T> callbackInterface) {
        if (this.setDetailErrors && callbackInterface.isAssignableFrom(ODataErrorCallback.class)) {
            return (T)new ODataJPAErrorCallback();
        }
        if (this.onJPAWriteContent != null && callbackInterface.isAssignableFrom(OnJPAWriteContent.class)) {
            return (T)this.onJPAWriteContent;
        }
        if (this.oDataJPATransaction != null && callbackInterface.isAssignableFrom(ODataJPATransaction.class)) {
            return (T)this.oDataJPATransaction;
        }
        return null;
    }

    protected void setOnWriteJPAContent(OnJPAWriteContent onJPAWriteContent) {
        this.onJPAWriteContent = onJPAWriteContent;
    }

    protected void setODataJPATransaction(ODataJPATransaction oDataJPATransaction) {
        this.oDataJPATransaction = oDataJPATransaction;
    }

    protected void setDetailErrors(boolean setDetailErrors) {
        this.setDetailErrors = setDetailErrors;
    }

    private void validatePreConditions() throws ODataJPARuntimeException {
        if (this.oDataJPAContext.getEntityManagerFactory() == null) {
            throw ODataJPARuntimeException.throwException(ODataJPARuntimeException.ENTITY_MANAGER_NOT_INITIALIZED, null);
        }
    }
}

