/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.BinaryOperator;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.LiteralExpression;
import org.apache.olingo.odata2.api.uri.expression.MemberExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodOperator;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderExpression;
import org.apache.olingo.odata2.api.uri.expression.PropertyExpression;
import org.apache.olingo.odata2.api.uri.expression.SortOrder;
import org.apache.olingo.odata2.api.uri.expression.UnaryExpression;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;

public class ODataExpressionParser {
    public static final String EMPTY = "";
    public static Integer methodFlag = 0;

    public static String parseToJPAWhereExpression(CommonExpression whereExpression, String tableAlias) throws ODataException {
        switch (whereExpression.getKind()) {
            case UNARY: {
                UnaryExpression unaryExpression = (UnaryExpression)whereExpression;
                String operand = ODataExpressionParser.parseToJPAWhereExpression(unaryExpression.getOperand(), tableAlias);
                switch (unaryExpression.getOperator()) {
                    case NOT: {
                        return "NOT(" + operand + ")";
                    }
                    case MINUS: {
                        if (operand.startsWith("-")) {
                            return operand.substring(1);
                        }
                        return "-" + operand;
                    }
                }
                throw new ODataNotImplementedException();
            }
            case FILTER: {
                return ODataExpressionParser.parseToJPAWhereExpression(((FilterExpression)whereExpression).getExpression(), tableAlias);
            }
            case BINARY: {
                BinaryExpression binaryExpression = (BinaryExpression)whereExpression;
                if (binaryExpression.getLeftOperand().getKind() == ExpressionKind.METHOD && (binaryExpression.getOperator() == BinaryOperator.EQ || binaryExpression.getOperator() == BinaryOperator.NE) && ((MethodExpression)binaryExpression.getLeftOperand()).getMethod() == MethodOperator.SUBSTRINGOF) {
                    methodFlag = 1;
                }
                String left = ODataExpressionParser.parseToJPAWhereExpression(binaryExpression.getLeftOperand(), tableAlias);
                String right = ODataExpressionParser.parseToJPAWhereExpression(binaryExpression.getRightOperand(), tableAlias);
                switch (binaryExpression.getOperator()) {
                    case AND: {
                        return left + ' ' + "AND" + ' ' + right;
                    }
                    case OR: {
                        return left + ' ' + "OR" + ' ' + right;
                    }
                    case EQ: {
                        return left + ' ' + "=" + ' ' + right;
                    }
                    case NE: {
                        return left + ' ' + "<>" + ' ' + right;
                    }
                    case LT: {
                        return left + ' ' + "<" + ' ' + right;
                    }
                    case LE: {
                        return left + ' ' + "<=" + ' ' + right;
                    }
                    case GT: {
                        return left + ' ' + ">" + ' ' + right;
                    }
                    case GE: {
                        return left + ' ' + ">=" + ' ' + right;
                    }
                    case PROPERTY_ACCESS: {
                        throw new ODataNotImplementedException();
                    }
                }
                throw new ODataNotImplementedException();
            }
            case PROPERTY: {
                String returnStr = tableAlias + '.' + ((EdmProperty)((PropertyExpression)whereExpression).getEdmProperty()).getMapping().getInternalName();
                return returnStr;
            }
            case MEMBER: {
                String memberExpStr = EMPTY;
                int i = 0;
                MemberExpression member = null;
                CommonExpression tempExp = whereExpression;
                while (tempExp != null && tempExp.getKind() == ExpressionKind.MEMBER) {
                    member = (MemberExpression)tempExp;
                    if (i > 0) {
                        memberExpStr = '.' + memberExpStr;
                    }
                    ++i;
                    memberExpStr = ((EdmProperty)((PropertyExpression)member.getProperty()).getEdmProperty()).getMapping().getInternalName() + memberExpStr;
                    tempExp = member.getPath();
                }
                memberExpStr = ((EdmProperty)((PropertyExpression)tempExp).getEdmProperty()).getMapping().getInternalName() + '.' + memberExpStr;
                return tableAlias + '.' + memberExpStr;
            }
            case LITERAL: {
                LiteralExpression literal = (LiteralExpression)whereExpression;
                EdmSimpleType literalType = (EdmSimpleType)literal.getEdmType();
                String value = literalType.valueToString(literalType.valueOfString(literal.getUriLiteral(), EdmLiteralKind.URI, null, literalType.getDefaultType()), EdmLiteralKind.DEFAULT, null);
                return ODataExpressionParser.evaluateComparingExpression(value, literalType);
            }
            case METHOD: {
                MethodExpression methodExpression = (MethodExpression)whereExpression;
                String first = ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(0), tableAlias);
                String second = methodExpression.getParameterCount() > 1 ? ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(1), tableAlias) : null;
                String third = methodExpression.getParameterCount() > 2 ? ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(2), tableAlias) : null;
                switch (methodExpression.getMethod()) {
                    case SUBSTRING: {
                        third = third != null ? ", " + third : EMPTY;
                        return String.format("SUBSTRING(%s, %s + 1 %s)", first, second, third);
                    }
                    case SUBSTRINGOF: {
                        first = first.substring(1, first.length() - 1);
                        if (methodFlag == 1) {
                            methodFlag = 0;
                            return String.format("(CASE WHEN (%s LIKE '%%%s%%') THEN TRUE ELSE FALSE END)", second, first);
                        }
                        return String.format("(CASE WHEN (%s LIKE '%%%s%%') THEN TRUE ELSE FALSE END) = true", second, first);
                    }
                    case TOLOWER: {
                        return String.format("LOWER(%s)", first);
                    }
                }
                throw new ODataNotImplementedException();
            }
        }
        throw new ODataNotImplementedException();
    }

    public static String parseToJPASelectExpression(String tableAlias, ArrayList<String> selectedFields) {
        if (selectedFields == null || selectedFields.size() == 0) {
            return tableAlias;
        }
        String selectClause = EMPTY;
        Iterator<String> itr = selectedFields.iterator();
        int count = 0;
        while (itr.hasNext()) {
            selectClause = selectClause + tableAlias + '.' + itr.next();
            if (++count >= selectedFields.size()) continue;
            selectClause = selectClause + ',' + ' ';
        }
        return selectClause;
    }

    public static HashMap<String, String> parseToJPAOrderByExpression(OrderByExpression orderByExpression, String tableAlias) throws ODataJPARuntimeException {
        HashMap<String, String> orderByMap = new HashMap<String, String>();
        if (orderByExpression != null && orderByExpression.getOrders() != null) {
            List orderBys = orderByExpression.getOrders();
            String orderByField = null;
            String orderByDirection = null;
            for (OrderExpression orderBy : orderBys) {
                try {
                    orderByField = ((EdmProperty)((PropertyExpression)orderBy.getExpression()).getEdmProperty()).getMapping().getInternalName();
                    orderByDirection = orderBy.getSortOrder() == SortOrder.asc ? EMPTY : "DESC";
                    orderByMap.put(tableAlias + '.' + orderByField, orderByDirection);
                }
                catch (EdmException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
        }
        return orderByMap;
    }

    public static String parseKeyPredicates(List<KeyPredicate> keyPredicates, String tableAlias) throws ODataJPARuntimeException {
        String literal = null;
        String propertyName = null;
        EdmSimpleType edmSimpleType = null;
        StringBuilder keyFilters = new StringBuilder();
        int i = 0;
        for (KeyPredicate keyPredicate : keyPredicates) {
            if (i > 0) {
                keyFilters.append(" AND ");
            }
            ++i;
            literal = keyPredicate.getLiteral();
            try {
                propertyName = keyPredicate.getProperty().getMapping().getInternalName();
                edmSimpleType = (EdmSimpleType)keyPredicate.getProperty().getType();
            }
            catch (EdmException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
            literal = ODataExpressionParser.evaluateComparingExpression(literal, edmSimpleType);
            if (edmSimpleType == EdmSimpleTypeKind.DateTime.getEdmSimpleTypeInstance() || edmSimpleType == EdmSimpleTypeKind.DateTimeOffset.getEdmSimpleTypeInstance()) {
                literal = literal.substring(literal.indexOf(39), literal.indexOf(125));
            }
            keyFilters.append(tableAlias + '.' + propertyName + ' ' + "=" + ' ' + literal);
        }
        if (keyFilters.length() > 0) {
            return keyFilters.toString();
        }
        return null;
    }

    private static String evaluateComparingExpression(String value, EdmSimpleType edmSimpleType) throws ODataJPARuntimeException {
        if (edmSimpleType == EdmSimpleTypeKind.String.getEdmSimpleTypeInstance() || edmSimpleType == EdmSimpleTypeKind.Guid.getEdmSimpleTypeInstance()) {
            value = "'" + value + "'";
        } else if (edmSimpleType == EdmSimpleTypeKind.DateTime.getEdmSimpleTypeInstance() || edmSimpleType == EdmSimpleTypeKind.DateTimeOffset.getEdmSimpleTypeInstance()) {
            try {
                Calendar datetime = (Calendar)edmSimpleType.valueOfString(value, EdmLiteralKind.DEFAULT, null, edmSimpleType.getDefaultType());
                String year = String.format("%04d", datetime.get(1));
                String month = String.format("%02d", datetime.get(2) + 1);
                String day = String.format("%02d", datetime.get(5));
                String hour = String.format("%02d", datetime.get(11));
                String min = String.format("%02d", datetime.get(12));
                String sec = String.format("%02d", datetime.get(13));
                value = "{ts '" + year + '-' + month + '-' + day + ' ' + hour + ':' + min + ':' + sec + ".000" + "'" + '}';
            }
            catch (EdmSimpleTypeException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
        } else if (edmSimpleType == EdmSimpleTypeKind.Time.getEdmSimpleTypeInstance()) {
            try {
                Calendar time = (Calendar)edmSimpleType.valueOfString(value, EdmLiteralKind.DEFAULT, null, edmSimpleType.getDefaultType());
                String hourValue = String.format("%02d", time.get(11));
                String minValue = String.format("%02d", time.get(12));
                String secValue = String.format("%02d", time.get(13));
                value = "'" + hourValue + ':' + minValue + ':' + secValue + "'";
            }
            catch (EdmSimpleTypeException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
        } else if (edmSimpleType == EdmSimpleTypeKind.Int64.getEdmSimpleTypeInstance()) {
            value = value + 'L';
        }
        return value;
    }

    public static HashMap<String, String> parseKeyPropertiesToJPAOrderByExpression(List<EdmProperty> edmPropertylist, String tableAlias) throws ODataJPARuntimeException {
        HashMap<String, String> orderByMap = new HashMap<String, String>();
        String propertyName = null;
        for (EdmProperty edmProperty : edmPropertylist) {
            try {
                EdmMapping mapping = edmProperty.getMapping();
                propertyName = mapping != null && mapping.getInternalName() != null ? mapping.getInternalName() : edmProperty.getName();
            }
            catch (EdmException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
            orderByMap.put(tableAlias + '.' + propertyName, EMPTY);
        }
        return orderByMap;
    }
}

