/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmStructuralType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.ep.entry.EntryMetadata;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.OnJPAWriteContent;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAEntityParser;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPALink;

public class JPAEntity {
    private Object jpaEntity = null;
    private JPAEntity parentJPAEntity = null;
    private EdmEntityType oDataEntityType = null;
    private EdmEntitySet oDataEntitySet = null;
    private Class<?> jpaType = null;
    private HashMap<String, Method> accessModifiersWrite = null;
    private JPAEntityParser jpaEntityParser = null;
    private ODataJPAContext oDataJPAContext;
    private OnJPAWriteContent onJPAWriteContent = null;
    public HashMap<String, List<Object>> relatedJPAEntityMap = null;

    public JPAEntity(EdmEntityType oDataEntityType, EdmEntitySet oDataEntitySet, ODataJPAContext context) {
        this.oDataEntityType = oDataEntityType;
        this.oDataEntitySet = oDataEntitySet;
        this.oDataJPAContext = context;
        try {
            JPAEdmMapping mapping = (JPAEdmMapping)oDataEntityType.getMapping();
            this.jpaType = mapping.getJPAType();
        }
        catch (EdmException e) {
            return;
        }
        this.jpaEntityParser = new JPAEntityParser();
        this.onJPAWriteContent = (OnJPAWriteContent)this.oDataJPAContext.getODataContext().getServiceFactory().getCallback(OnJPAWriteContent.class);
    }

    public void setAccessModifersWrite(HashMap<String, Method> accessModifiersWrite) {
        this.accessModifiersWrite = accessModifiersWrite;
    }

    public void setParentJPAEntity(JPAEntity jpaEntity) {
        this.parentJPAEntity = jpaEntity;
    }

    public JPAEntity getParentJPAEntity() {
        return this.parentJPAEntity;
    }

    public Object getJPAEntity() {
        return this.jpaEntity;
    }

    private void write(Map<String, Object> oDataEntryProperties, boolean isCreate) throws ODataJPARuntimeException {
        try {
            EdmStructuralType structuralType = null;
            List keyNames = this.oDataEntityType.getKeyPropertyNames();
            if (isCreate) {
                this.jpaEntity = this.instantiateJPAEntity();
            } else if (this.jpaEntity == null) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.RESOURCE_NOT_FOUND, null);
            }
            if (this.accessModifiersWrite == null) {
                this.accessModifiersWrite = this.jpaEntityParser.getAccessModifiers(this.jpaEntity, (EdmStructuralType)this.oDataEntityType, "set");
            }
            if (this.oDataEntityType == null || oDataEntryProperties == null) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, null);
            }
            HashMap<String, String> embeddableKeys = this.jpaEntityParser.getJPAEmbeddableKeyMap(this.jpaEntity.getClass().getName());
            Set<String> propertyNames = null;
            if (embeddableKeys != null) {
                this.setEmbeddableKeyProperty(embeddableKeys, this.oDataEntityType.getKeyProperties(), oDataEntryProperties, this.jpaEntity);
                propertyNames = new HashSet<String>();
                propertyNames.addAll(oDataEntryProperties.keySet());
                for (String key : embeddableKeys.keySet()) {
                    propertyNames.remove(key);
                }
            } else {
                propertyNames = oDataEntryProperties.keySet();
            }
            block8: for (String propertyName : propertyNames) {
                EdmTyped edmTyped = this.oDataEntityType.getProperty(propertyName);
                Method accessModifier = null;
                switch (edmTyped.getType().getKind()) {
                    case SIMPLE: {
                        if (!isCreate && keyNames.contains(edmTyped.getName())) break;
                        accessModifier = this.accessModifiersWrite.get(propertyName);
                        this.setProperty(accessModifier, this.jpaEntity, oDataEntryProperties.get(propertyName), (EdmSimpleType)edmTyped.getType());
                        continue block8;
                    }
                    case COMPLEX: {
                        structuralType = (EdmStructuralType)edmTyped.getType();
                        accessModifier = this.accessModifiersWrite.get(propertyName);
                        this.setComplexProperty(accessModifier, this.jpaEntity, structuralType, (HashMap)oDataEntryProperties.get(propertyName));
                        continue block8;
                    }
                    case NAVIGATION: 
                    case ENTITY: {
                        if (!isCreate) break;
                        structuralType = (EdmStructuralType)edmTyped.getType();
                        EdmNavigationProperty navProperty = (EdmNavigationProperty)edmTyped;
                        EdmEntitySet edmRelatedEntitySet = this.oDataEntitySet.getRelatedEntitySet(navProperty);
                        List relatedEntries = (List)oDataEntryProperties.get(propertyName);
                        if (this.relatedJPAEntityMap == null) {
                            this.relatedJPAEntityMap = new HashMap();
                        }
                        ArrayList<Object> relatedJPAEntities = new ArrayList<Object>();
                        JPAEntity relatedEntity = new JPAEntity((EdmEntityType)structuralType, edmRelatedEntitySet, this.oDataJPAContext);
                        for (ODataEntry oDataEntry : relatedEntries) {
                            relatedEntity.setParentJPAEntity(this);
                            relatedEntity.create(oDataEntry);
                            relatedJPAEntities.add(relatedEntity.getJPAEntity());
                        }
                        this.relatedJPAEntityMap.put(navProperty.getName(), relatedJPAEntities);
                    }
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ODataJPARuntimeException) {
                throw (ODataJPARuntimeException)e;
            }
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    public void create(ODataEntry oDataEntry) throws ODataJPARuntimeException {
        if (oDataEntry == null) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, null);
        }
        Map oDataEntryProperties = oDataEntry.getProperties();
        if (oDataEntry.containsInlineEntry()) {
            this.normalizeInlineEntries(oDataEntryProperties);
        }
        this.write(oDataEntryProperties, true);
        EntryMetadata entryMetadata = oDataEntry.getMetadata();
        ArrayList<String> leftNavPrpNames = new ArrayList<String>();
        try {
            for (String navigationPropertyName : this.oDataEntityType.getNavigationPropertyNames()) {
                List links = entryMetadata.getAssociationUris(navigationPropertyName);
                if (links.isEmpty()) continue;
                EdmNavigationProperty navProperty = (EdmNavigationProperty)this.oDataEntityType.getProperty(navigationPropertyName);
                if (this.relatedJPAEntityMap != null && this.relatedJPAEntityMap.containsKey(navigationPropertyName)) {
                    JPALink.linkJPAEntities((Collection<Object>)this.relatedJPAEntityMap.get(navigationPropertyName), this.jpaEntity, navProperty);
                    continue;
                }
                if (this.parentJPAEntity != null && this.parentJPAEntity.getEdmEntitySet().getName().equals(this.oDataEntitySet.getRelatedEntitySet(navProperty).getName())) {
                    ArrayList<Object> targetJPAEntities = new ArrayList<Object>();
                    targetJPAEntities.add(this.parentJPAEntity.getJPAEntity());
                    JPALink.linkJPAEntities(targetJPAEntities, this.jpaEntity, navProperty);
                    continue;
                }
                leftNavPrpNames.add(navigationPropertyName);
            }
            if (!leftNavPrpNames.isEmpty()) {
                JPALink link = new JPALink(this.oDataJPAContext);
                link.setSourceJPAEntity(this.jpaEntity);
                link.create(this.oDataEntitySet, oDataEntry, leftNavPrpNames);
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (ODataJPAModelException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    public EdmEntitySet getEdmEntitySet() {
        return this.oDataEntitySet;
    }

    public void create(Map<String, Object> oDataEntryProperties) throws ODataJPARuntimeException {
        this.normalizeInlineEntries(oDataEntryProperties);
        this.write(oDataEntryProperties, true);
    }

    public void update(ODataEntry oDataEntry) throws ODataJPARuntimeException {
        if (oDataEntry == null) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, null);
        }
        Map oDataEntryProperties = oDataEntry.getProperties();
        if (oDataEntry.containsInlineEntry()) {
            this.normalizeInlineEntries(oDataEntryProperties);
        }
        this.write(oDataEntryProperties, false);
        JPALink link = new JPALink(this.oDataJPAContext);
        link.setSourceJPAEntity(this.jpaEntity);
        try {
            link.create(this.oDataEntitySet, oDataEntry, this.oDataEntityType.getNavigationPropertyNames());
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (ODataJPAModelException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    public void update(Map<String, Object> oDataEntryProperties) throws ODataJPARuntimeException {
        this.normalizeInlineEntries(oDataEntryProperties);
        this.write(oDataEntryProperties, false);
    }

    public void setJPAEntity(Object jpaEntity) {
        this.jpaEntity = jpaEntity;
    }

    protected void setComplexProperty(Method accessModifier, Object jpaEntity, EdmStructuralType edmComplexType, HashMap<String, Object> propertyValue) throws EdmException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException, ODataJPARuntimeException, NoSuchMethodException, SecurityException, SQLException {
        JPAEdmMapping mapping = (JPAEdmMapping)edmComplexType.getMapping();
        Object embeddableObject = mapping.getJPAType().newInstance();
        accessModifier.invoke(jpaEntity, embeddableObject);
        HashMap<String, Method> accessModifiers = this.jpaEntityParser.getAccessModifiers(embeddableObject, edmComplexType, "set");
        for (String edmPropertyName : edmComplexType.getPropertyNames()) {
            EdmTyped edmTyped = edmComplexType.getProperty(edmPropertyName);
            accessModifier = accessModifiers.get(edmPropertyName);
            if (edmTyped.getType().getKind().toString().equals(EdmTypeKind.COMPLEX.toString())) {
                EdmStructuralType structualType = (EdmStructuralType)edmTyped.getType();
                this.setComplexProperty(accessModifier, embeddableObject, structualType, (HashMap)propertyValue.get(edmPropertyName));
                continue;
            }
            this.setProperty(accessModifier, embeddableObject, propertyValue.get(edmPropertyName), (EdmSimpleType)edmTyped.getType());
        }
    }

    protected void setProperty(Method method, Object entity, Object entityPropertyValue, EdmSimpleType type) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ODataJPARuntimeException {
        if (entityPropertyValue != null) {
            Class<?> parameterType = method.getParameterTypes()[0];
            if (type != null && type.getDefaultType().equals(String.class)) {
                if (parameterType.equals(String.class)) {
                    method.invoke(entity, entityPropertyValue);
                } else if (parameterType.equals(char[].class)) {
                    char[] characters = ((String)entityPropertyValue).toCharArray();
                    method.invoke(entity, new Object[]{characters});
                } else if (parameterType.equals(Character.TYPE)) {
                    char c = ((String)entityPropertyValue).charAt(0);
                    method.invoke(entity, Character.valueOf(c));
                } else if (parameterType.equals(Character[].class)) {
                    Character[] characters = JPAEntityParser.toCharacterArray((String)entityPropertyValue);
                    method.invoke(entity, new Object[]{characters});
                } else if (parameterType.equals(Character.class)) {
                    Character c = Character.valueOf(((String)entityPropertyValue).charAt(0));
                    method.invoke(entity, c);
                }
            } else if (parameterType.equals(Blob.class)) {
                if (this.onJPAWriteContent == null) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPA_BLOB_NULL, null);
                }
                method.invoke(entity, this.onJPAWriteContent.getJPABlob((byte[])entityPropertyValue));
            } else if (parameterType.equals(Clob.class)) {
                if (this.onJPAWriteContent == null) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPA_CLOB_NULL, null);
                }
                method.invoke(entity, this.onJPAWriteContent.getJPAClob(((String)entityPropertyValue).toCharArray()));
            } else if (parameterType.equals(Timestamp.class)) {
                Timestamp ts = new Timestamp(((Calendar)entityPropertyValue).getTimeInMillis());
                method.invoke(entity, ts);
            } else {
                method.invoke(entity, entityPropertyValue);
            }
        }
    }

    protected void setEmbeddableKeyProperty(HashMap<String, String> embeddableKeys, List<EdmProperty> oDataEntryKeyProperties, Map<String, Object> oDataEntryProperties, Object entity) throws ODataJPARuntimeException, EdmException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        HashMap embeddableObjMap = new HashMap();
        ArrayList<EdmProperty> leftODataEntryKeyProperties = new ArrayList<EdmProperty>();
        HashMap<String, String> leftEmbeddableKeys = new HashMap<String, String>();
        for (EdmProperty edmProperty : oDataEntryKeyProperties) {
            String edmPropertyName;
            String embeddableKeyNameComposite;
            if (!oDataEntryProperties.containsKey(edmProperty.getName()) || (embeddableKeyNameComposite = embeddableKeys.get(edmPropertyName = edmProperty.getName())) == null) continue;
            String[] embeddableKeyNameSplit = embeddableKeyNameComposite.split("\\.");
            String methodPartName = null;
            Method method = null;
            Object embeddableObj = null;
            if (!embeddableObjMap.containsKey(embeddableKeyNameSplit[0])) {
                methodPartName = embeddableKeyNameSplit[0];
                method = this.jpaEntityParser.getAccessModifierSet(entity, methodPartName);
                embeddableObj = method.getParameterTypes()[0].newInstance();
                method.invoke(entity, embeddableObj);
                embeddableObjMap.put(embeddableKeyNameSplit[0], embeddableObj);
            } else {
                embeddableObj = embeddableObjMap.get(embeddableKeyNameSplit[0]);
            }
            if (embeddableKeyNameSplit.length == 2) {
                methodPartName = embeddableKeyNameSplit[1];
                method = this.jpaEntityParser.getAccessModifierSet(embeddableObj, methodPartName);
                Object simpleObj = oDataEntryProperties.get(edmProperty.getName());
                method.invoke(embeddableObj, simpleObj);
                continue;
            }
            if (embeddableKeyNameSplit.length <= 2) continue;
            leftODataEntryKeyProperties.add(edmProperty);
            leftEmbeddableKeys.put(edmPropertyName, embeddableKeyNameComposite.split(embeddableKeyNameSplit[0] + ".", 2)[1]);
        }
    }

    protected Object instantiateJPAEntity() throws InstantiationException, IllegalAccessException {
        if (this.jpaType == null) {
            throw new InstantiationException();
        }
        return this.jpaType.newInstance();
    }

    private void normalizeInlineEntries(Map<String, Object> oDataEntryProperties) throws ODataJPARuntimeException {
        ArrayList<ODataEntry> entries = null;
        try {
            for (String navigationPropertyName : this.oDataEntityType.getNavigationPropertyNames()) {
                Object inline = oDataEntryProperties.get(navigationPropertyName);
                if (inline instanceof ODataFeed) {
                    entries = ((ODataFeed)inline).getEntries();
                } else if (inline instanceof ODataEntry) {
                    entries = new ArrayList<ODataEntry>();
                    entries.add((ODataEntry)inline);
                }
                if (entries == null) continue;
                oDataEntryProperties.put(navigationPropertyName, entries);
                entries = null;
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }
}

