/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmParameter;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAFunction;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAMethodContext;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;

public class JPAFunctionContext
extends JPAMethodContext {

    public class JPAFunctionContextBuilder
    extends JPAMethodContext.JPAMethodContextBuilder {
        protected GetFunctionImportUriInfo functiontView;
        private EdmFunctionImport functionImport;
        private EdmMapping mapping;

        public JPAMethodContext build() throws ODataJPAModelException, ODataJPARuntimeException {
            if (this.functiontView != null) {
                this.functionImport = this.functiontView.getFunctionImport();
                try {
                    this.mapping = this.functionImport.getMapping();
                    ArrayList<JPAFunction> jpaFunctionList = new ArrayList<JPAFunction>();
                    jpaFunctionList.add(this.generateJPAFunction());
                    JPAFunctionContext.this.setJpaFunction(jpaFunctionList);
                    JPAFunctionContext.this.setEnclosingObject(this.generateEnclosingObject());
                }
                catch (EdmException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (InstantiationException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (SecurityException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
            return JPAFunctionContext.this;
        }

        private JPAFunction generateJPAFunction() throws EdmException, NoSuchMethodException, SecurityException, ODataJPAModelException, ODataJPARuntimeException {
            Class[] parameterTypes = this.getParameterTypes();
            Method method = this.getMethod(parameterTypes);
            Type returnType = this.getReturnType();
            Object[] args = this.getAruguments();
            JPAFunction jpafunction = new JPAFunction(method, parameterTypes, returnType, args);
            return jpafunction;
        }

        private Object[] getAruguments() throws EdmException {
            Map edmArguements = this.functiontView.getFunctionImportParameters();
            if (edmArguements == null) {
                return null;
            }
            Object[] args = new Object[edmArguements.size()];
            int i = 0;
            for (String paramName : this.functionImport.getParameterNames()) {
                EdmLiteral literal = (EdmLiteral)edmArguements.get(paramName);
                EdmParameter parameter = this.functionImport.getParameter(paramName);
                JPAEdmMapping mapping = (JPAEdmMapping)parameter.getMapping();
                args[i] = this.convertArguement(literal, parameter.getFacets(), mapping.getJPAType());
                ++i;
            }
            return args;
        }

        private Object convertArguement(EdmLiteral edmLiteral, EdmFacets facets, Class<?> targetType) throws EdmSimpleTypeException {
            EdmSimpleType edmType = edmLiteral.getType();
            Object value = edmType.valueOfString(edmLiteral.getLiteral(), EdmLiteralKind.DEFAULT, facets, targetType);
            return value;
        }

        private Class<?>[] getParameterTypes() throws EdmException {
            Class[] parameterTypes = new Class[this.functionImport.getParameterNames().size()];
            int i = 0;
            for (String parameterName : this.functionImport.getParameterNames()) {
                EdmParameter parameter = this.functionImport.getParameter(parameterName);
                parameterTypes[i] = ((JPAEdmMapping)parameter.getMapping()).getJPAType();
                ++i;
            }
            return parameterTypes;
        }

        private Method getMethod(Class<?>[] parameterTypes) throws NoSuchMethodException, SecurityException {
            Class type = ((JPAEdmMapping)this.mapping).getJPAType();
            Method method = type.getMethod(this.mapping.getInternalName(), parameterTypes);
            return method;
        }

        private Type getReturnType() throws ODataJPAModelException, ODataJPARuntimeException, EdmException {
            return null;
        }

        private Object generateEnclosingObject() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
            Class type = ((JPAEdmMapping)this.mapping).getJPAType();
            Object[] params = null;
            return type.getConstructor((Class[])params).newInstance(params);
        }

        protected void setResultsView(Object resultsView) {
            if (resultsView instanceof GetFunctionImportUriInfo) {
                this.functiontView = (GetFunctionImportUriInfo)resultsView;
            }
        }
    }
}

