/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.NavigationSegment;
import org.apache.olingo.odata2.api.uri.PathSegment;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAProcessor;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.factory.ODataJPAFactory;
import org.apache.olingo.odata2.jpa.processor.core.ODataEntityParser;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAEntityParser;

public class JPALink {
    private static final String SPACE = " ";
    private static final String ODATA_COMMAND_FILTER = "$filter";
    private static final String ODATA_OPERATOR_AND = "and";
    private static final String ODATA_OPERATOR_NE = "ne";
    private ODataJPAContext context;
    private JPAProcessor jpaProcessor;
    private ODataEntityParser parser;
    private Object targetJPAEntity;
    private Object sourceJPAEntity;

    public JPALink(ODataJPAContext context) {
        this.context = context;
        this.jpaProcessor = ODataJPAFactory.createFactory().getJPAAccessFactory().getJPAProcessor(this.context);
        this.parser = new ODataEntityParser(this.context);
    }

    public void setSourceJPAEntity(Object jpaEntity) {
        this.sourceJPAEntity = jpaEntity;
    }

    public void setTargetJPAEntity(Object jpaEntity) {
        this.targetJPAEntity = jpaEntity;
    }

    public Object getTargetJPAEntity() {
        return this.targetJPAEntity;
    }

    public Object getSourceJPAEntity() {
        return this.sourceJPAEntity;
    }

    public void create(PostUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataJPARuntimeException, ODataJPAModelException {
        this.modifyLink((UriInfo)uriInfo, content, requestContentType, contentType);
    }

    public void update(PutMergePatchUriInfo putUriInfo, InputStream content, String requestContentType, String contentType) throws ODataJPARuntimeException, ODataJPAModelException {
        this.modifyLink((UriInfo)putUriInfo, content, requestContentType, contentType);
    }

    public void delete(DeleteUriInfo uriInfo) throws ODataJPARuntimeException {
        try {
            int index = this.context.getODataContext().getPathInfo().getODataSegments().size() - 2;
            ArrayList<String> linkSegments = new ArrayList<String>();
            String customLinkSegment = ((PathSegment)this.context.getODataContext().getPathInfo().getODataSegments().get(0)).getPath();
            linkSegments.add(customLinkSegment);
            customLinkSegment = ((NavigationSegment)uriInfo.getNavigationSegments().get(0)).getNavigationProperty().getName();
            linkSegments.add(customLinkSegment);
            HashMap<String, String> options = new HashMap<String, String>();
            List keyPredicates = ((NavigationSegment)uriInfo.getNavigationSegments().get(0)).getKeyPredicates();
            StringBuffer condition = new StringBuffer();
            String literal = null;
            KeyPredicate keyPredicate = null;
            int size = keyPredicates.size();
            for (int i = 0; i < size; ++i) {
                keyPredicate = (KeyPredicate)keyPredicates.get(i);
                literal = ((EdmSimpleType)keyPredicate.getProperty().getType()).toUriLiteral(keyPredicate.getLiteral());
                condition.append(keyPredicate.getProperty().getName()).append(SPACE);
                condition.append(ODATA_OPERATOR_NE).append(SPACE);
                condition.append(literal).append(SPACE);
                if (i == size - 1) continue;
                condition.append(ODATA_OPERATOR_AND).append(SPACE);
            }
            options.put(ODATA_COMMAND_FILTER, condition.toString());
            UriInfo parsedUriInfo = this.parser.parseLinkSegments(linkSegments, options);
            List relatedEntities = this.jpaProcessor.process((GetEntitySetUriInfo)parsedUriInfo);
            parsedUriInfo = this.parser.parseURISegment(0, index);
            if (parsedUriInfo != null) {
                this.targetJPAEntity = this.jpaProcessor.process((GetEntityUriInfo)parsedUriInfo);
                if (this.targetJPAEntity == null) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.RESOURCE_X_NOT_FOUND.addContent(new Object[]{parsedUriInfo.getTargetEntitySet().getName()}), null);
                }
                NavigationSegment navigationSegment = (NavigationSegment)uriInfo.getNavigationSegments().get(0);
                EdmNavigationProperty navigationProperty = navigationSegment.getNavigationProperty();
                this.delinkJPAEntities(this.targetJPAEntity, relatedEntities, navigationProperty);
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    private void delinkJPAEntities(Object jpaEntity, List<Object> relatedJPAEntities, EdmNavigationProperty targetNavigationProperty) throws ODataJPARuntimeException {
        try {
            JPAEntityParser entityParser = new JPAEntityParser();
            Method setMethod = entityParser.getAccessModifier(jpaEntity.getClass(), targetNavigationProperty, "set");
            Method getMethod = entityParser.getAccessModifier(jpaEntity.getClass(), targetNavigationProperty, "get");
            if (getMethod.getReturnType().getTypeParameters() != null && getMethod.getReturnType().getTypeParameters().length != 0) {
                setMethod.invoke(jpaEntity, relatedJPAEntities);
            } else {
                setMethod.invoke(jpaEntity, new Object[]{null});
            }
        }
        catch (IllegalAccessException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
    }

    public void save() {
        EntityManager em = this.context.getEntityManager();
        EntityTransaction tx = em.getTransaction();
        if (!tx.isActive()) {
            em.getTransaction().begin();
            if (this.sourceJPAEntity != null) {
                em.persist(this.sourceJPAEntity);
            }
            if (this.targetJPAEntity != null) {
                em.persist(this.targetJPAEntity);
                em.flush();
            }
            em.getTransaction().commit();
        }
    }

    public void create(EdmEntitySet entitySet, ODataEntry oDataEntry, List<String> navigationPropertyNames) throws ODataJPARuntimeException, ODataJPAModelException {
        try {
            for (String navPropertyName : navigationPropertyNames) {
                List links = oDataEntry.getMetadata().getAssociationUris(navPropertyName);
                if (links == null || links.isEmpty()) continue;
                EdmNavigationProperty navProperty = (EdmNavigationProperty)entitySet.getEntityType().getProperty(navPropertyName);
                for (String link : links) {
                    UriInfo bindingUriInfo = this.parser.parseBindingLink(link, new HashMap<String, String>());
                    this.targetJPAEntity = this.jpaProcessor.process((GetEntityUriInfo)bindingUriInfo);
                    ArrayList<Object> targetJPAEntities = new ArrayList<Object>();
                    targetJPAEntities.add(this.targetJPAEntity);
                    JPALink.linkJPAEntities(targetJPAEntities, this.sourceJPAEntity, navProperty);
                }
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    public void create(PostUriInfo uriInfo) throws ODataJPARuntimeException, ODataJPAModelException {
        try {
            int index = this.context.getODataContext().getPathInfo().getODataSegments().size() - 2;
            UriInfo parsedUriInfo = this.parser.parseURISegment(index, index + 1);
            Object targetJPAEntity = null;
            if (parsedUriInfo != null) {
                targetJPAEntity = this.jpaProcessor.process((GetEntityUriInfo)parsedUriInfo);
                if (targetJPAEntity == null) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.RESOURCE_X_NOT_FOUND.addContent(new Object[]{parsedUriInfo.getTargetEntitySet().getName()}), null);
                }
                ArrayList<Object> targetJPAEntities = new ArrayList<Object>();
                targetJPAEntities.add(this.sourceJPAEntity);
                JPALink.linkJPAEntities(targetJPAEntities, targetJPAEntity, ((NavigationSegment)uriInfo.getNavigationSegments().get(0)).getNavigationProperty());
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    private void modifyLink(UriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataJPARuntimeException, ODataJPAModelException {
        try {
            EdmEntitySet targetEntitySet = uriInfo.getTargetEntitySet();
            String targerEntitySetName = targetEntitySet.getName();
            EdmNavigationProperty navigationProperty = null;
            UriInfo getUriInfo = null;
            if (!uriInfo.isLinks()) {
                return;
            }
            getUriInfo = this.parser.parseLink(targetEntitySet, content, requestContentType);
            navigationProperty = ((NavigationSegment)uriInfo.getNavigationSegments().get(0)).getNavigationProperty();
            if (!getUriInfo.getTargetEntitySet().getName().equals(targerEntitySetName)) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.RELATIONSHIP_INVALID, null);
            }
            this.targetJPAEntity = this.jpaProcessor.process((GetEntityUriInfo)getUriInfo);
            if (this.targetJPAEntity != null && this.sourceJPAEntity == null) {
                int index = this.context.getODataContext().getPathInfo().getODataSegments().size() - 2;
                getUriInfo = this.parser.parseURISegment(0, index);
                this.sourceJPAEntity = this.jpaProcessor.process((GetEntityUriInfo)getUriInfo);
                if (this.sourceJPAEntity == null) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.RESOURCE_X_NOT_FOUND.addContent(new Object[]{getUriInfo.getTargetEntitySet().getName()}), null);
                }
            }
            if (this.targetJPAEntity != null && this.sourceJPAEntity != null) {
                ArrayList<Object> targetJPAEntities = new ArrayList<Object>();
                targetJPAEntities.add(this.targetJPAEntity);
                JPALink.linkJPAEntities(targetJPAEntities, this.sourceJPAEntity, navigationProperty);
            }
        }
        catch (IllegalArgumentException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (ODataException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    public static void linkJPAEntities(Collection<Object> targetJPAEntities, Object sourceJPAEntity, EdmNavigationProperty navigationProperty) throws ODataJPARuntimeException {
        if (targetJPAEntities == null || sourceJPAEntity == null || navigationProperty == null) {
            return;
        }
        try {
            JPAEntityParser entityParser = new JPAEntityParser();
            Method setMethod = entityParser.getAccessModifier(sourceJPAEntity.getClass(), navigationProperty, "set");
            switch (navigationProperty.getMultiplicity()) {
                case MANY: {
                    Method getMethod = entityParser.getAccessModifier(sourceJPAEntity.getClass(), navigationProperty, "get");
                    Collection relatedEntities = (Collection)getMethod.invoke(sourceJPAEntity, new Object[0]);
                    relatedEntities.addAll(targetJPAEntities);
                    setMethod.invoke(sourceJPAEntity, relatedEntities);
                    break;
                }
                case ONE: 
                case ZERO_TO_ONE: {
                    setMethod.invoke(sourceJPAEntity, targetJPAEntities.iterator().next());
                }
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.INNER_EXCEPTION, (Throwable)e);
        }
    }
}

