/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.data;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityLinkUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetLinksUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPATombstoneEntityListener;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAFunction;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAMethodContext;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAPaging;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAProcessor;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContext;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLStatement;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmMapping;
import org.apache.olingo.odata2.jpa.processor.core.ODataEntityParser;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAEntity;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPALink;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAPage;

public class JPAProcessorImpl
implements JPAProcessor {
    ODataJPAContext oDataJPAContext;
    EntityManager em;

    public JPAProcessorImpl(ODataJPAContext oDataJPAContext) {
        this.oDataJPAContext = oDataJPAContext;
        this.em = oDataJPAContext.getEntityManager();
    }

    public List<Object> process(GetFunctionImportUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        JPAMethodContext jpaMethodContext = JPAMethodContext.createBuilder((JPQLContextType)JPQLContextType.FUNCTION, (Object)uriParserResultView).build();
        ArrayList<Object> resultObj = null;
        try {
            JPAFunction jpaFunction = (JPAFunction)jpaMethodContext.getJPAFunctionList().get(0);
            Method method = jpaFunction.getFunction();
            Object[] args = jpaFunction.getArguments();
            if (uriParserResultView.getFunctionImport().getReturnType().getMultiplicity().equals((Object)EdmMultiplicity.MANY)) {
                resultObj = (List)method.invoke(jpaMethodContext.getEnclosingObject(), args);
            } else {
                resultObj = new ArrayList();
                Object result = method.invoke(jpaMethodContext.getEnclosingObject(), args);
                resultObj.add(result);
            }
        }
        catch (EdmException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getTargetException().getMessage()}), (Throwable)e.getTargetException());
        }
        return resultObj;
    }

    public List<Object> process(GetEntitySetUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        if (uriParserResultView.getFunctionImport() != null) {
            return this.process((GetFunctionImportUriInfo)uriParserResultView);
        }
        JPQLContextType contextType = null;
        try {
            contextType = !uriParserResultView.getStartEntitySet().getName().equals(uriParserResultView.getTargetEntitySet().getName()) ? JPQLContextType.JOIN : JPQLContextType.SELECT;
            JPQLContext jpqlContext = null;
            jpqlContext = this.oDataJPAContext.getPageSize() > 0 ? JPQLContext.createBuilder((JPQLContextType)contextType, (Object)uriParserResultView, (boolean)true).build() : JPQLContext.createBuilder((JPQLContextType)contextType, (Object)uriParserResultView).build();
            JPQLStatement jpqlStatement = JPQLStatement.createBuilder((JPQLContextView)jpqlContext).build();
            Map customQueryOptions = uriParserResultView.getCustomQueryOptions();
            String deltaToken = null;
            if (customQueryOptions != null) {
                deltaToken = (String)uriParserResultView.getCustomQueryOptions().get("!deltatoken");
            }
            if (deltaToken != null) {
                ODataJPATombstoneContext.setDeltaToken(deltaToken);
            }
            Query query = null;
            List<Object> result = null;
            JPAEdmMapping mapping = (JPAEdmMapping)uriParserResultView.getTargetEntitySet().getEntityType().getMapping();
            ODataJPATombstoneEntityListener listener = null;
            if (mapping.getODataJPATombstoneEntityListener() != null) {
                listener = (ODataJPATombstoneEntityListener)mapping.getODataJPATombstoneEntityListener().newInstance();
                query = listener.getQuery(uriParserResultView, this.em);
            }
            if (query == null) {
                query = this.em.createQuery(jpqlStatement.toString());
                if (listener != null) {
                    query.getResultList();
                    List deltaResult = ODataJPATombstoneContext.getDeltaResult((String)((EdmMapping)mapping).getInternalName());
                    result = this.handlePaging(deltaResult, uriParserResultView);
                } else {
                    result = this.handlePaging(query, uriParserResultView);
                }
            } else {
                result = this.handlePaging(query, uriParserResultView);
            }
            if (listener != null) {
                ODataJPATombstoneContext.setDeltaToken((String)listener.generateDeltaToken(result, query));
            }
            return result == null ? new ArrayList() : result;
        }
        catch (Exception e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
    }

    private List<Object> handlePaging(List<Object> result, GetEntitySetUriInfo uriParserResultView) {
        if (result == null) {
            return null;
        }
        JPAPage.JPAPageBuilder pageBuilder = new JPAPage.JPAPageBuilder();
        pageBuilder.pageSize(this.oDataJPAContext.getPageSize()).entities(result).skipToken(uriParserResultView.getSkipToken());
        if (uriParserResultView.getSkip() != null && uriParserResultView.getInlineCount() == null) {
            pageBuilder.skip(uriParserResultView.getSkip());
        }
        if (uriParserResultView.getTop() != null && uriParserResultView.getInlineCount() == null) {
            pageBuilder.top(uriParserResultView.getTop());
        }
        JPAPage page = pageBuilder.build();
        this.oDataJPAContext.setPaging((JPAPaging)page);
        return page.getPagedEntities();
    }

    private List<Object> handlePaging(Query query, GetEntitySetUriInfo uriParserResultView) {
        JPAPage.JPAPageBuilder pageBuilder = new JPAPage.JPAPageBuilder();
        pageBuilder.pageSize(this.oDataJPAContext.getPageSize()).query(query).skipToken(uriParserResultView.getSkipToken());
        if (uriParserResultView.getSkip() != null && uriParserResultView.getInlineCount() == null) {
            pageBuilder.skip(uriParserResultView.getSkip());
        }
        if (uriParserResultView.getTop() != null && uriParserResultView.getInlineCount() == null) {
            pageBuilder.top(uriParserResultView.getTop());
        }
        JPAPage page = pageBuilder.build();
        this.oDataJPAContext.setPaging((JPAPaging)page);
        return page.getPagedEntities();
    }

    public <T> Object process(GetEntityUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        JPQLContextType contextType = null;
        try {
            if (uriParserResultView instanceof GetEntityUriInfo) {
                contextType = !uriParserResultView.getStartEntitySet().getName().equals(uriParserResultView.getTargetEntitySet().getName()) ? JPQLContextType.JOIN_SINGLE : JPQLContextType.SELECT_SINGLE;
            }
        }
        catch (EdmException e) {
            ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, (Throwable)e);
        }
        return this.readEntity(uriParserResultView, contextType);
    }

    public long process(GetEntitySetCountUriInfo resultsView) throws ODataJPAModelException, ODataJPARuntimeException {
        JPQLContextType contextType = null;
        try {
            contextType = !resultsView.getStartEntitySet().getName().equals(resultsView.getTargetEntitySet().getName()) ? JPQLContextType.JOIN_COUNT : JPQLContextType.SELECT_COUNT;
        }
        catch (EdmException e) {
            ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, (Throwable)e);
        }
        JPQLContext jpqlContext = JPQLContext.createBuilder(contextType, (Object)resultsView).build();
        JPQLStatement jpqlStatement = JPQLStatement.createBuilder((JPQLContextView)jpqlContext).build();
        Query query = null;
        try {
            query = this.em.createQuery(jpqlStatement.toString());
            List resultList = query.getResultList();
            if (resultList != null && resultList.size() == 1) {
                return Long.valueOf(resultList.get(0).toString());
            }
        }
        catch (IllegalArgumentException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        return 0L;
    }

    public long process(GetEntityCountUriInfo resultsView) throws ODataJPAModelException, ODataJPARuntimeException {
        JPQLContextType contextType = null;
        try {
            contextType = !resultsView.getStartEntitySet().getName().equals(resultsView.getTargetEntitySet().getName()) ? JPQLContextType.JOIN_COUNT : JPQLContextType.SELECT_COUNT;
        }
        catch (EdmException e) {
            ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, (Throwable)e);
        }
        JPQLContext jpqlContext = JPQLContext.createBuilder(contextType, (Object)resultsView).build();
        JPQLStatement jpqlStatement = JPQLStatement.createBuilder((JPQLContextView)jpqlContext).build();
        Query query = null;
        try {
            query = this.em.createQuery(jpqlStatement.toString());
            List resultList = query.getResultList();
            if (resultList != null && resultList.size() == 1) {
                return Long.valueOf(resultList.get(0).toString());
            }
        }
        catch (IllegalArgumentException e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
        }
        return 0L;
    }

    public Object process(PostUriInfo createView, InputStream content, String requestedContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processCreate(createView, content, null, requestedContentType);
    }

    public Object process(PostUriInfo createView, Map<String, Object> content) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processCreate(createView, null, content, null);
    }

    public Object process(PutMergePatchUriInfo updateView, InputStream content, String requestContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processUpdate(updateView, content, null, requestContentType);
    }

    public Object process(PutMergePatchUriInfo updateView, Map<String, Object> content) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.processUpdate(updateView, null, content, null);
    }

    private Object processCreate(PostUriInfo createView, InputStream content, Map<String, Object> properties, String requestedContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        try {
            EdmEntitySet oDataEntitySet = createView.getTargetEntitySet();
            EdmEntityType oDataEntityType = oDataEntitySet.getEntityType();
            JPAEntity virtualJPAEntity = new JPAEntity(oDataEntityType, oDataEntitySet, this.oDataJPAContext);
            Object jpaEntity = null;
            if (content != null) {
                ODataEntityParser oDataEntityParser = new ODataEntityParser(this.oDataJPAContext);
                ODataEntry oDataEntry = oDataEntityParser.parseEntry(oDataEntitySet, content, requestedContentType, false);
                virtualJPAEntity.create(oDataEntry);
            } else if (properties != null) {
                virtualJPAEntity.create(properties);
            } else {
                return null;
            }
            this.em.getTransaction().begin();
            jpaEntity = virtualJPAEntity.getJPAEntity();
            this.em.persist(jpaEntity);
            if (this.em.contains(jpaEntity)) {
                this.em.getTransaction().commit();
                return jpaEntity;
            }
        }
        catch (Exception e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_CREATE_REQUEST, (Throwable)e);
        }
        return null;
    }

    public <T> Object processUpdate(PutMergePatchUriInfo updateView, InputStream content, Map<String, Object> properties, String requestContentType) throws ODataJPAModelException, ODataJPARuntimeException {
        JPQLContextType contextType = null;
        Object jpaEntity = null;
        try {
            this.em.getTransaction().begin();
            if (updateView instanceof PutMergePatchUriInfo) {
                contextType = !updateView.getStartEntitySet().getName().equals(updateView.getTargetEntitySet().getName()) ? JPQLContextType.JOIN_SINGLE : JPQLContextType.SELECT_SINGLE;
            }
            if ((jpaEntity = this.readEntity(updateView, contextType)) == null) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.RESOURCE_NOT_FOUND, null);
            }
            EdmEntitySet oDataEntitySet = updateView.getTargetEntitySet();
            EdmEntityType oDataEntityType = oDataEntitySet.getEntityType();
            JPAEntity virtualJPAEntity = new JPAEntity(oDataEntityType, oDataEntitySet, this.oDataJPAContext);
            virtualJPAEntity.setJPAEntity(jpaEntity);
            if (content != null) {
                ODataEntityParser oDataEntityParser = new ODataEntityParser(this.oDataJPAContext);
                ODataEntry oDataEntry = oDataEntityParser.parseEntry(oDataEntitySet, content, requestContentType, false);
                virtualJPAEntity.update(oDataEntry);
            } else if (properties != null) {
                virtualJPAEntity.update(properties);
            } else {
                return null;
            }
            this.em.flush();
            this.em.getTransaction().commit();
        }
        catch (Exception e) {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_UPDATE_REQUEST, (Throwable)e);
        }
        return jpaEntity;
    }

    public Object process(DeleteUriInfo uriParserResultView, String contentType) throws ODataJPAModelException, ODataJPARuntimeException {
        JPQLContextType contextType = null;
        try {
            if (uriParserResultView instanceof DeleteUriInfo) {
                if (((UriInfo)uriParserResultView).isLinks()) {
                    return this.deleteLink(uriParserResultView);
                }
                contextType = !uriParserResultView.getStartEntitySet().getName().equals(uriParserResultView.getTargetEntitySet().getName()) ? JPQLContextType.JOIN_SINGLE : JPQLContextType.SELECT_SINGLE;
            }
        }
        catch (EdmException e) {
            ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL, (Throwable)e);
        }
        Object selectedObject = this.readEntity(uriParserResultView, contextType);
        if (selectedObject != null) {
            try {
                this.em.getTransaction().begin();
                this.em.remove(selectedObject);
                this.em.flush();
                this.em.getTransaction().commit();
            }
            catch (Exception e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_DELETE_REQUEST, (Throwable)e);
            }
        }
        return selectedObject;
    }

    private Object deleteLink(DeleteUriInfo uriParserResultView) throws ODataJPARuntimeException {
        JPALink link = new JPALink(this.oDataJPAContext);
        link.delete(uriParserResultView);
        link.save();
        return link.getTargetJPAEntity();
    }

    public Object process(GetEntityLinkUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.process((GetEntityUriInfo)uriParserResultView);
    }

    public List<Object> process(GetEntitySetLinksUriInfo uriParserResultView) throws ODataJPAModelException, ODataJPARuntimeException {
        return this.process((GetEntitySetUriInfo)uriParserResultView);
    }

    public void process(PostUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataJPARuntimeException, ODataJPAModelException {
        JPALink link = new JPALink(this.oDataJPAContext);
        link.create(uriInfo, content, requestContentType, contentType);
        link.save();
    }

    private Object readEntity(Object uriParserResultView, JPQLContextType contextType) throws ODataJPAModelException, ODataJPARuntimeException {
        Object selectedObject = null;
        if (uriParserResultView instanceof DeleteUriInfo || uriParserResultView instanceof GetEntityUriInfo || uriParserResultView instanceof PutMergePatchUriInfo) {
            JPQLContext selectJPQLContext = JPQLContext.createBuilder((JPQLContextType)contextType, (Object)uriParserResultView).build();
            JPQLStatement selectJPQLStatement = JPQLStatement.createBuilder((JPQLContextView)selectJPQLContext).build();
            Query query = null;
            try {
                query = this.em.createQuery(selectJPQLStatement.toString());
                if (!query.getResultList().isEmpty()) {
                    selectedObject = query.getResultList().get(0);
                }
            }
            catch (IllegalArgumentException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.ERROR_JPQL_QUERY_CREATE, (Throwable)e);
            }
        }
        return selectedObject;
    }

    public void process(PutMergePatchUriInfo putUriInfo, InputStream content, String requestContentType, String contentType) throws ODataJPARuntimeException, ODataJPAModelException {
        JPALink link = new JPALink(this.oDataJPAContext);
        link.update(putUriInfo, content, requestContentType, contentType);
        link.save();
    }
}

