/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.model;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import javax.persistence.Column;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.PluralAttribute;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.Association;
import org.apache.olingo.odata2.api.edm.provider.AssociationSet;
import org.apache.olingo.odata2.api.edm.provider.ComplexProperty;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.Mapping;
import org.apache.olingo.odata2.api.edm.provider.NavigationProperty;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmMappingModelAccess;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmAssociationEndView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmAssociationSetView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmAssociationView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmBaseView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmComplexPropertyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntityContainerView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntitySetView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntityTypeView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmNavigationPropertyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmPropertyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmSchemaView;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmComplexType;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;

public class JPAEdmNameBuilder {
    private static final String ENTITY_CONTAINER_SUFFIX = "Container";
    private static final String ENTITY_SET_SUFFIX = "s";
    private static final String ASSOCIATIONSET_SUFFIX = "Set";
    private static final String NAVIGATION_NAME = "Details";
    private static final String UNDERSCORE = "_";
    private static final String FK_PREFIX = "FK";

    public static FullQualifiedName build(JPAEdmBaseView view, String name) {
        FullQualifiedName fqName = new FullQualifiedName(JPAEdmNameBuilder.buildNamespace(view), name);
        return fqName;
    }

    public static void build(JPAEdmEntityTypeView view) {
        EntityType edmEntityType = view.getEdmEntityType();
        String jpaEntityName = view.getJPAEntityType().getName();
        JPAEdmMappingModelAccess mappingModelAccess = view.getJPAEdmMappingModelAccess();
        String edmEntityTypeName = null;
        if (mappingModelAccess != null && mappingModelAccess.isMappingModelExists()) {
            edmEntityTypeName = mappingModelAccess.mapJPAEntityType(jpaEntityName);
        }
        JPAEdmMappingImpl mapping = new JPAEdmMappingImpl();
        mapping.setJPAType(view.getJPAEntityType().getJavaType());
        if (edmEntityTypeName == null) {
            edmEntityTypeName = jpaEntityName;
        }
        edmEntityType.setMapping(((Mapping)mapping).setInternalName(jpaEntityName));
        edmEntityType.setName(edmEntityTypeName);
    }

    public static void build(JPAEdmSchemaView view) throws ODataJPAModelException {
        view.getEdmSchema().setNamespace(JPAEdmNameBuilder.buildNamespace((JPAEdmBaseView)view));
    }

    public static void build(JPAEdmPropertyView view, boolean isComplexMode, boolean skipDefaultNaming, boolean isForeignKey) {
        Attribute jpaAttribute = view.getJPAAttribute();
        String jpaAttributeName = jpaAttribute.getName();
        String propertyName = null;
        String[] joinColumnNames = null;
        JPAEdmMappingModelAccess mappingModelAccess = view.getJPAEdmMappingModelAccess();
        if (mappingModelAccess != null && mappingModelAccess.isMappingModelExists()) {
            propertyName = isComplexMode ? mappingModelAccess.mapJPAEmbeddableTypeAttribute(view.getJPAEdmComplexTypeView().getJPAEmbeddableType().getJavaType().getSimpleName(), jpaAttributeName) : mappingModelAccess.mapJPAAttribute(view.getJPAEdmEntityTypeView().getJPAEntityType().getName(), jpaAttributeName);
        }
        if (!skipDefaultNaming && propertyName == null) {
            propertyName = Character.toUpperCase(jpaAttributeName.charAt(0)) + jpaAttributeName.substring(1);
        } else if (propertyName == null) {
            propertyName = jpaAttributeName;
            if (isForeignKey) {
                joinColumnNames = (String[])view.getJPAJoinColumns().get(view.getJPAJoinColumns().size() - 1);
                propertyName = "FK_" + joinColumnNames[0];
            }
        }
        view.getEdmSimpleProperty().setName(propertyName);
        JPAEdmMappingImpl mapping = new JPAEdmMappingImpl();
        mapping.setJPAType(jpaAttribute.getJavaType());
        AnnotatedElement annotatedElement = (AnnotatedElement)((Object)jpaAttribute.getJavaMember());
        if (annotatedElement != null) {
            Column column = annotatedElement.getAnnotation(Column.class);
            if (column != null) {
                mapping.setJPAColumnName(column.name());
            } else if (joinColumnNames != null) {
                mapping.setJPAColumnName(joinColumnNames[0]);
                jpaAttributeName = jpaAttributeName + "." + view.getJPAReferencedAttribute().getName();
            }
        } else {
            ManagedType managedType = jpaAttribute.getDeclaringType();
            if (managedType != null) {
                Class clazz = managedType.getJavaType();
                try {
                    Field field = clazz.getField(jpaAttributeName);
                    Column column = field.getAnnotation(Column.class);
                    if (column != null) {
                        mapping.setJPAColumnName(column.name());
                    }
                }
                catch (SecurityException e) {
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
        }
        ((Mapping)mapping).setInternalName(jpaAttributeName);
        view.getEdmSimpleProperty().setMapping((Mapping)mapping);
    }

    public static void build(JPAEdmEntityContainerView view) {
        view.getEdmEntityContainer().setName(JPAEdmNameBuilder.buildNamespace((JPAEdmBaseView)view) + ENTITY_CONTAINER_SUFFIX);
    }

    public static void build(JPAEdmEntitySetView view, JPAEdmEntityTypeView entityTypeView) {
        Mapping mapping;
        FullQualifiedName fQname = view.getEdmEntitySet().getEntityType();
        JPAEdmMappingModelAccess mappingModelAccess = view.getJPAEdmMappingModelAccess();
        String entitySetName = null;
        if (mappingModelAccess != null && mappingModelAccess.isMappingModelExists() && (mapping = entityTypeView.getEdmEntityType().getMapping()) != null) {
            entitySetName = mappingModelAccess.mapJPAEntitySet(mapping.getInternalName());
        }
        if (entitySetName == null) {
            entitySetName = fQname.getName() + ENTITY_SET_SUFFIX;
        }
        view.getEdmEntitySet().setName(entitySetName);
    }

    public static void build(JPAEdmComplexType view) {
        JPAEdmMappingModelAccess mappingModelAccess = view.getJPAEdmMappingModelAccess();
        String jpaEmbeddableTypeName = view.getJPAEmbeddableType().getJavaType().getSimpleName();
        String edmComplexTypeName = null;
        if (mappingModelAccess != null && mappingModelAccess.isMappingModelExists()) {
            edmComplexTypeName = mappingModelAccess.mapJPAEmbeddableType(jpaEmbeddableTypeName);
        }
        if (edmComplexTypeName == null) {
            edmComplexTypeName = jpaEmbeddableTypeName;
        }
        view.getEdmComplexType().setName(edmComplexTypeName);
        ComplexType complexType = view.getEdmComplexType();
        complexType.setName(edmComplexTypeName);
        JPAEdmMappingImpl mapping = new JPAEdmMappingImpl();
        mapping.setJPAType(view.getJPAEmbeddableType().getJavaType());
        complexType.setMapping((Mapping)mapping);
    }

    public static void build(JPAEdmComplexPropertyView complexView, JPAEdmPropertyView propertyView, boolean skipDefaultNaming) {
        ComplexProperty complexProperty = complexView.getEdmComplexProperty();
        String jpaAttributeName = propertyView.getJPAAttribute().getName();
        String jpaEntityTypeName = propertyView.getJPAEdmEntityTypeView().getJPAEntityType().getName();
        JPAEdmMappingModelAccess mappingModelAccess = complexView.getJPAEdmMappingModelAccess();
        String propertyName = null;
        if (mappingModelAccess != null && mappingModelAccess.isMappingModelExists()) {
            propertyName = mappingModelAccess.mapJPAAttribute(jpaEntityTypeName, jpaAttributeName);
        }
        if (!skipDefaultNaming && propertyName == null) {
            propertyName = Character.toUpperCase(jpaAttributeName.charAt(0)) + jpaAttributeName.substring(1);
        } else if (propertyName == null) {
            propertyName = jpaAttributeName;
        }
        JPAEdmMappingImpl mapping = new JPAEdmMappingImpl();
        ((Mapping)mapping).setInternalName(jpaAttributeName);
        mapping.setJPAType(propertyView.getJPAAttribute().getJavaType());
        complexProperty.setMapping((Mapping)mapping);
        complexProperty.setName(propertyName);
    }

    public static void build(JPAEdmComplexPropertyView complexView, String parentComplexTypeName, boolean skipDefaultNaming) {
        ComplexProperty complexProperty = complexView.getEdmComplexProperty();
        JPAEdmMappingModelAccess mappingModelAccess = complexView.getJPAEdmMappingModelAccess();
        JPAEdmPropertyView propertyView = (JPAEdmPropertyView)complexView;
        String jpaAttributeName = propertyView.getJPAAttribute().getName();
        String propertyName = null;
        if (mappingModelAccess != null && mappingModelAccess.isMappingModelExists()) {
            propertyName = mappingModelAccess.mapJPAEmbeddableTypeAttribute(parentComplexTypeName, jpaAttributeName);
        }
        if (!skipDefaultNaming && propertyName == null) {
            propertyName = Character.toUpperCase(jpaAttributeName.charAt(0)) + jpaAttributeName.substring(1);
        } else if (propertyName == null) {
            propertyName = jpaAttributeName;
        }
        JPAEdmMappingImpl mapping = new JPAEdmMappingImpl();
        ((Mapping)mapping).setInternalName(jpaAttributeName);
        mapping.setJPAType(propertyView.getJPAAttribute().getJavaType());
        complexProperty.setMapping((Mapping)mapping);
        complexProperty.setName(propertyName);
    }

    public static void build(JPAEdmAssociationEndView assocaitionEndView, JPAEdmEntityTypeView entityTypeView, JPAEdmPropertyView propertyView) {
        String namespace = JPAEdmNameBuilder.buildNamespace((JPAEdmBaseView)assocaitionEndView);
        String name = entityTypeView.getEdmEntityType().getName();
        FullQualifiedName fQName = new FullQualifiedName(namespace, name);
        assocaitionEndView.getEdmAssociationEnd1().setType(fQName);
        name = null;
        String jpaEntityTypeName = null;
        Attribute jpaAttribute = propertyView.getJPAAttribute();
        jpaEntityTypeName = jpaAttribute.isCollection() ? ((PluralAttribute)jpaAttribute).getElementType().getJavaType().getSimpleName() : propertyView.getJPAAttribute().getJavaType().getSimpleName();
        JPAEdmMappingModelAccess mappingModelAccess = assocaitionEndView.getJPAEdmMappingModelAccess();
        if (mappingModelAccess != null && mappingModelAccess.isMappingModelExists()) {
            name = mappingModelAccess.mapJPAEntityType(jpaEntityTypeName);
        }
        if (name == null) {
            name = jpaEntityTypeName;
        }
        fQName = new FullQualifiedName(namespace, name);
        assocaitionEndView.getEdmAssociationEnd2().setType(fQName);
    }

    private static String buildNamespace(JPAEdmBaseView view) {
        JPAEdmMappingModelAccess mappingModelAccess = view.getJPAEdmMappingModelAccess();
        String namespace = null;
        if (mappingModelAccess != null && mappingModelAccess.isMappingModelExists()) {
            namespace = mappingModelAccess.mapJPAPersistenceUnit(view.getpUnitName());
        }
        if (namespace == null) {
            namespace = view.getpUnitName();
        }
        return namespace;
    }

    public static void build(JPAEdmAssociationView view, int count) {
        String end2Name;
        Association association = view.getEdmAssociation();
        String associationName = null;
        String end1Name = association.getEnd1().getType().getName();
        associationName = end1Name.compareToIgnoreCase(end2Name = association.getEnd2().getType().getName()) > 0 ? end2Name + UNDERSCORE + end1Name : end1Name + UNDERSCORE + end2Name;
        if (count > 1) {
            associationName = associationName + Integer.toString(count - 1);
        }
        association.setName(associationName);
    }

    public static void build(JPAEdmAssociationSetView view) {
        AssociationSet associationSet = view.getEdmAssociationSet();
        String name = view.getEdmAssociation().getName();
        associationSet.setName(name + ASSOCIATIONSET_SUFFIX);
    }

    public static void build(JPAEdmAssociationView associationView, JPAEdmPropertyView propertyView, JPAEdmNavigationPropertyView navPropertyView, boolean skipDefaultNaming, int count) {
        String toName = null;
        String fromName = null;
        String navPropName = null;
        NavigationProperty navProp = navPropertyView.getEdmNavigationProperty();
        String namespace = JPAEdmNameBuilder.buildNamespace((JPAEdmBaseView)associationView);
        Association association = associationView.getEdmAssociation();
        navProp.setRelationship(new FullQualifiedName(namespace, association.getName()));
        FullQualifiedName associationEndTypeOne = association.getEnd1().getType();
        FullQualifiedName associationEndTypeTwo = association.getEnd2().getType();
        Attribute jpaAttribute = propertyView.getJPAAttribute();
        JPAEdmMappingImpl mapping = new JPAEdmMappingImpl();
        ((Mapping)mapping).setInternalName(jpaAttribute.getName());
        mapping.setJPAType(jpaAttribute.getJavaType());
        navProp.setMapping((Mapping)mapping);
        String jpaEntityTypeName = propertyView.getJPAEdmEntityTypeView().getJPAEntityType().getName();
        JPAEdmMappingModelAccess mappingModelAccess = navPropertyView.getJPAEdmMappingModelAccess();
        String targetEntityTypeName = null;
        targetEntityTypeName = jpaAttribute.isCollection() ? ((PluralAttribute)jpaAttribute).getElementType().getJavaType().getSimpleName() : jpaAttribute.getJavaType().getSimpleName();
        if (mappingModelAccess != null && mappingModelAccess.isMappingModelExists()) {
            navPropName = mappingModelAccess.mapJPARelationship(jpaEntityTypeName, jpaAttribute.getName());
            toName = mappingModelAccess.mapJPAEntityType(targetEntityTypeName);
            fromName = mappingModelAccess.mapJPAEntityType(jpaEntityTypeName);
        }
        if (toName == null) {
            toName = targetEntityTypeName;
        }
        if (fromName == null) {
            fromName = jpaEntityTypeName;
        }
        if (!skipDefaultNaming) {
            if (navPropName == null) {
                navPropName = toName.concat(NAVIGATION_NAME);
            }
            if (count > 1) {
                navPropName = navPropName + Integer.toString(count - 1);
            }
        } else if (navPropName == null) {
            navPropName = jpaAttribute.getName();
        }
        navProp.setName(navPropName);
        if (toName.equals(associationEndTypeOne.getName())) {
            navProp.setFromRole(association.getEnd2().getRole());
            navProp.setToRole(association.getEnd1().getRole());
        } else if (toName.equals(associationEndTypeTwo.getName())) {
            navProp.setToRole(association.getEnd2().getRole());
            navProp.setFromRole(association.getEnd1().getRole());
        }
    }
}

