/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.model;

import java.lang.reflect.AnnotatedElement;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.UUID;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.metamodel.Attribute;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;

public class JPATypeConvertor {
    public static EdmSimpleTypeKind convertToEdmSimpleType(Class<?> jpaType, Attribute<?, ?> currentAttribute) throws ODataJPAModelException {
        if (jpaType.equals(String.class) || jpaType.equals(Character.class) || jpaType.equals(Character.TYPE) || jpaType.equals(char[].class) || jpaType.equals(Character[].class)) {
            return EdmSimpleTypeKind.String;
        }
        if (jpaType.equals(Long.class) || jpaType.equals(Long.TYPE)) {
            return EdmSimpleTypeKind.Int64;
        }
        if (jpaType.equals(Short.class) || jpaType.equals(Short.TYPE)) {
            return EdmSimpleTypeKind.Int16;
        }
        if (jpaType.equals(Integer.class) || jpaType.equals(Integer.TYPE)) {
            return EdmSimpleTypeKind.Int32;
        }
        if (jpaType.equals(Double.class) || jpaType.equals(Double.TYPE)) {
            return EdmSimpleTypeKind.Double;
        }
        if (jpaType.equals(Float.class) || jpaType.equals(Float.TYPE)) {
            return EdmSimpleTypeKind.Single;
        }
        if (jpaType.equals(BigDecimal.class)) {
            return EdmSimpleTypeKind.Decimal;
        }
        if (jpaType.equals(byte[].class)) {
            return EdmSimpleTypeKind.Binary;
        }
        if (jpaType.equals(Byte.class) || jpaType.equals(Byte.TYPE)) {
            return EdmSimpleTypeKind.Byte;
        }
        if (jpaType.equals(Boolean.class) || jpaType.equals(Boolean.TYPE)) {
            return EdmSimpleTypeKind.Boolean;
        }
        if (jpaType.equals(Date.class) || jpaType.equals(Calendar.class) || jpaType.equals(Timestamp.class)) {
            try {
                if (currentAttribute != null && JPATypeConvertor.determineTemporalType(currentAttribute) == TemporalType.TIME) {
                    return EdmSimpleTypeKind.Time;
                }
                return EdmSimpleTypeKind.DateTime;
            }
            catch (SecurityException e) {
                throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
        }
        if (jpaType.equals(UUID.class)) {
            return EdmSimpleTypeKind.Guid;
        }
        if (jpaType.equals(Byte[].class)) {
            return EdmSimpleTypeKind.Binary;
        }
        if (jpaType.equals(Blob.class) && JPATypeConvertor.isBlob(currentAttribute)) {
            return EdmSimpleTypeKind.Binary;
        }
        if (jpaType.equals(Clob.class) && JPATypeConvertor.isBlob(currentAttribute)) {
            return EdmSimpleTypeKind.String;
        }
        throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.TYPE_NOT_SUPPORTED.addContent(new Object[]{jpaType.toString()}), null);
    }

    private static boolean isBlob(Attribute<?, ?> currentAttribute) {
        AnnotatedElement annotatedElement;
        return currentAttribute != null && (annotatedElement = (AnnotatedElement)((Object)currentAttribute.getJavaMember())) != null && annotatedElement.getAnnotation(Lob.class) != null;
    }

    private static TemporalType determineTemporalType(Attribute<?, ?> currentAttribute) throws ODataJPAModelException {
        AnnotatedElement annotatedElement;
        if (currentAttribute != null && (annotatedElement = (AnnotatedElement)((Object)currentAttribute.getJavaMember())) != null && annotatedElement.getAnnotation(Temporal.class) != null) {
            return annotatedElement.getAnnotation(Temporal.class).value();
        }
        return null;
    }
}

