/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.callback;

import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.ep.callback.TombstoneCallback;
import org.apache.olingo.odata2.api.ep.callback.TombstoneCallbackResult;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;

public class JPATombstoneCallBack
implements TombstoneCallback {
    private static final String DELTA_TOKEN_STRING = "?!deltatoken=";
    private String baseUri;
    private String deltaTokenValue;
    private GetEntitySetUriInfo resultsView;

    public JPATombstoneCallBack(String baseUri, GetEntitySetUriInfo resultsView, String deltaTokenValue) {
        this.baseUri = baseUri;
        this.deltaTokenValue = deltaTokenValue;
        this.resultsView = resultsView;
    }

    public TombstoneCallbackResult getTombstoneCallbackResult() {
        TombstoneCallbackResult jpaTombstoneCallBackResult = new TombstoneCallbackResult();
        jpaTombstoneCallBackResult.setDeltaLink(this.buildToken());
        return jpaTombstoneCallBackResult;
    }

    private String buildToken() {
        StringBuilder tokenBuilder = new StringBuilder();
        tokenBuilder.append(this.baseUri);
        try {
            tokenBuilder.append(this.resultsView.getTargetEntitySet().getName());
        }
        catch (EdmException edmException) {
            // empty catch block
        }
        tokenBuilder.append(DELTA_TOKEN_STRING);
        tokenBuilder.append(this.deltaTokenValue);
        return tokenBuilder.toString();
    }
}

