/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.factory;

import java.util.Locale;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.processor.ODataSingleProcessor;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAResponseBuilder;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmMappingModelAccess;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAMethodContext;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAProcessor;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAMessageService;
import org.apache.olingo.odata2.jpa.processor.api.factory.JPAAccessFactory;
import org.apache.olingo.odata2.jpa.processor.api.factory.JPQLBuilderFactory;
import org.apache.olingo.odata2.jpa.processor.api.factory.ODataJPAAccessFactory;
import org.apache.olingo.odata2.jpa.processor.api.factory.ODataJPAFactory;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContext;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLStatement;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmModelView;
import org.apache.olingo.odata2.jpa.processor.core.ODataJPAContextImpl;
import org.apache.olingo.odata2.jpa.processor.core.ODataJPAProcessorDefault;
import org.apache.olingo.odata2.jpa.processor.core.ODataJPAResponseBuilderDefault;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAFunctionContext;
import org.apache.olingo.odata2.jpa.processor.core.access.data.JPAProcessorImpl;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPAEdmMappingModelService;
import org.apache.olingo.odata2.jpa.processor.core.edm.ODataJPAEdmProvider;
import org.apache.olingo.odata2.jpa.processor.core.exception.ODataJPAMessageServiceDefault;
import org.apache.olingo.odata2.jpa.processor.core.jpql.JPQLJoinSelectContext;
import org.apache.olingo.odata2.jpa.processor.core.jpql.JPQLJoinSelectSingleContext;
import org.apache.olingo.odata2.jpa.processor.core.jpql.JPQLJoinSelectSingleStatementBuilder;
import org.apache.olingo.odata2.jpa.processor.core.jpql.JPQLJoinStatementBuilder;
import org.apache.olingo.odata2.jpa.processor.core.jpql.JPQLSelectContext;
import org.apache.olingo.odata2.jpa.processor.core.jpql.JPQLSelectSingleContext;
import org.apache.olingo.odata2.jpa.processor.core.jpql.JPQLSelectSingleStatementBuilder;
import org.apache.olingo.odata2.jpa.processor.core.jpql.JPQLSelectStatementBuilder;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmModel;

public class ODataJPAFactoryImpl
extends ODataJPAFactory {
    public JPQLBuilderFactory getJPQLBuilderFactory() {
        return JPQLBuilderFactoryImpl.create();
    }

    public JPAAccessFactory getJPAAccessFactory() {
        return JPAAccessFactoryImpl.create();
    }

    public ODataJPAAccessFactory getODataJPAAccessFactory() {
        return ODataJPAAccessFactoryImpl.create();
    }

    private static class JPAAccessFactoryImpl
    implements JPAAccessFactory {
        private static JPAAccessFactoryImpl factory = null;

        private JPAAccessFactoryImpl() {
        }

        public JPAEdmModelView getJPAEdmModelView(ODataJPAContext oDataJPAContext) {
            JPAEdmModel view = null;
            view = new JPAEdmModel(oDataJPAContext);
            return view;
        }

        public JPAProcessor getJPAProcessor(ODataJPAContext oDataJPAContext) {
            JPAProcessorImpl jpaProcessor = new JPAProcessorImpl(oDataJPAContext);
            return jpaProcessor;
        }

        private static JPAAccessFactoryImpl create() {
            if (factory == null) {
                return new JPAAccessFactoryImpl();
            }
            return factory;
        }

        public JPAEdmMappingModelAccess getJPAEdmMappingModelAccess(ODataJPAContext oDataJPAContext) {
            JPAEdmMappingModelService mappingModelAccess = new JPAEdmMappingModelService(oDataJPAContext);
            return mappingModelAccess;
        }
    }

    private static class ODataJPAAccessFactoryImpl
    implements ODataJPAAccessFactory {
        private static ODataJPAAccessFactoryImpl factory = null;

        private ODataJPAAccessFactoryImpl() {
        }

        public ODataSingleProcessor createODataProcessor(ODataJPAContext oDataJPAContext) {
            return new ODataJPAProcessorDefault(oDataJPAContext);
        }

        public EdmProvider createJPAEdmProvider(ODataJPAContext oDataJPAContext) {
            return new ODataJPAEdmProvider(oDataJPAContext);
        }

        public ODataJPAContext createODataJPAContext() {
            return new ODataJPAContextImpl();
        }

        private static ODataJPAAccessFactoryImpl create() {
            if (factory == null) {
                return new ODataJPAAccessFactoryImpl();
            }
            return factory;
        }

        public ODataJPAMessageService getODataJPAMessageService(Locale locale) {
            return ODataJPAMessageServiceDefault.getInstance(locale);
        }

        public ODataJPAResponseBuilder getODataJPAResponseBuilder(ODataJPAContext oDataJPAContext) {
            return new ODataJPAResponseBuilderDefault(oDataJPAContext);
        }
    }

    private static class JPQLBuilderFactoryImpl
    implements JPQLBuilderFactory {
        private static JPQLBuilderFactoryImpl factory = null;

        private JPQLBuilderFactoryImpl() {
        }

        public JPQLStatement.JPQLStatementBuilder getStatementBuilder(JPQLContextView context) {
            JPQLStatement.JPQLStatementBuilder builder = null;
            switch (context.getType()) {
                case SELECT: 
                case SELECT_COUNT: {
                    builder = new JPQLSelectStatementBuilder(context);
                    break;
                }
                case SELECT_SINGLE: {
                    builder = new JPQLSelectSingleStatementBuilder(context);
                    break;
                }
                case JOIN: 
                case JOIN_COUNT: {
                    builder = new JPQLJoinStatementBuilder(context);
                    break;
                }
                case JOIN_SINGLE: {
                    builder = new JPQLJoinSelectSingleStatementBuilder(context);
                }
            }
            return builder;
        }

        public JPQLContext.JPQLContextBuilder getContextBuilder(JPQLContextType contextType) {
            JPQLContext.JPQLContextBuilder contextBuilder = null;
            switch (contextType) {
                case SELECT: {
                    JPQLSelectContext selectContext = new JPQLSelectContext(false);
                    contextBuilder = new JPQLSelectContext.JPQLSelectContextBuilder(selectContext);
                    break;
                }
                case SELECT_SINGLE: {
                    JPQLSelectSingleContext singleSelectContext = new JPQLSelectSingleContext();
                    contextBuilder = new JPQLSelectSingleContext.JPQLSelectSingleContextBuilder(singleSelectContext);
                    break;
                }
                case JOIN: {
                    JPQLJoinSelectContext joinContext = new JPQLJoinSelectContext(false);
                    contextBuilder = new JPQLJoinSelectContext.JPQLJoinContextBuilder(joinContext);
                    break;
                }
                case JOIN_SINGLE: {
                    JPQLJoinSelectSingleContext joinSingleContext = new JPQLJoinSelectSingleContext();
                    contextBuilder = new JPQLJoinSelectSingleContext.JPQLJoinSelectSingleContextBuilder(joinSingleContext);
                    break;
                }
                case SELECT_COUNT: {
                    JPQLSelectContext selectCountContext = new JPQLSelectContext(true);
                    contextBuilder = new JPQLSelectContext.JPQLSelectContextBuilder(selectCountContext);
                    break;
                }
                case JOIN_COUNT: {
                    JPQLJoinSelectContext joinCountContext = new JPQLJoinSelectContext(true);
                    contextBuilder = new JPQLJoinSelectContext.JPQLJoinContextBuilder(joinCountContext);
                }
            }
            return contextBuilder;
        }

        private static JPQLBuilderFactory create() {
            if (factory == null) {
                return new JPQLBuilderFactoryImpl();
            }
            return factory;
        }

        public JPAMethodContext.JPAMethodContextBuilder getJPAMethodContextBuilder(JPQLContextType contextType) {
            JPAFunctionContext.JPAFunctionContextBuilder contextBuilder = null;
            switch (contextType) {
                case FUNCTION: {
                    JPAFunctionContext methodConext = new JPAFunctionContext();
                    contextBuilder = methodConext.new JPAFunctionContext.JPAFunctionContextBuilder();
                    break;
                }
            }
            return contextBuilder;
        }
    }
}

