/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.jpql;

import java.util.Iterator;
import java.util.Map;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLSelectContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLStatement;

public class JPQLSelectStatementBuilder
extends JPQLStatement.JPQLStatementBuilder {
    JPQLStatement jpqlStatement;
    private JPQLSelectContextView context;

    public JPQLSelectStatementBuilder(JPQLContextView context) {
        this.context = (JPQLSelectContextView)context;
    }

    public JPQLStatement build() throws ODataJPARuntimeException {
        this.jpqlStatement = this.createStatement(this.createJPQLQuery());
        return this.jpqlStatement;
    }

    private String createJPQLQuery() throws ODataJPARuntimeException {
        StringBuilder jpqlQuery = new StringBuilder();
        String tableAlias = this.context.getJPAEntityAlias();
        String fromClause = this.context.getJPAEntityName() + ' ' + tableAlias;
        jpqlQuery.append("SELECT").append(' ');
        if (this.context.getType().equals((Object)JPQLContextType.SELECT_COUNT)) {
            jpqlQuery.append("COUNT").append(' ');
            jpqlQuery.append('(').append(' ');
            jpqlQuery.append(this.context.getSelectExpression()).append(' ');
            jpqlQuery.append(')').append(' ');
        } else {
            jpqlQuery.append(this.context.getSelectExpression()).append(' ');
        }
        jpqlQuery.append("FROM").append(' ');
        jpqlQuery.append(fromClause);
        if (this.context.getWhereExpression() != null) {
            jpqlQuery.append(' ');
            jpqlQuery.append("WHERE").append(' ');
            jpqlQuery.append(this.context.getWhereExpression());
        }
        if (this.context.getOrderByCollection() != null && this.context.getOrderByCollection().size() > 0) {
            StringBuilder orderByBuilder = new StringBuilder();
            Iterator orderItr = this.context.getOrderByCollection().entrySet().iterator();
            int i = 0;
            while (orderItr.hasNext()) {
                if (i != 0) {
                    orderByBuilder.append(' ').append(',').append(' ');
                }
                Map.Entry entry = orderItr.next();
                orderByBuilder.append((String)entry.getKey()).append(' ');
                orderByBuilder.append((String)entry.getValue());
                ++i;
            }
            jpqlQuery.append(' ');
            jpqlQuery.append("ORDER BY").append(' ');
            jpqlQuery.append((CharSequence)orderByBuilder);
        }
        return jpqlQuery.toString();
    }
}

