/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.olingo.odata2.api.edm.provider.Association;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.NavigationProperty;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmBuilder;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmAssociationView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmBaseView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmComplexTypeView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntityContainerView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntitySetView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntityTypeView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmExtension;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmModelView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmSchemaView;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPAEdmNameBuilder;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmAssociation;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmBaseViewImpl;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmComplexType;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmEntityContainer;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmFunctionImport;

public class JPAEdmSchema
extends JPAEdmBaseViewImpl
implements JPAEdmSchemaView {
    private Schema schema;
    private JPAEdmComplexTypeView complexTypeView;
    private JPAEdmEntityContainerView entityContainerView;
    private JPAEdmAssociationView associationView = null;
    private HashMap<Class<?>, String[]> customOperations = null;

    public JPAEdmSchema(JPAEdmModelView modelView) {
        super((JPAEdmBaseView)modelView);
    }

    public Schema getEdmSchema() {
        return this.schema;
    }

    public JPAEdmEntityContainerView getJPAEdmEntityContainerView() {
        return this.entityContainerView;
    }

    public JPAEdmComplexTypeView getJPAEdmComplexTypeView() {
        return this.complexTypeView;
    }

    public JPAEdmBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new JPAEdmSchemaBuilder();
        }
        return this.builder;
    }

    @Override
    public void clean() {
        super.clean();
        this.schema = null;
    }

    public final JPAEdmAssociationView getJPAEdmAssociationView() {
        return this.associationView;
    }

    public void registerOperations(Class<?> customClass, String[] methodNames) {
        if (this.customOperations == null) {
            this.customOperations = new HashMap();
        }
        this.customOperations.put(customClass, methodNames);
    }

    public HashMap<Class<?>, String[]> getRegisteredOperations() {
        return this.customOperations;
    }

    private class JPAEdmSchemaBuilder
    implements JPAEdmBuilder {
        private JPAEdmSchemaBuilder() {
        }

        public void build() throws ODataJPAModelException, ODataJPARuntimeException {
            JPAEdmExtension edmExtension;
            List entityTypes;
            JPAEdmEntityTypeView entityTypeView;
            JPAEdmSchema.this.schema = new Schema();
            JPAEdmNameBuilder.build(JPAEdmSchema.this);
            JPAEdmSchema.this.associationView = new JPAEdmAssociation(JPAEdmSchema.this);
            JPAEdmSchema.this.complexTypeView = new JPAEdmComplexType(JPAEdmSchema.this);
            JPAEdmSchema.this.complexTypeView.getBuilder().build();
            JPAEdmSchema.this.entityContainerView = new JPAEdmEntityContainer(JPAEdmSchema.this);
            JPAEdmSchema.this.entityContainerView.getBuilder().build();
            JPAEdmSchema.this.schema.setEntityContainers(JPAEdmSchema.this.entityContainerView.getConsistentEdmEntityContainerList());
            JPAEdmEntitySetView entitySetView = JPAEdmSchema.this.entityContainerView.getJPAEdmEntitySetView();
            if (entitySetView.isConsistent() && entitySetView.getJPAEdmEntityTypeView() != null && (entityTypeView = entitySetView.getJPAEdmEntityTypeView()).isConsistent() && !entityTypeView.getConsistentEdmEntityTypes().isEmpty()) {
                JPAEdmSchema.this.schema.setEntityTypes(entityTypeView.getConsistentEdmEntityTypes());
            }
            if (JPAEdmSchema.this.complexTypeView.isConsistent()) {
                List complexTypes = JPAEdmSchema.this.complexTypeView.getConsistentEdmComplexTypes();
                ArrayList<ComplexType> existingComplexTypes = new ArrayList<ComplexType>();
                for (ComplexType complexType : complexTypes) {
                    if (complexType == null || !JPAEdmSchema.this.complexTypeView.isReferencedInKey(complexType.getName())) continue;
                    existingComplexTypes.add(complexType);
                }
                if (!existingComplexTypes.isEmpty()) {
                    JPAEdmSchema.this.schema.setComplexTypes(existingComplexTypes);
                }
            }
            ArrayList<String> existingAssociationList = new ArrayList<String>();
            if (JPAEdmSchema.this.associationView.isConsistent() && !JPAEdmSchema.this.associationView.getConsistentEdmAssociationList().isEmpty()) {
                List consistentAssociationList = JPAEdmSchema.this.associationView.getConsistentEdmAssociationList();
                JPAEdmSchema.this.schema.setAssociations(consistentAssociationList);
                for (Association association : consistentAssociationList) {
                    existingAssociationList.add(association.getName());
                }
            }
            if ((entityTypes = JPAEdmSchema.this.entityContainerView.getJPAEdmEntitySetView().getJPAEdmEntityTypeView().getConsistentEdmEntityTypes()) != null && !entityTypes.isEmpty()) {
                for (EntityType entityType : entityTypes) {
                    ArrayList<NavigationProperty> consistentNavigationProperties = null;
                    List navigationProperties = entityType.getNavigationProperties();
                    if (navigationProperties == null) continue;
                    consistentNavigationProperties = new ArrayList<NavigationProperty>();
                    for (NavigationProperty navigationProperty : navigationProperties) {
                        if (!existingAssociationList.contains(navigationProperty.getRelationship().getName())) continue;
                        consistentNavigationProperties.add(navigationProperty);
                    }
                    if (consistentNavigationProperties.isEmpty()) {
                        entityType.setNavigationProperties(null);
                        continue;
                    }
                    entityType.setNavigationProperties(consistentNavigationProperties);
                }
            }
            if ((edmExtension = JPAEdmSchema.this.getJPAEdmExtension()) != null) {
                edmExtension.extendJPAEdmSchema((JPAEdmSchemaView)JPAEdmSchema.this);
                edmExtension.extendWithOperation((JPAEdmSchemaView)JPAEdmSchema.this);
                JPAEdmFunctionImport functionImportView = new JPAEdmFunctionImport(JPAEdmSchema.this);
                functionImportView.getBuilder().build();
                if (functionImportView.getConsistentFunctionImportList() != null) {
                    JPAEdmSchema.this.entityContainerView.getEdmEntityContainer().setFunctionImports(functionImportView.getConsistentFunctionImportList());
                }
            }
        }
    }
}

