/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.callback;

import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.ep.callback.TombstoneCallback;
import org.apache.olingo.odata2.api.ep.callback.TombstoneCallbackResult;
import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;

public class JPATombstoneCallBackFI
implements TombstoneCallback {
    private static final String DELTA_TOKEN_STRING = "?!deltatoken=";
    private String baseUri;
    private String deltaTokenValue;
    private GetFunctionImportUriInfo resultsView;

    public JPATombstoneCallBackFI(String baseUri, GetFunctionImportUriInfo resultsView, String deltaTokenValue) {
        this.baseUri = baseUri;
        this.deltaTokenValue = deltaTokenValue;
        this.resultsView = resultsView;
    }

    public TombstoneCallbackResult getTombstoneCallbackResult() {
        TombstoneCallbackResult jpaTombstoneCallBackResult = new TombstoneCallbackResult();
        jpaTombstoneCallBackResult.setDeltaLink(this.buildToken());
        return jpaTombstoneCallBackResult;
    }

    private String buildToken() {
        StringBuilder tokenBuilder = new StringBuilder();
        if (this.baseUri != null) {
            tokenBuilder.append(this.baseUri);
        }
        try {
            if (this.resultsView != null) {
                tokenBuilder.append(this.resultsView.getFunctionImport().getEntitySet().getName());
            }
        }
        catch (EdmException edmException) {
            // empty catch block
        }
        tokenBuilder.append(DELTA_TOKEN_STRING);
        if (this.deltaTokenValue != null) {
            tokenBuilder.append(this.deltaTokenValue);
        }
        return tokenBuilder.toString();
    }
}

