/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.olingo.odata2.api.annotation.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.annotation.edm.EdmFunctionImportParameter;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.Facets;
import org.apache.olingo.odata2.api.edm.provider.FunctionImport;
import org.apache.olingo.odata2.api.edm.provider.FunctionImportParameter;
import org.apache.olingo.odata2.api.edm.provider.Mapping;
import org.apache.olingo.odata2.api.edm.provider.ReturnType;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmBuilder;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmBaseView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmComplexTypeView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntityTypeView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmFunctionImportView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmSchemaView;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPAEdmNameBuilder;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPATypeConverter;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmBaseViewImpl;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;

public class JPAEdmFunctionImport
extends JPAEdmBaseViewImpl
implements JPAEdmFunctionImportView {
    private List<FunctionImport> consistentFunctionImportList = new ArrayList<FunctionImport>();
    private JPAEdmBuilder builder = null;
    private JPAEdmSchemaView schemaView;

    public JPAEdmFunctionImport(JPAEdmSchemaView view) {
        super((JPAEdmBaseView)view);
        this.schemaView = view;
    }

    public JPAEdmBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new JPAEdmFunctionImportBuilder();
        }
        return this.builder;
    }

    public List<FunctionImport> getConsistentFunctionImportList() {
        return this.consistentFunctionImportList;
    }

    protected class JPAEdmFunctionImportBuilder
    implements JPAEdmBuilder {
        private JPAEdmEntityTypeView jpaEdmEntityTypeView = null;
        private JPAEdmComplexTypeView jpaEdmComplexTypeView = null;

        protected JPAEdmFunctionImportBuilder() {
        }

        public void build() throws ODataJPAModelException, ODataJPARuntimeException {
            HashMap customOperations = JPAEdmFunctionImport.this.schemaView.getRegisteredOperations();
            this.jpaEdmEntityTypeView = JPAEdmFunctionImport.this.schemaView.getJPAEdmEntityContainerView().getJPAEdmEntitySetView().getJPAEdmEntityTypeView();
            this.jpaEdmComplexTypeView = JPAEdmFunctionImport.this.schemaView.getJPAEdmComplexTypeView();
            if (customOperations != null) {
                for (Class clazz : customOperations.keySet()) {
                    String[] operationNames = (String[])customOperations.get(clazz);
                    Method[] methods = clazz.getMethods();
                    Method method = null;
                    int length = 0;
                    length = operationNames != null ? operationNames.length : methods.length;
                    boolean found = false;
                    for (int i = 0; i < length; ++i) {
                        try {
                            if (operationNames != null) {
                                for (Method method2 : methods) {
                                    if (!method2.getName().equals(operationNames[i])) continue;
                                    found = true;
                                    method = method2;
                                    break;
                                }
                                if (!found) continue;
                                found = false;
                            } else {
                                method = methods[i];
                            }
                            FunctionImport functionImport = this.buildFunctionImport(method);
                            if (functionImport == null) continue;
                            JPAEdmFunctionImport.this.consistentFunctionImportList.add(functionImport);
                            continue;
                        }
                        catch (SecurityException e) {
                            throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.GENERAL, (Throwable)e);
                        }
                    }
                }
            }
        }

        private FunctionImport buildFunctionImport(Method method) throws ODataJPAModelException {
            EdmFunctionImport edmAnnotationFunctionImport = method.getAnnotation(EdmFunctionImport.class);
            if (edmAnnotationFunctionImport != null && edmAnnotationFunctionImport.returnType() != null) {
                return this.buildEdmFunctionImport(method, edmAnnotationFunctionImport);
            }
            return null;
        }

        private FunctionImport buildEdmFunctionImport(Method method, EdmFunctionImport edmAnnotationFunctionImport) throws ODataJPAModelException {
            if (edmAnnotationFunctionImport != null && edmAnnotationFunctionImport.returnType() != null) {
                FunctionImport functionImport = new FunctionImport();
                if ("".equals(edmAnnotationFunctionImport.name())) {
                    functionImport.setName(method.getName());
                } else {
                    functionImport.setName(edmAnnotationFunctionImport.name());
                }
                JPAEdmMappingImpl mapping = new JPAEdmMappingImpl();
                ((Mapping)mapping).setInternalName(method.getName());
                mapping.setJPAType(method.getDeclaringClass());
                functionImport.setMapping((Mapping)mapping);
                functionImport.setHttpMethod(edmAnnotationFunctionImport.httpMethod().name().toString());
                this.buildEdmReturnType(functionImport, method, edmAnnotationFunctionImport);
                this.buildEdmParameter(functionImport, method);
                return functionImport;
            }
            return null;
        }

        private void buildEdmParameter(FunctionImport functionImport, Method method) throws ODataJPAModelException {
            Annotation[][] annotations = method.getParameterAnnotations();
            Class<?>[] parameterTypes = method.getParameterTypes();
            ArrayList<FunctionImportParameter> funcImpList = new ArrayList<FunctionImportParameter>();
            JPAEdmMappingImpl mapping = null;
            int j = 0;
            for (Annotation[] annotationArr : annotations) {
                Class<?> parameterType = parameterTypes[j++];
                for (Annotation element : annotationArr) {
                    if (!(element instanceof EdmFunctionImportParameter)) continue;
                    EdmFunctionImportParameter annotation = (EdmFunctionImportParameter)element;
                    FunctionImportParameter functionImportParameter = new FunctionImportParameter();
                    if ("".equals(annotation.name())) {
                        throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.FUNC_PARAM_NAME_EXP.addContent(new Object[]{method.getDeclaringClass().getName(), method.getName()}), null);
                    }
                    functionImportParameter.setName(annotation.name());
                    functionImportParameter.setType(JPATypeConverter.convertToEdmSimpleType(parameterType, null));
                    Facets facets = new Facets();
                    if (annotation.facets().maxLength() > 0) {
                        facets.setMaxLength(Integer.valueOf(annotation.facets().maxLength()));
                    }
                    if (!annotation.facets().nullable()) {
                        facets.setNullable(Boolean.valueOf(false));
                    } else {
                        facets.setNullable(Boolean.valueOf(true));
                    }
                    if (annotation.facets().precision() > 0) {
                        facets.setPrecision(Integer.valueOf(annotation.facets().precision()));
                    }
                    if (annotation.facets().scale() >= 0) {
                        facets.setScale(Integer.valueOf(annotation.facets().scale()));
                    }
                    functionImportParameter.setFacets((EdmFacets)facets);
                    mapping = new JPAEdmMappingImpl();
                    mapping.setJPAType(parameterType);
                    functionImportParameter.setMapping((Mapping)mapping);
                    funcImpList.add(functionImportParameter);
                }
            }
            if (!funcImpList.isEmpty()) {
                functionImport.setParameters(funcImpList);
            }
        }

        private void buildEdmReturnType(FunctionImport functionImport, Method method, EdmFunctionImport edmAnnotationFunctionImport) throws ODataJPAModelException {
            EdmFunctionImport.ReturnType returnType = edmAnnotationFunctionImport.returnType();
            if (returnType != null) {
                Class<?> methodReturnType;
                ReturnType functionReturnType = new ReturnType();
                if (returnType.isCollection()) {
                    functionReturnType.setMultiplicity(EdmMultiplicity.MANY);
                } else {
                    functionReturnType.setMultiplicity(EdmMultiplicity.ONE);
                }
                if (returnType.type() == EdmFunctionImport.ReturnType.Type.ENTITY) {
                    String entitySet = edmAnnotationFunctionImport.entitySet();
                    if ("".equals(entitySet)) {
                        throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.FUNC_ENTITYSET_EXP, null);
                    }
                    functionImport.setEntitySet(entitySet);
                }
                if ((methodReturnType = method.getReturnType()) == null || "void".equals(methodReturnType.getName())) {
                    throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.FUNC_RETURN_TYPE_EXP.addContent(new Object[]{method.getDeclaringClass(), method.getName()}), null);
                }
                switch (returnType.type()) {
                    case ENTITY: {
                        EntityType edmEntityType = null;
                        edmEntityType = !returnType.isCollection() ? this.jpaEdmEntityTypeView.searchEdmEntityType(methodReturnType.getSimpleName()) : this.jpaEdmEntityTypeView.searchEdmEntityType(this.getReturnTypeSimpleName(method));
                        if (edmEntityType == null) {
                            throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.FUNC_RETURN_TYPE_ENTITY_NOT_FOUND.addContent(new Object[]{method.getDeclaringClass(), method.getName(), methodReturnType.getSimpleName()}), null);
                        }
                        functionReturnType.setTypeName(JPAEdmNameBuilder.build((JPAEdmBaseView)JPAEdmFunctionImport.this.schemaView, edmEntityType.getName()));
                        break;
                    }
                    case SIMPLE: {
                        EdmSimpleTypeKind edmSimpleTypeKind = JPATypeConverter.convertToEdmSimpleType(methodReturnType, null);
                        functionReturnType.setTypeName(edmSimpleTypeKind.getFullQualifiedName());
                        break;
                    }
                    case COMPLEX: {
                        String embeddableTypeName = null;
                        ComplexType complexType = null;
                        boolean exists = false;
                        embeddableTypeName = !returnType.isCollection() ? methodReturnType.getName() : this.getReturnTypeName(method);
                        complexType = this.jpaEdmComplexTypeView.searchEdmComplexType(embeddableTypeName);
                        if (complexType == null) {
                            List complexTypeList = JPAEdmFunctionImport.this.schemaView.getEdmSchema().getComplexTypes();
                            String[] complexTypeNameParts = embeddableTypeName.split("\\.");
                            String complexTypeName = complexTypeNameParts[complexTypeNameParts.length - 1];
                            for (ComplexType complexType1 : complexTypeList) {
                                if (!complexType1.getName().equals(complexTypeName)) continue;
                                complexType = complexType1;
                                exists = true;
                                break;
                            }
                            if (!exists) {
                                throw ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.FUNC_RETURN_TYPE_ENTITY_NOT_FOUND.addContent(new Object[]{method.getDeclaringClass(), method.getName(), methodReturnType.getSimpleName()}), null);
                            }
                        }
                        functionReturnType.setTypeName(JPAEdmNameBuilder.build((JPAEdmBaseView)JPAEdmFunctionImport.this.schemaView, complexType.getName()));
                        break;
                    }
                }
                functionImport.setReturnType(functionReturnType);
            }
        }

        private String getReturnTypeName(Method method) {
            try {
                ParameterizedType pt = (ParameterizedType)method.getGenericReturnType();
                Type t = pt.getActualTypeArguments()[0];
                return ((Class)t).getName();
            }
            catch (ClassCastException e) {
                return method.getReturnType().getName();
            }
        }

        private String getReturnTypeSimpleName(Method method) {
            try {
                ParameterizedType pt = (ParameterizedType)method.getGenericReturnType();
                Type t = pt.getActualTypeArguments()[0];
                return ((Class)t).getSimpleName();
            }
            catch (ClassCastException e) {
                return method.getReturnType().getSimpleName();
            }
        }
    }
}

