/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmLiteralKind;
import org.apache.olingo.odata2.api.edm.EdmMapping;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeException;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataNotImplementedException;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.BinaryOperator;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.LiteralExpression;
import org.apache.olingo.odata2.api.uri.expression.MemberExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodOperator;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderExpression;
import org.apache.olingo.odata2.api.uri.expression.PropertyExpression;
import org.apache.olingo.odata2.api.uri.expression.SortOrder;
import org.apache.olingo.odata2.api.uri.expression.UnaryExpression;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;

public class ODataExpressionParser {
    public static final String EMPTY = "";
    public static final ThreadLocal<Integer> methodFlag = new ThreadLocal();

    public static String parseToJPAWhereExpression(CommonExpression whereExpression, String tableAlias) throws ODataException {
        switch (whereExpression.getKind()) {
            case UNARY: {
                UnaryExpression unaryExpression = (UnaryExpression)whereExpression;
                String operand = ODataExpressionParser.parseToJPAWhereExpression(unaryExpression.getOperand(), tableAlias);
                switch (unaryExpression.getOperator()) {
                    case NOT: {
                        return "NOT(" + operand + ')';
                    }
                    case MINUS: {
                        if (operand.startsWith("-")) {
                            return operand.substring(1);
                        }
                        return "-" + operand;
                    }
                }
                throw new ODataNotImplementedException();
            }
            case FILTER: {
                return ODataExpressionParser.parseToJPAWhereExpression(((FilterExpression)whereExpression).getExpression(), tableAlias);
            }
            case BINARY: {
                BinaryExpression binaryExpression = (BinaryExpression)whereExpression;
                MethodOperator operator = null;
                if (binaryExpression.getLeftOperand().getKind() == ExpressionKind.METHOD) {
                    operator = ((MethodExpression)binaryExpression.getLeftOperand()).getMethod();
                }
                if (operator != null && (binaryExpression.getOperator() == BinaryOperator.EQ || binaryExpression.getOperator() == BinaryOperator.NE) && operator == MethodOperator.SUBSTRINGOF) {
                    methodFlag.set(1);
                }
                String left = ODataExpressionParser.parseToJPAWhereExpression(binaryExpression.getLeftOperand(), tableAlias);
                String right = ODataExpressionParser.parseToJPAWhereExpression(binaryExpression.getRightOperand(), tableAlias);
                if (operator != null && (operator == MethodOperator.STARTSWITH || operator == MethodOperator.ENDSWITH)) {
                    if (!binaryExpression.getOperator().equals((Object)BinaryOperator.EQ)) {
                        throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.OPERATOR_EQ_NE_MISSING.addContent(new Object[]{binaryExpression.getOperator().toString()}), null);
                    }
                    if (right.equals("false")) {
                        return '(' + left.replaceFirst("LIKE", "NOT LIKE") + ' ' + ')';
                    }
                    return '(' + left + ' ' + ')';
                }
                switch (binaryExpression.getOperator()) {
                    case AND: {
                        return '(' + left + ' ' + "AND" + ' ' + right + ')';
                    }
                    case OR: {
                        return '(' + left + ' ' + "OR" + ' ' + right + ')';
                    }
                    case EQ: {
                        return '(' + left + ' ' + "=" + ' ' + right + ')';
                    }
                    case NE: {
                        return '(' + left + ' ' + "<>" + ' ' + right + ')';
                    }
                    case LT: {
                        return '(' + left + ' ' + "<" + ' ' + right + ')';
                    }
                    case LE: {
                        return '(' + left + ' ' + "<=" + ' ' + right + ')';
                    }
                    case GT: {
                        return '(' + left + ' ' + ">" + ' ' + right + ')';
                    }
                    case GE: {
                        return '(' + left + ' ' + ">=" + ' ' + right + ')';
                    }
                    case PROPERTY_ACCESS: {
                        throw new ODataNotImplementedException();
                    }
                }
                throw new ODataNotImplementedException();
            }
            case PROPERTY: {
                String returnStr = tableAlias + '.' + ODataExpressionParser.getPropertyName(whereExpression);
                return returnStr;
            }
            case MEMBER: {
                String memberExpStr = EMPTY;
                int i = 0;
                MemberExpression member = null;
                CommonExpression tempExp = whereExpression;
                while (tempExp != null && tempExp.getKind() == ExpressionKind.MEMBER) {
                    member = (MemberExpression)tempExp;
                    if (i > 0) {
                        memberExpStr = '.' + memberExpStr;
                    }
                    ++i;
                    memberExpStr = ODataExpressionParser.getPropertyName(member.getProperty()) + memberExpStr;
                    tempExp = member.getPath();
                }
                memberExpStr = ODataExpressionParser.getPropertyName(tempExp) + '.' + memberExpStr;
                return tableAlias + '.' + memberExpStr;
            }
            case LITERAL: {
                LiteralExpression literal = (LiteralExpression)whereExpression;
                EdmSimpleType literalType = (EdmSimpleType)literal.getEdmType();
                EdmLiteral uriLiteral = EdmSimpleTypeKind.parseUriLiteral((String)literal.getUriLiteral());
                return ODataExpressionParser.evaluateComparingExpression(uriLiteral.getLiteral(), literalType);
            }
            case METHOD: {
                MethodExpression methodExpression = (MethodExpression)whereExpression;
                String first = ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(0), tableAlias);
                String second = methodExpression.getParameterCount() > 1 ? ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(1), tableAlias) : null;
                String third = methodExpression.getParameterCount() > 2 ? ODataExpressionParser.parseToJPAWhereExpression((CommonExpression)methodExpression.getParameters().get(2), tableAlias) : null;
                switch (methodExpression.getMethod()) {
                    case SUBSTRING: {
                        third = third != null ? ", " + third : EMPTY;
                        return String.format("SUBSTRING(%s, %s + 1 %s)", first, second, third);
                    }
                    case SUBSTRINGOF: {
                        if (methodFlag.get() != null && methodFlag.get() == 1) {
                            methodFlag.set(null);
                            return String.format("(CASE WHEN (%s LIKE CONCAT('%%',%s,'%%')) THEN TRUE ELSE FALSE END)", second, first);
                        }
                        return String.format("(CASE WHEN (%s LIKE CONCAT('%%',%s,'%%')) THEN TRUE ELSE FALSE END) = true", second, first);
                    }
                    case TOLOWER: {
                        return String.format("LOWER(%s)", first);
                    }
                    case STARTSWITH: {
                        return String.format("%s LIKE CONCAT(%s,'%%')", first, second);
                    }
                    case ENDSWITH: {
                        return String.format("%s LIKE CONCAT('%%',%s)", first, second);
                    }
                }
                throw new ODataNotImplementedException();
            }
        }
        throw new ODataNotImplementedException();
    }

    public static String parseToJPASelectExpression(String tableAlias, ArrayList<String> selectedFields) {
        if (selectedFields == null || selectedFields.size() == 0) {
            return tableAlias;
        }
        String selectClause = EMPTY;
        Iterator<String> itr = selectedFields.iterator();
        int count = 0;
        while (itr.hasNext()) {
            selectClause = selectClause + tableAlias + '.' + itr.next();
            if (++count >= selectedFields.size()) continue;
            selectClause = selectClause + ',' + ' ';
        }
        return selectClause;
    }

    public static String parseToJPAOrderByExpression(OrderByExpression orderByExpression, String tableAlias) throws ODataJPARuntimeException {
        String jpqlOrderByExpression = EMPTY;
        if (orderByExpression != null && orderByExpression.getOrders() != null) {
            List orderBys = orderByExpression.getOrders();
            String orderByField = null;
            String orderByDirection = null;
            for (OrderExpression orderBy : orderBys) {
                try {
                    orderByField = orderBy.getExpression().getKind() == ExpressionKind.MEMBER ? ODataExpressionParser.parseToJPAWhereExpression(orderBy.getExpression(), tableAlias) : tableAlias + '.' + ODataExpressionParser.getPropertyName(orderBy.getExpression());
                    orderByDirection = orderBy.getSortOrder() == SortOrder.asc ? EMPTY : " DESC";
                    jpqlOrderByExpression = jpqlOrderByExpression + orderByField + orderByDirection + " , ";
                }
                catch (EdmException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
                catch (ODataException e) {
                    throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
        }
        return ODataExpressionParser.normalizeOrderByExpression(jpqlOrderByExpression);
    }

    private static String normalizeOrderByExpression(String jpqlOrderByExpression) {
        if (jpqlOrderByExpression != EMPTY) {
            return jpqlOrderByExpression.substring(0, jpqlOrderByExpression.length() - 3);
        }
        return jpqlOrderByExpression;
    }

    public static String parseKeyPredicates(List<KeyPredicate> keyPredicates, String tableAlias) throws ODataJPARuntimeException {
        String literal = null;
        String propertyName = null;
        EdmSimpleType edmSimpleType = null;
        StringBuilder keyFilters = new StringBuilder();
        int i = 0;
        for (KeyPredicate keyPredicate : keyPredicates) {
            if (i > 0) {
                keyFilters.append(" AND ");
            }
            ++i;
            literal = keyPredicate.getLiteral();
            try {
                propertyName = keyPredicate.getProperty().getMapping().getInternalName();
                edmSimpleType = (EdmSimpleType)keyPredicate.getProperty().getType();
            }
            catch (EdmException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
            literal = ODataExpressionParser.evaluateComparingExpression(literal, edmSimpleType);
            if (edmSimpleType == EdmSimpleTypeKind.DateTime.getEdmSimpleTypeInstance() || edmSimpleType == EdmSimpleTypeKind.DateTimeOffset.getEdmSimpleTypeInstance()) {
                literal = literal.substring(literal.indexOf(39), literal.indexOf(125));
            }
            keyFilters.append(tableAlias + '.' + propertyName + ' ' + "=" + ' ' + literal);
        }
        if (keyFilters.length() > 0) {
            return keyFilters.toString();
        }
        return null;
    }

    public static String parseKeyPropertiesToJPAOrderByExpression(List<EdmProperty> edmPropertylist, String tableAlias) throws ODataJPARuntimeException {
        String propertyName = null;
        String orderExpression = EMPTY;
        if (edmPropertylist == null) {
            return orderExpression;
        }
        for (EdmProperty edmProperty : edmPropertylist) {
            try {
                EdmMapping mapping = edmProperty.getMapping();
                propertyName = mapping != null && mapping.getInternalName() != null ? mapping.getInternalName() : edmProperty.getName();
            }
            catch (EdmException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
            orderExpression = orderExpression + tableAlias + '.' + propertyName + " , ";
        }
        return ODataExpressionParser.normalizeOrderByExpression(orderExpression);
    }

    private static String evaluateComparingExpression(String uriLiteral, EdmSimpleType edmSimpleType) throws ODataJPARuntimeException {
        if (EdmSimpleTypeKind.String.getEdmSimpleTypeInstance().isCompatible(edmSimpleType) || EdmSimpleTypeKind.Guid.getEdmSimpleTypeInstance().isCompatible(edmSimpleType)) {
            uriLiteral = uriLiteral.replaceAll("'", "''");
            uriLiteral = "'" + uriLiteral + "'";
        } else if (EdmSimpleTypeKind.DateTime.getEdmSimpleTypeInstance().isCompatible(edmSimpleType) || EdmSimpleTypeKind.DateTimeOffset.getEdmSimpleTypeInstance().isCompatible(edmSimpleType)) {
            try {
                Calendar datetime = (Calendar)edmSimpleType.valueOfString(uriLiteral, EdmLiteralKind.DEFAULT, null, edmSimpleType.getDefaultType());
                String year = String.format("%04d", datetime.get(1));
                String month = String.format("%02d", datetime.get(2) + 1);
                String day = String.format("%02d", datetime.get(5));
                String hour = String.format("%02d", datetime.get(11));
                String min = String.format("%02d", datetime.get(12));
                String sec = String.format("%02d", datetime.get(13));
                uriLiteral = "{ts '" + year + '-' + month + '-' + day + ' ' + hour + ':' + min + ':' + sec + ".000" + "'" + '}';
            }
            catch (EdmSimpleTypeException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
        } else if (EdmSimpleTypeKind.Time.getEdmSimpleTypeInstance().isCompatible(edmSimpleType)) {
            try {
                Calendar time = (Calendar)edmSimpleType.valueOfString(uriLiteral, EdmLiteralKind.DEFAULT, null, edmSimpleType.getDefaultType());
                String hourValue = String.format("%02d", time.get(11));
                String minValue = String.format("%02d", time.get(12));
                String secValue = String.format("%02d", time.get(13));
                uriLiteral = "'" + hourValue + ':' + minValue + ':' + secValue + "'";
            }
            catch (EdmSimpleTypeException e) {
                throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.GENERAL.addContent(new Object[]{e.getMessage()}), (Throwable)e);
            }
        } else if (edmSimpleType.getDefaultType().equals(Long.class)) {
            uriLiteral = uriLiteral + 'L';
        }
        return uriLiteral;
    }

    private static String getPropertyName(CommonExpression whereExpression) throws EdmException {
        EdmProperty property = (EdmProperty)((PropertyExpression)whereExpression).getEdmProperty();
        EdmMapping mapping = property.getMapping();
        String name = mapping != null ? mapping.getInternalName() : property.getName();
        return name;
    }
}

