/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.access.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.jpa.processor.api.ODataJPAContext;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmMappingModelAccess;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmExtension;
import org.apache.olingo.odata2.jpa.processor.api.model.mapping.JPAAttributeMapType;
import org.apache.olingo.odata2.jpa.processor.api.model.mapping.JPAEdmMappingModel;
import org.apache.olingo.odata2.jpa.processor.api.model.mapping.JPAEmbeddableTypeMapType;
import org.apache.olingo.odata2.jpa.processor.api.model.mapping.JPAEntityTypeMapType;
import org.apache.olingo.odata2.jpa.processor.api.model.mapping.JPAPersistenceUnitMapType;
import org.apache.olingo.odata2.jpa.processor.api.model.mapping.JPARelationshipMapType;

public class JPAEdmMappingModelService
implements JPAEdmMappingModelAccess {
    boolean mappingModelExists = true;
    private JPAEdmMappingModel mappingModel;
    private InputStream mappingModelStream = null;
    private String mappingModelName;

    public JPAEdmMappingModelService(ODataJPAContext ctx) {
        JPAEdmExtension ext = null;
        this.mappingModelName = ctx.getJPAEdmMappingModel();
        if (this.mappingModelName == null && (ext = ctx.getJPAEdmExtension()) != null) {
            this.mappingModelStream = ext.getJPAEdmMappingModelStream();
        }
        this.mappingModelExists = this.mappingModelName != null || this.mappingModelStream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMappingModel() {
        InputStream is = null;
        if (this.mappingModelExists) {
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{JPAEdmMappingModel.class});
                Unmarshaller unmarshaller = context.createUnmarshaller();
                is = this.loadMappingModelInputStream();
                if (is == null) {
                    this.mappingModelExists = false;
                    return;
                }
                this.mappingModel = (JPAEdmMappingModel)unmarshaller.unmarshal(is);
                if (this.mappingModel != null) {
                    this.mappingModelExists = true;
                }
            }
            catch (JAXBException e) {
                this.mappingModelExists = false;
                ODataJPAModelException.throwException((MessageReference)ODataJPAModelException.GENERAL, (Throwable)e);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isMappingModelExists() {
        return this.mappingModelExists;
    }

    public JPAEdmMappingModel getJPAEdmMappingModel() {
        return this.mappingModel;
    }

    public String mapJPAPersistenceUnit(String persistenceUnitName) {
        JPAPersistenceUnitMapType persistenceUnit = this.mappingModel.getPersistenceUnit();
        if (persistenceUnit.getName().equals(persistenceUnitName)) {
            return persistenceUnit.getEDMSchemaNamespace();
        }
        return null;
    }

    public String mapJPAEntityType(String jpaEntityTypeName) {
        JPAEntityTypeMapType jpaEntityTypeMap = this.searchJPAEntityTypeMapType(jpaEntityTypeName);
        if (jpaEntityTypeMap != null) {
            return jpaEntityTypeMap.getEDMEntityType();
        }
        return null;
    }

    public String mapJPAEntitySet(String jpaEntityTypeName) {
        JPAEntityTypeMapType jpaEntityTypeMap = this.searchJPAEntityTypeMapType(jpaEntityTypeName);
        if (jpaEntityTypeMap != null) {
            return jpaEntityTypeMap.getEDMEntitySet();
        }
        return null;
    }

    public String mapJPAAttribute(String jpaEntityTypeName, String jpaAttributeName) {
        JPAEntityTypeMapType jpaEntityTypeMap = this.searchJPAEntityTypeMapType(jpaEntityTypeName);
        if (jpaEntityTypeMap != null && jpaEntityTypeMap.getJPAAttributes() != null) {
            for (JPAAttributeMapType.JPAAttribute jpaAttribute : jpaEntityTypeMap.getJPAAttributes().getJPAAttribute()) {
                if (!jpaAttribute.getName().equals(jpaAttributeName)) continue;
                return jpaAttribute.getValue();
            }
        }
        return null;
    }

    public String mapJPARelationship(String jpaEntityTypeName, String jpaRelationshipName) {
        JPAEntityTypeMapType jpaEntityTypeMap = this.searchJPAEntityTypeMapType(jpaEntityTypeName);
        if (jpaEntityTypeMap != null && jpaEntityTypeMap.getJPARelationships() != null) {
            for (JPARelationshipMapType.JPARelationship jpaRealtionship : jpaEntityTypeMap.getJPARelationships().getJPARelationship()) {
                if (!jpaRealtionship.getName().equals(jpaRelationshipName)) continue;
                return jpaRealtionship.getValue();
            }
        }
        return null;
    }

    public String mapJPAEmbeddableType(String jpaEmbeddableTypeName) {
        JPAEmbeddableTypeMapType jpaEmbeddableType = this.searchJPAEmbeddableTypeMapType(jpaEmbeddableTypeName);
        if (jpaEmbeddableType != null) {
            return jpaEmbeddableType.getEDMComplexType();
        }
        return null;
    }

    public String mapJPAEmbeddableTypeAttribute(String jpaEmbeddableTypeName, String jpaAttributeName) {
        JPAEmbeddableTypeMapType jpaEmbeddableType = this.searchJPAEmbeddableTypeMapType(jpaEmbeddableTypeName);
        if (jpaEmbeddableType != null && jpaEmbeddableType.getJPAAttributes() != null) {
            for (JPAAttributeMapType.JPAAttribute jpaAttribute : jpaEmbeddableType.getJPAAttributes().getJPAAttribute()) {
                if (!jpaAttribute.getName().equals(jpaAttributeName)) continue;
                return jpaAttribute.getValue();
            }
        }
        return null;
    }

    private JPAEntityTypeMapType searchJPAEntityTypeMapType(String jpaEntityTypeName) {
        if (this.mappingModel != null) {
            List types = this.mappingModel.getPersistenceUnit().getJPAEntityTypes().getJPAEntityType();
            for (JPAEntityTypeMapType jpaEntityType : types) {
                if (!jpaEntityType.getName().equals(jpaEntityTypeName)) continue;
                return jpaEntityType;
            }
        }
        return null;
    }

    private JPAEmbeddableTypeMapType searchJPAEmbeddableTypeMapType(String jpaEmbeddableTypeName) {
        for (JPAEmbeddableTypeMapType jpaEmbeddableType : this.mappingModel.getPersistenceUnit().getJPAEmbeddableTypes().getJPAEmbeddableType()) {
            if (!jpaEmbeddableType.getName().equals(jpaEmbeddableTypeName)) continue;
            return jpaEmbeddableType;
        }
        return null;
    }

    protected InputStream loadMappingModelInputStream() {
        if (this.mappingModelStream != null) {
            return this.mappingModelStream;
        }
        return JPAEdmMappingModelService.class.getClassLoader().getResourceAsStream("../../" + this.mappingModelName);
    }

    public boolean checkExclusionOfJPAEntityType(String jpaEntityTypeName) {
        JPAEntityTypeMapType type = this.searchJPAEntityTypeMapType(jpaEntityTypeName);
        if (type != null) {
            return type.isExclude();
        }
        return false;
    }

    public boolean checkExclusionOfJPAAttributeType(String jpaEntityTypeName, String jpaAttributeName) {
        JPAEntityTypeMapType type = this.searchJPAEntityTypeMapType(jpaEntityTypeName);
        if (type != null && type.getJPAAttributes() != null) {
            for (JPAAttributeMapType.JPAAttribute jpaAttribute : type.getJPAAttributes().getJPAAttribute()) {
                if (!jpaAttribute.getName().equals(jpaAttributeName)) continue;
                return jpaAttribute.isExclude();
            }
        }
        return false;
    }

    public boolean checkExclusionOfJPAEmbeddableType(String jpaEmbeddableTypeName) {
        JPAEmbeddableTypeMapType type = this.searchJPAEmbeddableTypeMapType(jpaEmbeddableTypeName);
        if (type != null) {
            return type.isExclude();
        }
        return false;
    }

    public boolean checkExclusionOfJPAEmbeddableAttributeType(String jpaEmbeddableTypeName, String jpaAttributeName) {
        JPAEmbeddableTypeMapType type = this.searchJPAEmbeddableTypeMapType(jpaEmbeddableTypeName);
        if (type != null && type.getJPAAttributes() != null) {
            for (JPAAttributeMapType.JPAAttribute jpaAttribute : type.getJPAAttributes().getJPAAttribute()) {
                if (!jpaAttribute.getName().equals(jpaAttributeName)) continue;
                return jpaAttribute.isExclude();
            }
        }
        return false;
    }
}

