/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.jpql;

import java.util.List;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAJoinClause;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextType;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLJoinContextView;
import org.apache.olingo.odata2.jpa.processor.api.jpql.JPQLStatement;

public class JPQLJoinStatementBuilder
extends JPQLStatement.JPQLStatementBuilder {
    JPQLStatement jpqlStatement;
    private JPQLJoinContextView context;

    public JPQLJoinStatementBuilder(JPQLContextView context) {
        this.context = (JPQLJoinContextView)context;
    }

    public JPQLStatement build() throws ODataJPARuntimeException {
        this.jpqlStatement = this.createStatement(this.createJPQLQuery());
        return this.jpqlStatement;
    }

    private String createJPQLQuery() throws ODataJPARuntimeException {
        StringBuilder jpqlQuery = new StringBuilder();
        StringBuilder joinWhereCondition = null;
        jpqlQuery.append("SELECT").append(' ');
        if (this.context.getType().equals((Object)JPQLContextType.JOIN_COUNT)) {
            jpqlQuery.append("COUNT").append(' ');
            jpqlQuery.append('(').append(' ');
            jpqlQuery.append(this.context.getSelectExpression()).append(' ');
            jpqlQuery.append(')').append(' ');
        } else {
            jpqlQuery.append(this.context.getSelectExpression()).append(' ');
        }
        jpqlQuery.append("FROM").append(' ');
        if (this.context.getJPAJoinClauses() != null && this.context.getJPAJoinClauses().size() > 0) {
            List joinClauseList = this.context.getJPAJoinClauses();
            JPAJoinClause joinClause = (JPAJoinClause)joinClauseList.get(0);
            String joinCondition = joinClause.getJoinCondition();
            joinWhereCondition = new StringBuilder();
            if (joinCondition != null) {
                joinWhereCondition.append(joinCondition);
            }
            String relationShipAlias = null;
            joinClause = (JPAJoinClause)joinClauseList.get(1);
            jpqlQuery.append(joinClause.getEntityName()).append(' ');
            jpqlQuery.append(joinClause.getEntityAlias());
            int limit = joinClauseList.size();
            relationShipAlias = joinClause.getEntityAlias();
            for (int i = 1; i < limit; ++i) {
                jpqlQuery.append(' ');
                jpqlQuery.append("JOIN").append(' ');
                joinClause = (JPAJoinClause)joinClauseList.get(i);
                jpqlQuery.append(relationShipAlias).append('.');
                jpqlQuery.append(joinClause.getEntityRelationShip()).append(' ');
                jpqlQuery.append(joinClause.getEntityRelationShipAlias());
                relationShipAlias = joinClause.getEntityRelationShipAlias();
                joinCondition = joinClause.getJoinCondition();
                if (joinCondition == null) continue;
                joinWhereCondition.append(" AND ");
                joinWhereCondition.append(joinCondition);
            }
        } else {
            throw ODataJPARuntimeException.throwException((MessageReference)ODataJPARuntimeException.JOIN_CLAUSE_EXPECTED, null);
        }
        String whereExpression = this.context.getWhereExpression();
        if (whereExpression != null || joinWhereCondition.length() > 0) {
            jpqlQuery.append(' ').append("WHERE").append(' ');
            if (whereExpression != null) {
                jpqlQuery.append(whereExpression);
                if (joinWhereCondition != null) {
                    jpqlQuery.append(" AND ");
                }
            }
            if (joinWhereCondition != null) {
                jpqlQuery.append(joinWhereCondition.toString());
            }
        }
        if (this.context.getOrderByCollection() != null && this.context.getOrderByCollection().length() > 0) {
            StringBuilder orderByBuilder = new StringBuilder();
            orderByBuilder.append(this.context.getOrderByCollection());
            jpqlQuery.append(' ').append("ORDER BY").append(' ');
            jpqlQuery.append((CharSequence)orderByBuilder);
        }
        return jpqlQuery.toString();
    }
}

