/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.provider.Association;
import org.apache.olingo.odata2.api.edm.provider.AssociationEnd;
import org.apache.olingo.odata2.jpa.processor.api.access.JPAEdmBuilder;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPAModelException;
import org.apache.olingo.odata2.jpa.processor.api.exception.ODataJPARuntimeException;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmAssociationEndView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmAssociationView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmBaseView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmEntityTypeView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmPropertyView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmReferentialConstraintView;
import org.apache.olingo.odata2.jpa.processor.api.model.JPAEdmSchemaView;
import org.apache.olingo.odata2.jpa.processor.core.access.model.JPAEdmNameBuilder;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmBaseViewImpl;

public class JPAEdmAssociation
extends JPAEdmBaseViewImpl
implements JPAEdmAssociationView {
    private JPAEdmAssociationEndView associationEndView;
    private Association currentAssociation;
    private List<Association> consistentAssociatonList;
    private HashMap<String, Association> associationMap;
    private HashMap<String, JPAEdmAssociationEndView> associationEndMap;
    private List<JPAEdmReferentialConstraintView> inconsistentRefConstraintViewList;
    private int numberOfSimilarEndPoints;

    public JPAEdmAssociation(JPAEdmAssociationEndView associationEndview, JPAEdmEntityTypeView entityTypeView, JPAEdmPropertyView propertyView, int value) {
        super((JPAEdmBaseView)associationEndview);
        this.associationEndView = associationEndview;
        this.numberOfSimilarEndPoints = value;
        this.init();
    }

    public JPAEdmAssociation(JPAEdmSchemaView view) {
        super((JPAEdmBaseView)view);
        this.init();
    }

    private void init() {
        this.isConsistent = false;
        this.consistentAssociatonList = new ArrayList<Association>();
        this.inconsistentRefConstraintViewList = new LinkedList<JPAEdmReferentialConstraintView>();
        this.associationMap = new HashMap();
        this.associationEndMap = new HashMap();
    }

    public JPAEdmBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new JPAEdmAssociationBuilder();
        }
        return this.builder;
    }

    public Association getEdmAssociation() {
        return this.currentAssociation;
    }

    public List<Association> getConsistentEdmAssociationList() {
        return this.consistentAssociatonList;
    }

    public Association searchAssociation(JPAEdmAssociationEndView view) {
        if (view != null) {
            for (String key : this.associationMap.keySet()) {
                Association association = this.associationMap.get(key);
                if (association == null || !view.compare(association.getEnd1(), association.getEnd2())) continue;
                JPAEdmAssociationEndView associationEnd = this.associationEndMap.get(association.getName());
                if (associationEnd.getJoinColumnNames() != null && associationEnd.getJoinColumnReferenceColumnNames() != null && view.getJoinColumnNames() != null && view.getJoinColumnReferenceColumnNames() != null && Arrays.equals(view.getJoinColumnNames(), associationEnd.getJoinColumnNames()) && Arrays.equals(view.getJoinColumnReferenceColumnNames(), associationEnd.getJoinColumnReferenceColumnNames())) {
                    this.currentAssociation = association;
                    return association;
                }
                if (associationEnd.getMappedByName() != null && associationEnd.getMappedByName().equals(view.getOwningPropertyName())) {
                    this.currentAssociation = association;
                    return association;
                }
                if (associationEnd.getOwningPropertyName() == null || !associationEnd.getOwningPropertyName().equals(view.getMappedByName())) continue;
                this.currentAssociation = association;
                return association;
            }
        }
        return null;
    }

    public void addJPAEdmAssociationView(JPAEdmAssociationView associationView, JPAEdmAssociationEndView associationEndView) {
        if (associationView != null) {
            this.currentAssociation = associationView.getEdmAssociation();
            this.associationMap.put(this.currentAssociation.getName(), this.currentAssociation);
            this.associationEndMap.put(this.currentAssociation.getName(), associationEndView);
            this.addJPAEdmRefConstraintView(associationView.getJPAEdmReferentialConstraintView());
        }
    }

    public void addJPAEdmRefConstraintView(JPAEdmReferentialConstraintView refView) {
        if (refView != null && refView.isExists()) {
            this.inconsistentRefConstraintViewList.add(refView);
        }
    }

    public JPAEdmReferentialConstraintView getJPAEdmReferentialConstraintView() {
        if (this.inconsistentRefConstraintViewList.isEmpty()) {
            return null;
        }
        return this.inconsistentRefConstraintViewList.get(0);
    }

    public int getNumberOfAssociationsWithSimilarEndPoints(JPAEdmAssociationEndView view) {
        int count = 0;
        AssociationEnd end1 = null;
        AssociationEnd end2 = null;
        for (String key : this.associationMap.keySet()) {
            Association association = this.associationMap.get(key);
            if (association == null || !view.compare(end1 = association.getEnd1(), end2 = association.getEnd2())) continue;
            ++count;
        }
        return count;
    }

    private class JPAEdmAssociationBuilder
    implements JPAEdmBuilder {
        private JPAEdmAssociationBuilder() {
        }

        public void build() throws ODataJPAModelException, ODataJPARuntimeException {
            if (JPAEdmAssociation.this.associationEndView != null && JPAEdmAssociation.this.searchAssociation(JPAEdmAssociation.this.associationEndView) == null) {
                JPAEdmAssociation.this.currentAssociation = new Association();
                JPAEdmAssociation.this.currentAssociation.setEnd1(JPAEdmAssociation.this.associationEndView.getEdmAssociationEnd1());
                JPAEdmAssociation.this.currentAssociation.setEnd2(JPAEdmAssociation.this.associationEndView.getEdmAssociationEnd2());
                JPAEdmNameBuilder.build(JPAEdmAssociation.this, JPAEdmAssociation.this.numberOfSimilarEndPoints);
                JPAEdmAssociation.this.associationMap.put(JPAEdmAssociation.this.currentAssociation.getName(), JPAEdmAssociation.this.currentAssociation);
            } else if (!JPAEdmAssociation.this.inconsistentRefConstraintViewList.isEmpty()) {
                int inconsistentRefConstraintViewSize = JPAEdmAssociation.this.inconsistentRefConstraintViewList.size();
                int index = 0;
                for (int i = 0; i < inconsistentRefConstraintViewSize; ++i) {
                    JPAEdmReferentialConstraintView view = (JPAEdmReferentialConstraintView)JPAEdmAssociation.this.inconsistentRefConstraintViewList.get(index);
                    if (view.isExists() && !view.isConsistent()) {
                        view.getBuilder().build();
                    }
                    if (view.isConsistent()) {
                        Association newAssociation = new Association();
                        this.copyAssociation(newAssociation, (Association)JPAEdmAssociation.this.associationMap.get(view.getEdmRelationShipName()));
                        newAssociation.setReferentialConstraint(view.getEdmReferentialConstraint());
                        JPAEdmAssociation.this.consistentAssociatonList.add(newAssociation);
                        JPAEdmAssociation.this.associationMap.put(view.getEdmRelationShipName(), newAssociation);
                        JPAEdmAssociation.this.inconsistentRefConstraintViewList.remove(index);
                        continue;
                    }
                    JPAEdmAssociation.this.associationMap.remove(view.getEdmRelationShipName());
                    ++index;
                }
            }
            if (JPAEdmAssociation.this.associationMap.size() == JPAEdmAssociation.this.consistentAssociatonList.size()) {
                JPAEdmAssociation.this.isConsistent = true;
            } else {
                for (String key : JPAEdmAssociation.this.associationMap.keySet()) {
                    Association association = (Association)JPAEdmAssociation.this.associationMap.get(key);
                    if (JPAEdmAssociation.this.consistentAssociatonList.contains(association)) continue;
                    JPAEdmAssociation.this.consistentAssociatonList.add(association);
                }
                JPAEdmAssociation.this.isConsistent = true;
            }
        }

        private void copyAssociation(Association copyToAssociation, Association copyFromAssociation) {
            copyToAssociation.setEnd1(copyFromAssociation.getEnd1());
            copyToAssociation.setEnd2(copyFromAssociation.getEnd2());
            copyToAssociation.setName(copyFromAssociation.getName());
            copyToAssociation.setAnnotationAttributes(copyFromAssociation.getAnnotationAttributes());
            copyToAssociation.setAnnotationElements(copyFromAssociation.getAnnotationElements());
            copyToAssociation.setDocumentation(copyFromAssociation.getDocumentation());
        }
    }
}

