/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.jose.jws.io;

import org.apache.oltu.commons.json.CustomizableBuilder;
import org.apache.oltu.commons.json.CustomizableEntityReader;
import org.apache.oltu.jose.jws.JWS;
import org.apache.oltu.jose.jws.io.JWSConstants;

final class JWSHeaderParser
extends CustomizableEntityReader<JWS, JWS.Builder>
implements JWSConstants {
    public JWSHeaderParser(JWS.Builder builder) {
        super((CustomizableBuilder)builder);
    }

    protected <T> boolean handleProperty(String key, T value) {
        boolean handled = true;
        if ("alg".equals(key)) {
            ((JWS.Builder)this.getBuilder()).setAlgorithm(String.valueOf(value));
        } else if ("jku".equals(key)) {
            ((JWS.Builder)this.getBuilder()).setJwkSetUrl(String.valueOf(value));
        } else if ("jwk".equals(key)) {
            ((JWS.Builder)this.getBuilder()).setJsonWebKey(String.valueOf(value));
        } else if ("x5u".equals(key)) {
            ((JWS.Builder)this.getBuilder()).setX509url(String.valueOf(value));
        } else if ("x5t".equals(key)) {
            ((JWS.Builder)this.getBuilder()).setX509CertificateThumbprint(String.valueOf(value));
        } else if ("x5c".equals(key)) {
            ((JWS.Builder)this.getBuilder()).setX509CertificateChain(String.valueOf(value));
        } else if ("kid".equals(key)) {
            ((JWS.Builder)this.getBuilder()).setKeyId(String.valueOf(value));
        } else if ("typ".equals(key)) {
            ((JWS.Builder)this.getBuilder()).setType(String.valueOf(value));
        } else if ("cty".equals(key)) {
            ((JWS.Builder)this.getBuilder()).setContentType(String.valueOf(value));
        } else if ("crit".equals(key)) {
            Object[] criticalValues = (Object[])value;
            String[] critical = new String[criticalValues.length];
            for (int i = 0; i < critical.length; ++i) {
                critical[i] = String.valueOf(criticalValues[i]);
            }
            ((JWS.Builder)this.getBuilder()).setCritical(critical);
        } else {
            handled = false;
        }
        return handled;
    }
}

