/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.jose.jws;

import org.apache.oltu.commons.encodedtoken.TokenDecoder;
import org.apache.oltu.commons.json.CustomizableBuilder;
import org.apache.oltu.jose.jws.Header;
import org.apache.oltu.jose.jws.io.JWSHeaderWriter;
import org.apache.oltu.jose.jws.signature.SignatureMethod;
import org.apache.oltu.jose.jws.signature.SigningKey;
import org.apache.oltu.jose.jws.signature.VerifyingKey;

public class JWS {
    private String rawString;
    private final Header header;
    private final String payload;
    private final String signature;

    JWS(Header header, String payload, String signature) {
        this(null, header, payload, signature);
    }

    JWS(String rawString, Header header, String payload, String signature) {
        this.rawString = rawString;
        this.header = header;
        this.payload = payload;
        this.signature = signature;
    }

    public Header getHeader() {
        return this.header;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getSignature() {
        return this.signature;
    }

    public <SK extends SigningKey, VK extends VerifyingKey> boolean acceptAlgorithm(SignatureMethod<SK, VK> method) {
        if (method == null) {
            throw new IllegalArgumentException("A signature method is required in order to verify the signature.");
        }
        if (this.header == null || this.header.getAlgorithm() == null) {
            throw new IllegalStateException("JWS token must have a valid JSON header with specified algorithm.");
        }
        return this.header.getAlgorithm().equalsIgnoreCase(method.getAlgorithm());
    }

    public <SK extends SigningKey, VK extends VerifyingKey> boolean validate(SignatureMethod<SK, VK> method, VK verifyingKey) {
        if (!this.acceptAlgorithm(method)) {
            throw new IllegalArgumentException("Impossible to verify current JWS signature with algorithm '" + method.getAlgorithm() + "', JWS header specifies message has been signed with '" + this.header.getAlgorithm() + "' algorithm.");
        }
        if (verifyingKey == null) {
            throw new IllegalArgumentException("A verifying key is required in order to verify the signature.");
        }
        if (this.payload == null) {
            throw new IllegalStateException("JWS token must have a payload.");
        }
        if (this.signature == null) {
            throw new IllegalStateException("JWS token must have a signature to be verified.");
        }
        if (this.rawString == null) {
            return method.verify(this.signature, TokenDecoder.base64Encode((String)new JWSHeaderWriter().write(this.header)), TokenDecoder.base64Encode((String)this.payload), verifyingKey);
        }
        String[] jwt = this.rawString.split("\\.");
        return method.verify(jwt[2], jwt[0], jwt[1], verifyingKey);
    }

    public static final class Builder
    extends CustomizableBuilder<JWS> {
        private String rawString;
        private String algorithm;
        private String jwkSetUrl;
        private String jsonWebKey;
        private String x509url;
        private String x509CertificateThumbprint;
        private String x509CertificateChain;
        private String keyId;
        private String type;
        private String contentType;
        private String[] critical;
        private String payload;
        private String signature;

        public Builder() {
        }

        public Builder(String rawString) {
            this.rawString = rawString;
        }

        public Builder setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder setJwkSetUrl(String jwkSetUrl) {
            this.jwkSetUrl = jwkSetUrl;
            return this;
        }

        public Builder setJsonWebKey(String jsonWebKey) {
            this.jsonWebKey = jsonWebKey;
            return this;
        }

        public Builder setX509url(String x509url) {
            this.x509url = x509url;
            return this;
        }

        public Builder setX509CertificateThumbprint(String x509CertificateThumbprint) {
            this.x509CertificateThumbprint = x509CertificateThumbprint;
            return this;
        }

        public Builder setX509CertificateChain(String x509CertificateChain) {
            this.x509CertificateChain = x509CertificateChain;
            return this;
        }

        public Builder setKeyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setCritical(String[] critical) {
            this.critical = critical;
            return this;
        }

        public Builder setPayload(String payload) {
            this.payload = payload;
            return this;
        }

        public Builder setSignature(String signature) {
            this.signature = signature;
            return this;
        }

        public <SK extends SigningKey, VK extends VerifyingKey> Builder sign(SignatureMethod<SK, VK> method, SK signingKey) {
            if (method == null) {
                throw new IllegalArgumentException("A signature method is required in order to calculate the signature.");
            }
            if (signingKey == null) {
                throw new IllegalArgumentException("A signing key is required in order to calculate the signature.");
            }
            if (this.payload == null) {
                throw new IllegalStateException("Payload needs to be set in order to sign the current JWT");
            }
            this.setAlgorithm(method.getAlgorithm());
            String header = new JWSHeaderWriter().write(new Header(this.algorithm, this.jwkSetUrl, this.jsonWebKey, this.x509url, this.x509CertificateThumbprint, this.x509CertificateChain, this.keyId, this.type, this.contentType, this.critical, this.getCustomFields()));
            return this.setSignature(method.calculate(TokenDecoder.base64Encode((String)header), TokenDecoder.base64Encode((String)this.payload), signingKey));
        }

        public JWS build() {
            return new JWS(this.rawString, new Header(this.algorithm, this.jwkSetUrl, this.jsonWebKey, this.x509url, this.x509CertificateThumbprint, this.x509CertificateChain, this.keyId, this.type, this.contentType, this.critical, this.getCustomFields()), this.payload, this.signature);
        }
    }
}

