/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.jose.jws.signature.impl;

import java.security.Signature;
import org.apache.oltu.commons.encodedtoken.TokenDecoder;
import org.apache.oltu.jose.jws.signature.SignatureMethod;
import org.apache.oltu.jose.jws.signature.impl.PrivateKey;
import org.apache.oltu.jose.jws.signature.impl.PublicKey;

public class SignatureMethodRSAImpl
implements SignatureMethod<PrivateKey, PublicKey> {
    private String algorithm;

    public SignatureMethodRSAImpl(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public String calculate(String header, String payload, PrivateKey signingKey) {
        byte[] token = SignatureMethodRSAImpl.toToken(header, payload);
        try {
            Signature signature = Signature.getInstance(this.getAlgorithmInternal());
            signature.initSign(signingKey.getPrivateKey());
            signature.update(token);
            token = signature.sign();
            return TokenDecoder.base64Encode((byte[])token);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean verify(String signature, String header, String payload, PublicKey verifyingKey) {
        byte[] token = SignatureMethodRSAImpl.toToken(header, payload);
        try {
            Signature sign = Signature.getInstance(this.getAlgorithmInternal());
            sign.initVerify(verifyingKey.getPublicKey());
            sign.update(token);
            return sign.verify(SignatureMethodRSAImpl.decode(signature));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    private static byte[] toToken(String header, String payload) {
        return (header + "." + payload).getBytes();
    }

    private String getAlgorithmInternal() {
        String alg = null;
        if ("RS256".equals(this.algorithm)) {
            alg = "SHA256withRSA";
        } else if ("RS384".equals(this.algorithm)) {
            alg = "SHA384withRSA";
        } else if ("RS512".equals(this.algorithm)) {
            alg = "SHA512withRSA";
        }
        return alg;
    }

    private static byte[] decode(String arg) throws Exception {
        String s = arg;
        s = s.replace('-', '+');
        s = s.replace('_', '/');
        switch (s.length() % 4) {
            case 0: {
                break;
            }
            case 2: {
                s = s + "==";
                break;
            }
            case 3: {
                s = s + "=";
                break;
            }
            default: {
                throw new Exception("Illegal base64url string!");
            }
        }
        return TokenDecoder.base64DecodeToByte((String)s);
    }
}

