/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.jose.jws.signature.impl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.oltu.commons.encodedtoken.TokenDecoder;
import org.apache.oltu.jose.jws.signature.SignatureMethod;
import org.apache.oltu.jose.jws.signature.impl.SymmetricKeyImpl;

public class SignatureMethodsHMAC256Impl
implements SignatureMethod<SymmetricKeyImpl, SymmetricKeyImpl> {
    @Override
    public String calculate(String header, String payload, SymmetricKeyImpl signingKey) {
        StringBuilder sb = new StringBuilder();
        sb.append(header).append(".").append(payload);
        String stringToSign = sb.toString();
        byte[] bytes = stringToSign.getBytes();
        try {
            Mac mac = Mac.getInstance("HMACSHA256");
            mac.init(new SecretKeySpec(signingKey.getKey(), mac.getAlgorithm()));
            mac.update(bytes);
            bytes = mac.doFinal();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        return TokenDecoder.base64Encode((byte[])bytes);
    }

    @Override
    public boolean verify(String signature, String header, String payload, SymmetricKeyImpl verifyingKey) {
        String signed = this.calculate(header, payload, verifyingKey);
        return signed.equals(signature);
    }

    @Override
    public String getAlgorithm() {
        return "HS256";
    }
}

