/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.as.request;

import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.as.request.OAuthRequest;
import org.apache.oltu.oauth2.as.validator.CodeValidator;
import org.apache.oltu.oauth2.as.validator.TokenValidator;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.ResponseType;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.common.validators.OAuthValidator;

public class OAuthAuthzRequest
extends OAuthRequest {
    public OAuthAuthzRequest(HttpServletRequest request) throws OAuthSystemException, OAuthProblemException {
        super(request);
    }

    @Override
    protected OAuthValidator<HttpServletRequest> initValidator() throws OAuthProblemException, OAuthSystemException {
        this.validators.put(ResponseType.CODE.toString(), CodeValidator.class);
        this.validators.put(ResponseType.TOKEN.toString(), TokenValidator.class);
        String requestTypeValue = this.getParam("response_type");
        if (OAuthUtils.isEmpty((String)requestTypeValue)) {
            throw OAuthUtils.handleOAuthProblemException((String)"Missing response_type parameter value");
        }
        Class clazz = (Class)this.validators.get(requestTypeValue);
        if (clazz == null) {
            throw OAuthUtils.handleOAuthProblemException((String)"Invalid response_type parameter value");
        }
        return (OAuthValidator)OAuthUtils.instantiateClass((Class)clazz);
    }

    public String getState() {
        return this.getParam("state");
    }

    public String getResponseType() {
        return this.getParam("response_type");
    }
}

