/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.as.request;

import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.as.request.OAuthRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.common.validators.OAuthValidator;

public abstract class AbstractOAuthTokenRequest
extends OAuthRequest {
    protected AbstractOAuthTokenRequest(HttpServletRequest request) throws OAuthSystemException, OAuthProblemException {
        super(request);
    }

    @Override
    protected OAuthValidator<HttpServletRequest> initValidator() throws OAuthProblemException, OAuthSystemException {
        String requestTypeValue = this.getParam("grant_type");
        if (OAuthUtils.isEmpty((String)requestTypeValue)) {
            throw OAuthUtils.handleOAuthProblemException((String)"Missing grant_type parameter value");
        }
        Class clazz = (Class)this.validators.get(requestTypeValue);
        if (clazz == null) {
            throw OAuthUtils.handleOAuthProblemException((String)"Invalid grant_type parameter value");
        }
        return (OAuthValidator)OAuthUtils.instantiateClass((Class)clazz);
    }

    public String getPassword() {
        return this.getParam("password");
    }

    public String getUsername() {
        return this.getParam("username");
    }

    public String getRefreshToken() {
        return this.getParam("refresh_token");
    }

    public String getCode() {
        return this.getParam("code");
    }

    public String getGrantType() {
        return this.getParam("grant_type");
    }
}

