/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.ext.dynamicreg.client.request;

import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.OAuthMessage;
import org.apache.oltu.oauth2.common.parameters.JSONBodyParametersApplier;

public class OAuthClientRegistrationRequest
extends OAuthClientRequest {
    protected OAuthClientRegistrationRequest(String url) {
        super(url);
    }

    public static OAuthRegistrationRequestBuilder location(String url, String type) {
        return new OAuthRegistrationRequestBuilder(url, type);
    }

    public static class OAuthRegistrationRequestBuilder
    extends OAuthClientRequest.OAuthRequestBuilder {
        public OAuthRegistrationRequestBuilder(String url, String type) {
            super(url);
            this.parameters.put("type", type);
        }

        public OAuthRegistrationRequestBuilder setName(String value) {
            this.parameters.put("client_name", value);
            return this;
        }

        public OAuthRegistrationRequestBuilder setUrl(String value) {
            this.parameters.put("client_url", value);
            return this;
        }

        public OAuthRegistrationRequestBuilder setDescription(String value) {
            this.parameters.put("client_description", value);
            return this;
        }

        public OAuthRegistrationRequestBuilder setIcon(String value) {
            this.parameters.put("client_icon", value);
            return this;
        }

        public OAuthRegistrationRequestBuilder setRedirectURL(String uri) {
            this.parameters.put("redirect_url", uri);
            return this;
        }

        public OAuthClientRequest buildJSONMessage() throws OAuthSystemException {
            OAuthClientRegistrationRequest request = new OAuthClientRegistrationRequest(this.url);
            this.applier = new JSONBodyParametersApplier();
            return (OAuthClientRequest)this.applier.applyOAuthParameters((OAuthMessage)request, this.parameters);
        }
    }
}

