/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.ext.dynamicreg.server.validator;

import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.apache.oltu.oauth2.common.validators.AbstractValidator;
import org.apache.oltu.oauth2.ext.dynamicreg.server.request.JSONHttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushPullValidator
extends AbstractValidator<JSONHttpServletRequestWrapper> {
    private Logger log = LoggerFactory.getLogger(PushPullValidator.class);

    @Override
    public void validateContentType(JSONHttpServletRequestWrapper request) throws OAuthProblemException {
        String contentType = request.getContentType();
        String expectedContentType = "application/json";
        if (!OAuthUtils.hasContentType(contentType, "application/json")) {
            throw OAuthUtils.handleBadContentTypeException("application/json");
        }
        this.initializeValidationParameter(request);
    }

    private void initializeValidationParameter(JSONHttpServletRequestWrapper request) throws OAuthProblemException {
        String requestType = request.getParameter("type");
        if (OAuthUtils.isEmpty(requestType)) {
            throw OAuthUtils.handleOAuthProblemException("Missing [type] parameter value");
        }
        if ("pull".equals(requestType)) {
            this.requiredParams.add("type");
            this.requiredParams.add("client_url");
        } else if ("push".equals(requestType)) {
            this.requiredParams.add("type");
            this.requiredParams.add("client_name");
            this.requiredParams.add("client_url");
            this.requiredParams.add("client_description");
            this.requiredParams.add("redirect_url");
        } else {
            throw OAuthUtils.handleOAuthProblemException("Invalid [type] parameter value");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("OAuth dynamic client registration type is: {}", (Object[])new String[]{requestType});
        }
    }
}

