/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.jwt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.oltu.commons.json.CustomizableEntity;

public final class ClaimsSet
extends CustomizableEntity {
    private final String issuer;
    private final String subject;
    private final List<String> audiences;
    private final long expirationTime;
    private final String notBefore;
    private final long issuedAt;
    private final String jwdId;
    private final String type;

    ClaimsSet(String issuer, String subject, List<String> audiences, long expirationTime, String notBefore, long issuedAt, String jwdId, String type, Map<String, Object> customFields) {
        super(customFields);
        this.issuer = issuer;
        this.subject = subject;
        this.audiences = audiences == null ? null : new ArrayList<String>(audiences);
        this.expirationTime = expirationTime;
        this.notBefore = notBefore;
        this.issuedAt = issuedAt;
        this.jwdId = jwdId;
        this.type = type;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getAudience() {
        return this.getAudiences().isEmpty() ? null : this.audiences.get(0);
    }

    public List<String> getAudiences() {
        return this.audiences == null ? new ArrayList() : Collections.unmodifiableList(this.audiences);
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public String getNotBefore() {
        return this.notBefore;
    }

    public long getIssuedAt() {
        return this.issuedAt;
    }

    public String getJwdId() {
        return this.jwdId;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        return String.format("{\"iss\": \"%s\", \"sub\": \"%s\", \"aud\": %s, \"exp\": %s, \"nbf\": \"%s\", \"iat\": %s, \"jti\": \"%s\", \"typ\": \"%s\" }", this.issuer, this.subject, this.formatAudiences(), this.expirationTime, this.notBefore, this.issuedAt, this.jwdId, this.type, super.toString());
    }

    private String formatAudiences() {
        if (this.audiences == null || this.audiences.size() < 1) {
            return "\"" + this.getAudience() + "\"";
        }
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (String aud : this.audiences) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("\"").append(aud).append("\"");
            first = false;
        }
        return sb.append("]").toString();
    }
}

