/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.validation.ValidationException;
import org.apache.geronimo.osgi.locator.ProviderLocator;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.client.RemoteInitialContextFactory;
import org.apache.openejb.config.RemoteServer;
import org.apache.openejb.loader.IO;
import org.apache.tomee.util.QuickServerXmlParser;

public class RemoteTomEEEJBContainer
extends EJBContainer {
    private static RemoteTomEEEJBContainer instance;
    private RemoteServer container;
    private InitialContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    public void close() {
        RemoteTomEEEJBContainer.instance.container.destroy();
        RemoteTomEEEJBContainer.instance.container = null;
    }

    public Context getContext() {
        return this.context;
    }

    private static void deployFile(Deployer deployer, File file) throws IOException, OpenEJBException {
        if ("true".equalsIgnoreCase(System.getProperty("openejb.deployer.binaries.use", "false"))) {
            Properties props = new Properties();
            byte[] slurpBinaries = IO.slurp((File)file).getBytes();
            props.put("openejb.deployer.binaries.value", slurpBinaries);
            props.put("openejb.deployer.binaries.path", file.getName());
            deployer.deploy(file.getAbsolutePath(), props);
        } else {
            deployer.deploy(file.getAbsolutePath());
        }
    }

    protected static class TomEERemoteEJBContainerException
    extends RuntimeException {
        protected TomEERemoteEJBContainerException(String s, Exception e) {
            super(s, e);
        }
    }

    public static class Provider
    implements EJBContainerProvider {
        private static final List<String> CONTAINER_NAMES = Arrays.asList(RemoteTomEEEJBContainer.class.getName(), "tomee-remote", "remote-tomee");

        public EJBContainer createEJBContainer(Map<?, ?> properties) {
            Object provider = properties.get("javax.ejb.embeddable.provider");
            int ejbContainerProviders = 1;
            try {
                ejbContainerProviders = ProviderLocator.getServices((String)EJBContainerProvider.class.getName(), EJBContainer.class, (ClassLoader)Thread.currentThread().getContextClassLoader()).size();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (provider == null && ejbContainerProviders > 1 || !RemoteTomEEEJBContainer.class.equals(provider) && !CONTAINER_NAMES.contains(String.valueOf(provider))) {
                return null;
            }
            if (instance != null) {
                return instance;
            }
            Object modules = properties.get("javax.ejb.embeddable.modules");
            System.getProperties().putAll(properties);
            File home = new File(System.getProperty("openejb.home", "doesn't exist"));
            if (!home.exists()) {
                throw new IllegalArgumentException("You need to set openejb.home");
            }
            QuickServerXmlParser parser = QuickServerXmlParser.parse((File)new File(home, "conf/server.xml"));
            final String remoteEjb = System.getProperty("java.naming.provider.url", "http://" + parser.host() + ":" + parser.http() + "/tomee/ejb");
            try {
                instance = new RemoteTomEEEJBContainer();
                instance.container = new RemoteServer();
                instance.container.setPortStartup(Integer.parseInt(parser.http()));
                try {
                    instance.container.start();
                }
                catch (Exception e) {
                    instance.container.destroy();
                    throw e;
                }
                instance.context = new InitialContext(new Properties(){
                    {
                        this.setProperty("java.naming.factory.initial", RemoteInitialContextFactory.class.getName());
                        this.setProperty("java.naming.provider.url", remoteEjb);
                    }
                });
                Deployer deployer = (Deployer)Deployer.class.cast(instance.context.lookup("openejb/DeployerBusinessRemote"));
                if (modules instanceof File) {
                    File file = (File)File.class.cast(modules);
                    RemoteTomEEEJBContainer.deployFile(deployer, file);
                } else if (modules instanceof String) {
                    String path = (String)String.class.cast(modules);
                    File file = new File(path);
                    RemoteTomEEEJBContainer.deployFile(deployer, file);
                } else if (modules instanceof String[]) {
                    for (String path : (String[])modules) {
                        RemoteTomEEEJBContainer.deployFile(deployer, new File(path));
                    }
                } else if (modules instanceof File[]) {
                    for (File file : (File[])modules) {
                        RemoteTomEEEJBContainer.deployFile(deployer, file);
                    }
                }
                return instance;
            }
            catch (OpenEJBException e) {
                throw new EJBException((Exception)((Object)e));
            }
            catch (MalformedURLException e) {
                throw new EJBException((Exception)e);
            }
            catch (ValidationException ve) {
                throw ve;
            }
            catch (Exception e) {
                if (e instanceof EJBException) {
                    throw (EJBException)e;
                }
                throw new TomEERemoteEJBContainerException("initialization exception", e);
            }
        }
    }
}

