/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.util.DaemonThreadFactory;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.shrinkwrap.api.Archive;

public final class ArquillianUtil {
    private static final String OPENEJB_ADAPTER_SYSTEM_PROP = "openejb.arquillian.adapter";
    private static final String TOMEE_ADAPTER_SYSTEM_PROP = "tomee.arquillian.adapter";
    public static final String PREDEPLOYING_KEY = "openejb.arquillian.predeploy-archives";

    private ArquillianUtil() {
    }

    public static boolean isCurrentAdapter(String name) {
        String adapter = System.getProperty(OPENEJB_ADAPTER_SYSTEM_PROP);
        if (adapter == null) {
            adapter = System.getProperty(TOMEE_ADAPTER_SYSTEM_PROP);
        }
        return adapter == null || name.equals(adapter);
    }

    public static Collection<Archive<?>> toDeploy(Properties properties) {
        ArrayList list = new ArrayList();
        if (properties.containsKey(PREDEPLOYING_KEY)) {
            String toSplit = properties.getProperty(PREDEPLOYING_KEY).trim();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (String name : toSplit.split(",")) {
                int end;
                int bracket = name.indexOf(".[");
                if (bracket >= 0 && (end = name.indexOf("]")) > bracket) {
                    String pkg = name.substring(0, bracket + 1);
                    String classes = name.substring(bracket + 2, end);
                    for (String n : classes.split("\\|")) {
                        ArquillianUtil.addClass(list, loader, pkg + n);
                    }
                    continue;
                }
                ArquillianUtil.addClass(list, loader, name);
            }
        }
        return list;
    }

    private static void addClass(Collection<Archive<?>> list, ClassLoader loader, String classname) {
        String name = classname.trim();
        try {
            Class<?> clazz = loader.loadClass(name);
            block2: for (Method m : clazz.getMethods()) {
                int modifiers = m.getModifiers();
                if (Object.class.equals(m.getDeclaringClass()) || !Archive.class.isAssignableFrom(m.getReturnType()) || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
                for (Annotation a : m.getAnnotations()) {
                    if (!"org.jboss.arquillian.container.test.api.Deployment".equals(a.annotationType().getName())) continue;
                    Archive archive = (Archive)m.invoke(null, new Object[0]);
                    list.add(archive);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException(e);
        }
    }

    public static void undeploy(DeployableContainer<?> container, Collection<Archive<?>> containerArchives) {
        if (containerArchives != null) {
            for (Archive<?> a : containerArchives) {
                try {
                    container.undeploy(a);
                }
                catch (DeploymentException e) {
                    Logger.getLogger(container.getClass().getName()).log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public static void preLoadClassesAsynchronously(String classesToLoad) {
        if (classesToLoad == null || classesToLoad.isEmpty()) {
            return;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Object[] split = classesToLoad.trim().split(",");
        ExecutorService es = Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory(split));
        for (Object clazz : split) {
            es.submit(new PreLoadClassTask(loader, (String)clazz));
        }
        es.shutdown();
    }

    private static class PreLoadClassTask
    implements Runnable {
        private final String clazz;
        private final ClassLoader loader;

        public PreLoadClassTask(ClassLoader loader, String name) {
            this.loader = loader;
            this.clazz = name;
        }

        @Override
        public void run() {
            try {
                Class.forName(this.clazz, true, this.loader);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

