/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.openejb;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.openejb.AppContext;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.arquillian.openejb.OpenEJBArchiveProcessor;
import org.apache.openejb.arquillian.openejb.OpenEJBConfiguration;
import org.apache.openejb.arquillian.openejb.SWClassLoader;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.cdi.ScopeHelper;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.core.LocalInitialContext;
import org.apache.openejb.core.LocalInitialContextFactory;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.web.lifecycle.test.MockHttpSession;
import org.apache.webbeans.web.lifecycle.test.MockServletContext;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.transaction.impl.configuration.TransactionConfiguration;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class OpenEJBDeployableContainer
implements DeployableContainer<OpenEJBConfiguration> {
    private static final Properties PROPERTIES = new Properties();
    private Properties properties;
    private Assembler assembler;
    private InitialContext initialContext;
    private ConfigurationFactory configurationFactory;
    @Inject
    @DeploymentScoped
    private InstanceProducer<AppInfo> appInfoProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<AppContext> appContextProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<ServletContext> servletContextProducer;
    @Inject
    @DeploymentScoped
    private InstanceProducer<HttpSession> sessionProducer;
    @Inject
    @SuiteScoped
    private InstanceProducer<ClassLoader> classLoader;
    @Inject
    private Instance<ServletContext> servletContext;
    @Inject
    private Instance<HttpSession> session;
    @Inject
    private Instance<AppInfo> info;
    @Inject
    private Instance<AppContext> appContext;
    @Inject
    private Instance<TestClass> testClass;
    @Inject
    @ApplicationScoped
    private InstanceProducer<TransactionConfiguration> txConfig;

    public Class<OpenEJBConfiguration> getConfigurationClass() {
        return OpenEJBConfiguration.class;
    }

    public void setup(OpenEJBConfiguration openEJBConfiguration) {
        this.properties = new Properties();
        ByteArrayInputStream bais = new ByteArrayInputStream(openEJBConfiguration.getProperties().getBytes());
        try {
            this.properties.load(bais);
        }
        catch (IOException e) {
            throw new OpenEJBRuntimeException((Exception)e);
        }
        finally {
            IO.close((Closeable)bais);
        }
        for (Map.Entry<Object, Object> defaultKey : PROPERTIES.entrySet()) {
            String key = defaultKey.getKey().toString();
            if (this.properties.containsKey(key)) continue;
            this.properties.setProperty(key, defaultKey.getValue().toString());
        }
    }

    public void start() throws LifecycleException {
        try {
            this.initialContext = new InitialContext(this.properties);
        }
        catch (NamingException e) {
            throw new LifecycleException("can't start the OpenEJB container", (Throwable)e);
        }
        this.assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        this.configurationFactory = new ConfigurationFactory();
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            AppModule module = OpenEJBArchiveProcessor.createModule(archive, (TestClass)this.testClass.get());
            AppInfo appInfo = this.configurationFactory.configureApplication(module);
            AppContext appCtx = this.assembler.createApplication(appInfo, module.getClassLoader());
            MockServletContext appServletContext = new MockServletContext();
            MockHttpSession appSession = new MockHttpSession();
            ScopeHelper.startContexts((ContextsService)appCtx.getWebBeansContext().getContextsService(), (ServletContext)appServletContext, (HttpSession)appSession);
            this.servletContextProducer.set((Object)appServletContext);
            this.sessionProducer.set((Object)appSession);
            this.appInfoProducer.set((Object)appInfo);
            this.appContextProducer.set((Object)appCtx);
            this.classLoader.set((Object)appCtx.getClassLoader());
        }
        catch (Exception e) {
            throw new DeploymentException("can't deploy " + archive.getName(), (Throwable)e);
        }
        return new ProtocolMetaData();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        this.classLoader.set((Object)OpenEJBDeployableContainer.class.getClassLoader());
        if (this.appContext.get() == null) {
            return;
        }
        ClassLoader cl = ((AppContext)this.appContext.get()).getClassLoader();
        if (cl instanceof SWClassLoader) {
            ((SWClassLoader)cl).close();
        }
        try {
            this.assembler.destroyApplication(((AppInfo)this.info.get()).path);
            ScopeHelper.stopContexts((ContextsService)((AppContext)this.appContext.get()).getWebBeansContext().getContextsService(), (ServletContext)((ServletContext)this.servletContext.get()), (HttpSession)((HttpSession)this.session.get()));
        }
        catch (Exception e) {
            throw new DeploymentException("can't undeploy " + archive.getName(), (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        try {
            if (this.initialContext != null) {
                this.initialContext.close();
            }
        }
        catch (NamingException e) {
            throw new LifecycleException("can't close the OpenEJB container", (Throwable)e);
        }
        finally {
            OpenEJB.destroy();
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Local");
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    static {
        PROPERTIES.setProperty("java.naming.factory.initial", LocalInitialContextFactory.class.getName());
        PROPERTIES.setProperty("openejb.embedded.initialcontext.close", LocalInitialContext.Close.DESTROY.name());
        PROPERTIES.setProperty("openejb.deployments.classpath", "false");
        try {
            OpenEJBDeployableContainer.class.getClassLoader().loadClass("org.apache.openejb.server.ServiceManager");
            PROPERTIES.setProperty("openejb.embedded.remotable", "true");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

