/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.openejb;

import java.util.Enumeration;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.openejb.arquillian.common.ArquillianUtil;
import org.apache.openejb.arquillian.common.deployment.DeploymentExceptionObserver;
import org.apache.openejb.arquillian.common.deployment.DeploymentExceptionProvider;
import org.apache.openejb.arquillian.openejb.OpenEJBDeployableContainer;
import org.apache.openejb.arquillian.openejb.OpenEJBInjectionEnricher;
import org.apache.openejb.arquillian.openejb.TestObserver;
import org.apache.openejb.arquillian.transaction.OpenEJBTransactionProvider;
import org.apache.openejb.util.JuliLogStreamFactory;
import org.apache.openejb.util.LogCategory;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.core.spi.LoadableExtension;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import org.jboss.arquillian.transaction.spi.provider.TransactionProvider;

public class OpenEJBExtension
implements LoadableExtension {
    private static final String OPENEJB_ADAPTER_NAME = "openejb";

    private static void initLogger(String name) {
        Logger logger = Logger.getLogger(name);
        Handler[] handlers = logger.getHandlers();
        if (handlers != null) {
            for (int i = 0; i < handlers.length; ++i) {
                logger.removeHandler(handlers[i]);
            }
        }
        logger.setUseParentHandlers(false);
        logger.addHandler((Handler)new JuliLogStreamFactory.OpenEJBSimpleLayoutHandler());
    }

    public void register(LoadableExtension.ExtensionBuilder extensionBuilder) {
        if (ArquillianUtil.isCurrentAdapter((String)OPENEJB_ADAPTER_NAME)) {
            extensionBuilder.service(DeployableContainer.class, OpenEJBDeployableContainer.class).service(TestEnricher.class, OpenEJBInjectionEnricher.class).service(ResourceProvider.class, DeploymentExceptionProvider.class).service(TransactionProvider.class, OpenEJBTransactionProvider.class).observer(TestObserver.class).observer(DeploymentExceptionObserver.class);
        }
    }

    static {
        if (ArquillianUtil.isCurrentAdapter((String)OPENEJB_ADAPTER_NAME) && (System.getProperty("java.util.logging.config.class") == null || System.getProperty("java.util.logging.config.file") == null)) {
            Enumeration<String> list = LogManager.getLogManager().getLoggerNames();
            while (list.hasMoreElements()) {
                OpenEJBExtension.initLogger(list.nextElement());
            }
            OpenEJBExtension.initLogger(LogCategory.OPENEJB.getName());
        }
    }
}

