/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.openejb;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.openejb.util.Enumerator;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;

public class SWClassLoader
extends ClassLoader {
    private final Archive<?> archive;
    private final String prefix;
    private final Collection<Closeable> closeables = new ArrayList<Closeable>();

    public SWClassLoader(String prefix, ClassLoader parent, Archive<?> ar) {
        super(parent);
        this.prefix = prefix;
        this.archive = ar;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArchivePath path = ArchivePaths.create((String)(this.prefix + name));
        Node node = this.archive.get(path);
        if (node != null) {
            return new Enumerator(Arrays.asList(new URL(null, "archive:" + this.archive.getName() + "/", new ArchiveStreamHandler(node, this.closeables))));
        }
        return super.findResources(name);
    }

    @Override
    protected URL findResource(String name) {
        ArchivePath path = ArchivePaths.create((String)(this.prefix + name));
        Node node = this.archive.get(path);
        if (node != null) {
            try {
                return new URL(null, "archive:" + this.archive.getName() + "/", new ArchiveStreamHandler(node, this.closeables));
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return super.findResource(name);
    }

    public void close() {
        for (Closeable cl : this.closeables) {
            try {
                cl.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static class ArchiveStreamHandler
    extends URLStreamHandler {
        private final Node node;
        private final Collection<Closeable> closeables;

        private ArchiveStreamHandler(Node node, Collection<Closeable> closeables) {
            this.node = node;
            this.closeables = closeables;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new URLConnection(u){

                @Override
                public void connect() throws IOException {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public InputStream getInputStream() throws IOException {
                    Asset asset = ArchiveStreamHandler.this.node.getAsset();
                    InputStream input = asset.openStream();
                    Collection collection = ArchiveStreamHandler.this.closeables;
                    synchronized (collection) {
                        ArchiveStreamHandler.this.closeables.add(input);
                    }
                    return input;
                }
            };
        }
    }
}

