/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.openejb;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.openejb.util.Enumerator;
import org.apache.openejb.util.reflection.Reflections;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;

public class SWClassLoader
extends ClassLoader {
    private final Archive<?> archive;
    private final String prefix;
    private final Collection<Closeable> closeables = new ArrayList<Closeable>();

    public SWClassLoader(String prefix, ClassLoader parent, Archive<?> ar) {
        super(parent);
        this.prefix = prefix;
        this.archive = ar;
        ArchiveStreamHandler.set(ar, prefix, this.closeables);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArchivePath path = ArchivePaths.create((String)(this.prefix + name));
        Node node = this.archive.get(path);
        if (node == null) {
            path = ArchivePaths.create((String)name);
            node = this.archive.get(path);
        }
        if (node != null) {
            return SWClassLoader.enumerator(new URL(null, "archive:" + this.archive.getName() + "/" + name, new ArchiveStreamHandler()));
        }
        return super.findResources(name);
    }

    private static Enumeration<URL> enumerator(URL url) {
        return new Enumerator(Arrays.asList(url));
    }

    @Override
    protected URL findResource(String name) {
        ArchivePath path = ArchivePaths.create((String)(this.prefix + name));
        Node node = this.archive.get(path);
        if (node == null) {
            path = ArchivePaths.create((String)name);
            node = this.archive.get(path);
        }
        if (node != null) {
            try {
                return new URL(null, "archive:" + this.archive.getName() + "/" + name, new ArchiveStreamHandler());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return super.findResource(name);
    }

    public void close() {
        ArchiveStreamHandler.reset(this.archive.getName());
        for (Closeable cl : this.closeables) {
            try {
                cl.close();
            }
            catch (IOException iOException) {}
        }
    }

    public Archive<?> getArchive() {
        return this.archive;
    }

    static {
        try {
            Field handler = URL.class.getDeclaredField("handlers");
            handler.setAccessible(true);
            ((Hashtable)handler.get(null)).put("archive", new ArchiveStreamHandler());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ArchiveStreamHandler
    extends URLStreamHandler {
        public static final Map<String, Archive<?>> archives = new HashMap();
        public static final Map<String, String> prefixes = new HashMap<String, String>();
        public static final Map<String, Collection<Closeable>> closeables = new HashMap<String, Collection<Closeable>>();

        private ArchiveStreamHandler() {
        }

        public static void set(Archive<?> ar, String p, Collection<Closeable> c) {
            String archiveName = ar.getName();
            archives.put(archiveName, ar);
            prefixes.put(archiveName, p);
            closeables.put(archiveName, c);
        }

        public static void reset(String archiveName) {
            archives.remove(archiveName);
            prefixes.remove(archiveName);
            closeables.remove(archiveName);
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            final String arName = ArchiveStreamHandler.key(u);
            if (!prefixes.containsKey(arName)) {
                throw new IOException(u.toExternalForm() + " not found");
            }
            String path = prefixes.get(arName) + ArchiveStreamHandler.path(arName, u);
            Node node = archives.get(arName).get(path);
            if (node == null) {
                path = ArchiveStreamHandler.path(arName, u);
                node = archives.get(arName).get(path);
            }
            if (node == null) {
                throw new IOException(u.toExternalForm() + " not found");
            }
            final Asset asset = node.getAsset();
            if (UrlAsset.class.isInstance(asset)) {
                return ((URL)URL.class.cast(Reflections.get((Object)asset, (String)"url"))).openConnection();
            }
            if (FileAsset.class.isInstance(asset)) {
                return ((File)File.class.cast(Reflections.get((Object)asset, (String)"file"))).toURI().toURL().openConnection();
            }
            if (ClassLoaderAsset.class.isInstance(asset)) {
                return ((ClassLoader)ClassLoader.class.cast(Reflections.get((Object)asset, (String)"classLoader"))).getResource((String)String.class.cast(Reflections.get((Object)asset, (String)"resourceName"))).openConnection();
            }
            return new URLConnection(u){

                @Override
                public void connect() throws IOException {
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    InputStream input = asset.openStream();
                    Collection<Closeable> c = closeables.get(arName);
                    c.add(input);
                    return input;
                }
            };
        }

        private static String path(String arName, URL url) {
            String p = url.getPath();
            String out = p.substring(arName.length(), p.length());
            if (prefixes.get(arName).endsWith("/") && out.startsWith("/")) {
                return out.substring(1);
            }
            return out;
        }

        private static String key(URL url) {
            String p = url.getPath();
            if (p == null) {
                return null;
            }
            int endIndex = p.indexOf(47);
            if (endIndex >= 0) {
                return p.substring(0, endIndex);
            }
            return p;
        }
    }
}

