/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Files {
    static final List<String> delete = new ArrayList<String>();

    public static File path(String ... parts) {
        File dir = null;
        for (String part : parts) {
            dir = dir == null ? new File(part) : new File(dir, part);
        }
        return dir;
    }

    public static File path(File dir, String ... parts) {
        for (String part : parts) {
            dir = new File(dir, part);
        }
        return dir;
    }

    public static File createTempDir() throws IOException {
        return Files.createTempDir("tomee", ".conf");
    }

    public static File createTempDir(String prefix, String suffix) throws IOException {
        File tempDir = File.createTempFile(prefix, suffix);
        tempDir.delete();
        tempDir.mkdirs();
        Files.deleteOnExit(tempDir);
        return tempDir;
    }

    private Files() {
    }

    public static void deleteOnExit(File file) {
        delete.add(file.getAbsolutePath());
    }

    private static void delete() {
        for (String path : delete) {
            Files.delete(new File(path));
        }
    }

    public static void delete(File file) {
        if (file.exists()) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                for (File f : files) {
                    Files.delete(f);
                }
            }
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    public static void mkdir(File dir) {
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new IllegalStateException("cannot make directory: " + dir.getAbsolutePath());
        }
    }

    public static void writable(File file) {
        if (!file.canWrite()) {
            throw new IllegalStateException("Not writable: " + file.getAbsolutePath());
        }
    }

    public static void readable(File file) {
        if (!file.canRead()) {
            throw new IllegalStateException("Not readable: " + file.getAbsolutePath());
        }
    }

    public static void assertDir(File file) {
        if (!file.isDirectory()) {
            throw new IllegalStateException("Not a directory: " + file.getAbsolutePath());
        }
    }

    public static void assertFile(File file) {
        if (!file.isFile()) {
            throw new IllegalStateException("Not a file: " + file.getAbsolutePath());
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Files.delete();
            }
        });
    }
}

