/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.logging.Logger;
import org.apache.openejb.arquillian.common.DownloadException;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.resolver.Resolver;

public class MavenCache {
    private static final Logger LOGGER = Logger.getLogger(MavenCache.class.getName());

    public static File getArtifact(String artifactInfo, String altUrl) {
        LOGGER.info("Downloading " + artifactInfo + " please wait...");
        try {
            return new File(new Resolver().resolve(artifactInfo.startsWith("mvn") ? "" : "mvn:" + artifactInfo));
        }
        catch (Exception e) {
            try {
                if (altUrl != null) {
                    return MavenCache.download(altUrl);
                }
            }
            catch (Exception e1) {
                throw new IllegalStateException(e1);
            }
            return null;
        }
    }

    public static File download(String source) throws DownloadException {
        File file = null;
        InputStream is = null;
        OutputStream os = null;
        try {
            int bytesRead;
            is = ProvisioningUtil.inputStreamTryingProxies((URI)new URI(source));
            file = File.createTempFile("dload", ".fil");
            file.deleteOnExit();
            os = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) > -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            throw new DownloadException("Unable to download " + source + " to " + file.getAbsolutePath(), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {}
            }
        }
        return file;
    }
}

