/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.openejb.config.AdditionalBeanDiscoverer;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ManagedBean;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.IO;

public class TestClassDiscoverer
implements AdditionalBeanDiscoverer {
    public AppModule discover(AppModule module) {
        String name = this.findTestName(module.getFile(), module.getClassLoader());
        if (name == null) {
            return module;
        }
        try {
            Class<?> clazz;
            for (Class<?> current = clazz = module.getClassLoader().loadClass(name); current != null; current = current.getSuperclass()) {
                current.getDeclaredFields();
                current.getDeclaredMethods();
                current.getCanonicalName();
            }
        }
        catch (ClassNotFoundException e) {
            return module;
        }
        catch (NoClassDefFoundError ncdfe) {
            return module;
        }
        EjbJar ejbJar = new EjbJar();
        OpenejbJar openejbJar = new OpenejbJar();
        ManagedBean bean = (ManagedBean)ejbJar.addEnterpriseBean((EnterpriseBean)new ManagedBean(name, name, true));
        bean.setTransactionType(TransactionType.BEAN);
        EjbDeployment ejbDeployment = openejbJar.addEjbDeployment((EnterpriseBean)bean);
        ejbDeployment.setDeploymentId(name);
        module.getEjbModules().add(new EjbModule(ejbJar, openejbJar));
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findTestName(File folder, ClassLoader classLoader) {
        Object info;
        File unpacked;
        InputStream is = null;
        File dir = folder;
        if (dir != null && (dir.getName().endsWith(".war") || dir.getName().endsWith(".ear")) && (unpacked = new File(dir.getParentFile(), dir.getName().substring(0, dir.getName().length() - 4))).exists()) {
            dir = unpacked;
        }
        if (dir != null && dir.isDirectory() && ((File)(info = new File(dir, "arquillian-tomee-info.txt"))).exists()) {
            try {
                is = new FileInputStream((File)info);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (is == null) {
            is = classLoader.getResourceAsStream("/arquillian-tomee-info.txt");
        }
        if (is != null) {
            try {
                info = IO.slurp((InputStream)is);
                return info;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                IO.close((Closeable)is);
            }
        }
        return null;
    }
}

