/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.arquillian.common.Files;
import org.apache.openejb.arquillian.common.ObjectMap;
import org.apache.openejb.arquillian.common.Prefixes;
import org.apache.openejb.arquillian.common.Threads;
import org.apache.openejb.arquillian.common.TomEEConfiguration;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Info;
import org.apache.openejb.assembler.classic.ServletInfo;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.loader.Options;
import org.apache.openejb.util.NetworkUtil;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public abstract class TomEEContainer<Configuration extends TomEEConfiguration>
implements DeployableContainer<Configuration> {
    protected static final Logger LOGGER = Logger.getLogger(TomEEContainer.class.getName());
    protected Configuration configuration;
    protected Map<String, DeployedApp> moduleIds = new HashMap<String, DeployedApp>();
    private final Options options = new Options(System.getProperties());
    @Inject
    private Instance<TestClass> testClass;

    protected TomEEContainer() {
    }

    public void setup(Configuration configuration) {
        String value;
        String property;
        this.configuration = configuration;
        Prefixes prefixes = configuration.getClass().getAnnotation(Prefixes.class);
        if (prefixes == null) {
            return;
        }
        ObjectMap map = new ObjectMap(configuration);
        for (String string : map.keySet()) {
            for (String prefix : prefixes.value()) {
                property = prefix + "." + string;
                value = System.getProperty(property);
                if (value == null) {
                    LOGGER.log(Level.FINE, String.format("Unset '%s'", property));
                    continue;
                }
                try {
                    LOGGER.log(Level.INFO, String.format("Applying override '%s=%s'", property, value));
                    map.put(string, (Object)value);
                }
                catch (Exception e) {
                    try {
                        map.put(string, (Object)Integer.parseInt(value));
                    }
                    catch (Exception ignored) {
                        try {
                            map.put(string, (Object)Boolean.parseBoolean(value));
                        }
                        catch (Exception ignored2) {
                            LOGGER.log(Level.WARNING, String.format("Override failed '%s=%s'", property, value), e);
                        }
                    }
                }
            }
        }
        this.setPorts();
        if (((TomEEConfiguration)configuration).getExportConfAsSystemProperty()) {
            for (Map.Entry entry : map.entrySet()) {
                for (String prefix : prefixes.value()) {
                    try {
                        property = prefix + "." + (String)entry.getKey();
                        value = entry.getValue().toString();
                        LOGGER.log(Level.FINER, String.format("Exporting '%s=%s'", property, value));
                        System.setProperty(property, value);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected void setPorts() {
        ArrayList<Integer> randomPorts = new ArrayList<Integer>();
        for (int i : ((TomEEConfiguration)this.configuration).portsAlreadySet()) {
            randomPorts.add(i);
        }
        ObjectMap map = new ObjectMap(this.configuration);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!entry.getKey().toLowerCase().endsWith("port")) continue;
            try {
                Object value = entry.getValue();
                int port = new Integer(value + "");
                if (port > 0) continue;
                int retry = 0;
                while (retry++ != Integer.MAX_VALUE && randomPorts.contains(port = this.nextPort(((TomEEConfiguration)this.configuration).getPortRange(), randomPorts))) {
                }
                entry.setValue(port);
                randomPorts.add(port);
            }
            catch (NumberFormatException mustNotBeAPortConfig) {}
        }
        randomPorts.clear();
    }

    private int nextPort(String portRange, Collection<Integer> excluded) {
        if (portRange == null || portRange.isEmpty()) {
            for (int retry = 10; retry > 0; --retry) {
                int port = NetworkUtil.getNextAvailablePort();
                if (excluded.contains(port)) continue;
                return port;
            }
            throw new IllegalArgumentException("can't find a port available excluding " + excluded);
        }
        if (!portRange.contains("-")) {
            int port = Integer.parseInt(portRange.trim());
            return NetworkUtil.getNextAvailablePort((int[])new int[]{port});
        }
        String[] minMax = portRange.trim().split("-");
        int min = Integer.parseInt(minMax[0]);
        int max = Integer.parseInt(minMax[1]);
        return NetworkUtil.getNextAvailablePort((int)min, (int)max, excluded);
    }

    public abstract void start() throws LifecycleException;

    public void stop() throws LifecycleException {
        try {
            Socket socket = new Socket(((TomEEConfiguration)this.configuration).getStopHost(), ((TomEEConfiguration)this.configuration).getStopPort());
            OutputStream out = socket.getOutputStream();
            out.write((((TomEEConfiguration)this.configuration).getStopCommand() + Character.toString('\u0000')).getBytes());
            this.waitForShutdown(socket, 10);
        }
        catch (Exception e) {
            throw new LifecycleException("Unable to stop TomEE", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForShutdown(Socket socket, int tries) {
        try {
            OutputStream out = socket.getOutputStream();
            out.close();
        }
        catch (Exception e) {
            if (tries > 2) {
                Threads.sleep(2000L);
                this.waitForShutdown(socket, --tries);
            }
        }
        finally {
            if (socket != null && !socket.isClosed()) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 2.5");
    }

    public void addServlets(HTTPContext httpContext, AppInfo appInfo) {
        for (WebAppInfo webApps : appInfo.webApps) {
            for (ServletInfo servlet : webApps.servlets) {
                String clazz = servlet.servletClass;
                if (clazz == null && (clazz = servlet.servletName) == null) continue;
                httpContext.add(new Servlet(clazz, webApps.contextRoot));
            }
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            AppInfo appInfo;
            File extracted;
            File file = this.dumpFile(archive);
            String fileName = file.getName();
            if (fileName.endsWith(".war") && (extracted = new File(file.getParentFile(), fileName.substring(0, fileName.length() - 4))).exists()) {
                extracted.deleteOnExit();
            }
            try {
                appInfo = this.deployer().deploy(file.getAbsolutePath());
                if (appInfo == null) {
                    LOGGER.severe("appInfo was not found for " + file.getPath() + ", available are: " + this.apps());
                    throw new OpenEJBException("can't get appInfo");
                }
                this.moduleIds.put(archive.getName(), new DeployedApp(appInfo.path, file.getParentFile()));
            }
            catch (OpenEJBException re) {
                this.moduleIds.put(archive.getName(), new DeployedApp(file.getPath(), file.getParentFile()));
                throw re;
            }
            if (this.options.get("tomee.appinfo.output", false)) {
                Info.marshal((AppInfo)appInfo);
            }
            HTTPContext httpContext = new HTTPContext(((TomEEConfiguration)this.configuration).getHost(), ((TomEEConfiguration)this.configuration).getHttpPort());
            Archive<?> object = archive;
            String arquillianServlet = object instanceof WebArchive ? "/" + this.getArchiveNameWithoutExtension(archive) : "/arquillian-protocol";
            httpContext.add(new Servlet("ArquillianServletRunner", arquillianServlet));
            this.addServlets(httpContext, appInfo);
            return new ProtocolMetaData().addContext((Object)httpContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentException("Unable to deploy", (Throwable)e);
        }
    }

    protected File dumpFile(Archive<?> archive) {
        File file;
        String tmpDir = ((TomEEConfiguration)this.configuration).getAppWorkingDir();
        Files.deleteOnExit(new File(tmpDir));
        int i = 0;
        do {
            File folderFile;
            if ((file = new File(tmpDir + File.separator + i++ + File.separator + archive.getName())).isDirectory() || !file.getName().endsWith("ar")) {
                folderFile = file;
                continue;
            }
            String name = file.getName();
            folderFile = new File(file.getParentFile(), name.substring(0, name.length() - 4));
        } while (file.getParentFile().exists());
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            LOGGER.warning("can't create " + file.getParent());
        }
        Files.deleteOnExit(file.getParentFile());
        ((ZipExporter)this.archiveWithTestInfo(archive).as(ZipExporter.class)).exportTo(file, true);
        return file;
    }

    private Collection<String> apps() {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            Collection appInfos = this.deployer().getDeployedApps();
            for (AppInfo info : appInfos) {
                paths.add(info.path);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return paths;
    }

    protected Assignable archiveWithTestInfo(Archive<?> archive) {
        return archive.add((Asset)new StringAsset(((TestClass)this.testClass.get()).getJavaClass().getName()), ArchivePaths.create((String)"arquillian-tomee-info.txt"));
    }

    protected Deployer deployer() throws NamingException {
        return this.lookupDeployerWithRetry(5);
    }

    protected Deployer lookupDeployerWithRetry(int retry) throws NamingException {
        try {
            Properties properties = new Properties();
            properties.setProperty("java.naming.factory.initial", "org.apache.openejb.client.RemoteInitialContextFactory");
            properties.setProperty("java.naming.provider.url", this.providerUrl());
            return (Deployer)new InitialContext(properties).lookup("openejb/DeployerBusinessRemote");
        }
        catch (RuntimeException ne) {
            if (retry > 1) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                return this.lookupDeployerWithRetry(retry - 1);
            }
            if (Boolean.getBoolean("openejb.arquillian.debug") && retry >= 0) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.lookupDeployerWithRetry(-1);
            }
            throw ne;
        }
    }

    protected String providerUrl() {
        return "http://" + ((TomEEConfiguration)this.configuration).getHost() + ":" + ((TomEEConfiguration)this.configuration).getHttpPort() + "/tomee/ejb";
    }

    protected String getArchiveNameWithoutExtension(Archive<?> archive) {
        String archiveName = archive.getName();
        int extensionOffset = archiveName.lastIndexOf(46);
        if (extensionOffset >= 0) {
            return archiveName.substring(0, extensionOffset);
        }
        return archiveName;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        DeployedApp deployed = this.moduleIds.get(archive.getName());
        try {
            this.deployer().undeploy(deployed.path);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentException("Unable to undeploy " + archive.getName(), (Throwable)e);
        }
        finally {
            LOGGER.info("cleaning " + deployed.file.getAbsolutePath());
            Files.delete(deployed.file);
            File pathFile = new File(deployed.path);
            if (!deployed.path.equals(deployed.file.getAbsolutePath()) && pathFile.exists()) {
                LOGGER.info("cleaning " + pathFile);
                Files.delete(pathFile);
            }
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    private static String startWithSlash(String s) {
        if (s == null) {
            return "/";
        }
        if (s.startsWith("/")) {
            return s;
        }
        return "/" + s;
    }

    private static String uniqueSlash(String contextRoot, String mapping) {
        boolean ctxSlash = contextRoot.endsWith("/");
        boolean mappingSlash = mapping.startsWith("/");
        if (ctxSlash && mappingSlash) {
            return contextRoot.substring(0, contextRoot.length() - 1) + mapping;
        }
        if (!ctxSlash && mappingSlash || ctxSlash && !mappingSlash) {
            return contextRoot + mapping;
        }
        return contextRoot + "/" + mapping;
    }

    public static class DeployedApp {
        public final File file;
        public final String path;

        public DeployedApp(String path, File file) {
            this.path = path;
            this.file = file;
        }
    }
}

