/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.test.spi.event.enrichment.BeforeEnrichment;

public class RemoteInitialContextObserver {
    private static final String REMOTE_INITIAL_CONTEXT_FACTORY = "org.apache.openejb.client.RemoteInitialContextFactory";
    @Inject
    @SuiteScoped
    private InstanceProducer<Context> context;
    @Inject
    private Instance<ProtocolMetaData> protocolMetadata;

    public void beforeSuite(@Observes BeforeEnrichment event) {
        ProtocolMetaData metaData = (ProtocolMetaData)this.protocolMetadata.get();
        if (metaData == null || !metaData.hasContext(HTTPContext.class)) {
            return;
        }
        try {
            Thread.currentThread().getContextClassLoader().loadClass(REMOTE_INITIAL_CONTEXT_FACTORY);
            HTTPContext httpContext = (HTTPContext)metaData.getContexts(HTTPContext.class).iterator().next();
            Properties props = new Properties();
            props.setProperty("java.naming.factory.initial", REMOTE_INITIAL_CONTEXT_FACTORY);
            props.setProperty("java.naming.provider.url", "http://" + httpContext.getHost() + ":" + httpContext.getPort() + "/tomee/ejb");
            this.context.set((Object)((Context)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Context.class}, (InvocationHandler)new MultipleContextHandler(new InitialContext(), new InitialContext(props)))));
        }
        catch (ClassNotFoundException e) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private static class MultipleContextHandler
    implements InvocationHandler {
        private final InitialContext[] contexts;

        public MultipleContextHandler(InitialContext ... initialContexts) {
            this.contexts = initialContexts;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Exception err = null;
            for (InitialContext ctx : this.contexts) {
                try {
                    return method.invoke((Object)ctx, args);
                }
                catch (Exception e) {
                    err = e;
                }
            }
            if (err != null) {
                throw err;
            }
            return null;
        }
    }
}

