/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class IO {
    public static Properties readProperties(URL resource) throws IOException {
        return IO.readProperties(resource, new Properties());
    }

    public static Properties readProperties(URL resource, Properties properties) throws IOException {
        return IO.readProperties(IO.read(resource), properties);
    }

    public static Properties readProperties(File resource) throws IOException {
        return IO.readProperties(resource, new Properties());
    }

    public static Properties readProperties(File resource, Properties properties) throws IOException {
        return IO.readProperties(IO.read(resource), properties);
    }

    public static Properties writeProperties(File resource, Properties properties) throws IOException {
        return IO.writeProperties(IO.write(resource), properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(InputStream in, Properties properties) throws IOException {
        if (in == null) {
            throw new NullPointerException("InputStream is null");
        }
        if (properties == null) {
            throw new NullPointerException("Properties is null");
        }
        try {
            properties.load(in);
        }
        finally {
            IO.close(in);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties writeProperties(OutputStream outputStream, Properties properties) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("OutputStream is null");
        }
        if (properties == null) {
            throw new NullPointerException("Properties is null");
        }
        try {
            properties.store(outputStream, "");
        }
        finally {
            IO.close(outputStream);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String string = reader.readLine();
            return string;
        }
        finally {
            IO.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(File file) throws IOException {
        FileReader in = new FileReader(file);
        try {
            BufferedReader reader = new BufferedReader(in);
            String string = reader.readLine();
            return string;
        }
        finally {
            IO.close(in);
        }
    }

    public static String slurp(String fileName) throws IOException {
        return IO.slurp(new File(fileName));
    }

    public static byte[] slurpBytes(File file) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(file, (OutputStream)out);
        return out.toByteArray();
    }

    public static String slurp(File file) throws IOException {
        return new String(IO.slurpBytes(file));
    }

    public static String slurp(InputStream in) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int i = -1;
        while ((i = in.read()) != -1) {
            outputStream.write(i);
        }
        return new String(outputStream.toByteArray(), "UTF-8");
    }

    public static String slurp(URL url) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IO.copy(url.openStream(), (OutputStream)out);
        return new String(out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File file, String string) throws IOException {
        FileWriter out = new FileWriter(file);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(out);
            try {
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            finally {
                IO.close(bufferedWriter);
            }
        }
        finally {
            IO.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from, OutputStream to) throws IOException {
        InputStream read = IO.read(from);
        try {
            IO.copy(read, to);
        }
        finally {
            IO.close(read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream from, File to) throws IOException {
        OutputStream write = IO.write(to);
        try {
            IO.copy(from, write);
        }
        finally {
            IO.close(write);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream from, File to, boolean append) throws IOException {
        OutputStream write = IO.write(to, append);
        try {
            IO.copy(from, write);
        }
        finally {
            IO.close(write);
        }
    }

    public static void copy(InputStream from, OutputStream to) throws IOException {
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = from.read(buffer)) != -1) {
            to.write(buffer, 0, length);
        }
        to.flush();
    }

    public static ZipOutputStream zip(File file) throws IOException {
        OutputStream write = IO.write(file);
        return new ZipOutputStream(write);
    }

    public static ZipInputStream unzip(File file) throws IOException {
        InputStream read = IO.read(file);
        return new ZipInputStream(read);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOException close(Closeable closeable) throws IOException {
        if (closeable == null) {
            return null;
        }
        try {
            if (closeable instanceof Flushable) {
                ((Flushable)((Object)closeable)).flush();
            }
        }
        catch (IOException e) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {}
            finally {
                return e;
            }
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            return e;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from, File to) throws IOException {
        FileOutputStream fos = new FileOutputStream(to);
        try {
            IO.copy(from, (OutputStream)fos);
        }
        finally {
            IO.close(fos);
        }
    }

    public static void copy(byte[] from, File to) throws IOException {
        IO.copy((InputStream)new ByteArrayInputStream(from), to);
    }

    public static void copy(byte[] from, OutputStream to) throws IOException {
        IO.copy((InputStream)new ByteArrayInputStream(from), to);
    }

    public static void closeSilently(Closeable closeable) {
        try {
            IO.close(closeable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean delete(File file) {
        if (file == null) {
            return false;
        }
        if (!file.delete()) {
            System.err.println("Delete failed " + file.getAbsolutePath());
            return false;
        }
        return true;
    }

    public static OutputStream write(File destination) throws FileNotFoundException {
        FileOutputStream out = new FileOutputStream(destination);
        return new BufferedOutputStream(out, 32768);
    }

    public static OutputStream write(File destination, boolean append) throws FileNotFoundException {
        FileOutputStream out = new FileOutputStream(destination, append);
        return new BufferedOutputStream(out, 32768);
    }

    public static InputStream read(File source) throws FileNotFoundException {
        FileInputStream in = new FileInputStream(source);
        return new BufferedInputStream(in, 32768);
    }

    public static InputStream read(byte[] content) {
        return new ByteArrayInputStream(content);
    }

    public static InputStream read(URL url) throws IOException {
        return url.openStream();
    }
}

