/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.enrichment.BeforeEnrichment;

public class RemoteInitialContextObserver {
    private static final String REMOTE_INITIAL_CONTEXT_FACTORY = "org.apache.openejb.client.RemoteInitialContextFactory";
    @Inject
    @ApplicationScoped
    private InstanceProducer<Context> context;
    @Inject
    private Instance<Context> existingContext;
    @Inject
    private Instance<ProtocolMetaData> protocolMetadata;

    public void beforeSuite(@Observes BeforeEnrichment event) {
        ProtocolMetaData metaData = (ProtocolMetaData)this.protocolMetadata.get();
        if (metaData == null || !metaData.hasContext(HTTPContext.class)) {
            return;
        }
        try {
            Thread.currentThread().getContextClassLoader().loadClass(REMOTE_INITIAL_CONTEXT_FACTORY);
            HTTPContext httpContext = (HTTPContext)metaData.getContexts(HTTPContext.class).iterator().next();
            Properties props = new Properties();
            props.setProperty("java.naming.factory.initial", REMOTE_INITIAL_CONTEXT_FACTORY);
            props.setProperty("java.naming.provider.url", "http://" + httpContext.getHost() + ":" + httpContext.getPort() + "/tomee/ejb");
            Context existing = null;
            try {
                existing = (Context)this.existingContext.get();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.context.set((Object)((Context)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Context.class}, (InvocationHandler)new MultipleContextHandler(props, existing))));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static class MultipleContextHandler
    implements InvocationHandler {
        private final Context context;
        private final Properties properties;

        public MultipleContextHandler(Properties props, Context initialContexts) {
            this.properties = props;
            this.context = initialContexts;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Throwable err = null;
            for (Callable callable : Arrays.asList(new Callable<Context>(){

                @Override
                public Context call() throws Exception {
                    return new InitialContext(MultipleContextHandler.this.properties);
                }
            }, new Callable<Context>(){

                @Override
                public Context call() throws Exception {
                    return MultipleContextHandler.this.context;
                }
            }, new Callable<Context>(){

                @Override
                public Context call() throws Exception {
                    return new InitialContext();
                }
            })) {
                try {
                    Context ctx = (Context)callable.call();
                    if (ctx == null) continue;
                    return method.invoke((Object)ctx, args);
                }
                catch (Exception e) {
                    err = e;
                }
            }
            if (err != null) {
                if (InvocationTargetException.class.isInstance(err)) {
                    throw err.getCause();
                }
                throw err;
            }
            return null;
        }
    }
}

