/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.common;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.openejb.config.AdditionalBeanDiscoverer;
import org.apache.openejb.config.AnnotationDeployer;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ManagedBean;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.IO;
import org.apache.xbean.finder.IAnnotationFinder;

public class TestClassDiscoverer
implements AdditionalBeanDiscoverer {
    public AppModule discover(AppModule module) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        HashSet<Class<? extends Annotation>> testMarkers = new HashSet<Class<? extends Annotation>>();
        for (String s : Arrays.asList("org.junit.Test", "org.testng.annotations.Test")) {
            try {
                testMarkers.add(contextClassLoader.loadClass(s));
            }
            catch (Throwable e) {}
        }
        HashSet testClasses = new HashSet();
        if (!testMarkers.isEmpty()) {
            TestClassDiscoverer.addTests(testMarkers, module.getEarLibFinder(), testClasses);
            for (WebModule web : module.getWebModules()) {
                TestClassDiscoverer.addTests(testMarkers, web.getFinder(), testClasses);
            }
            for (EjbModule ejb : module.getEjbModules()) {
                TestClassDiscoverer.addTests(testMarkers, ejb.getFinder(), testClasses);
            }
            for (ConnectorModule connector : module.getConnectorModules()) {
                TestClassDiscoverer.addTests(testMarkers, connector.getFinder(), testClasses);
            }
        }
        File file = module.getFile();
        String line = this.findTestName(file, module.getClassLoader());
        String moduleId = null;
        ClassLoader loader = null;
        if (line != null) {
            String name;
            int endIndex = line.indexOf(35);
            if (endIndex > 0) {
                name = line.substring(0, endIndex);
                if (file != null && !file.getName().equals(line.substring(endIndex + 1, line.length()))) {
                    name = null;
                }
            } else {
                name = line;
            }
            if (name != null) {
                try {
                    testClasses.add(module.getClassLoader().loadClass(name));
                }
                catch (Throwable throwable) {
                    for (WebModule web : module.getWebModules()) {
                        try {
                            testClasses.add(web.getClassLoader().loadClass(name));
                            moduleId = web.getModuleId();
                            loader = web.getClassLoader();
                            break;
                        }
                        catch (Throwable e2) {
                        }
                    }
                }
            }
        }
        Iterator it = testClasses.iterator();
        while (it.hasNext()) {
            try {
                Class current;
                if (!AnnotationDeployer.isInstantiable((Class)current)) {
                    it.remove();
                    continue;
                }
                for (current = (Class)it.next(); current != null; current = current.getSuperclass()) {
                    current.getDeclaredFields();
                    current.getDeclaredMethods();
                    current.getCanonicalName();
                }
            }
            catch (NoClassDefFoundError ncdfe) {
                it.remove();
            }
        }
        for (Class clazz : testClasses) {
            EjbJar ejbJar = new EjbJar();
            OpenejbJar openejbJar = new OpenejbJar();
            String name = clazz.getName();
            String ejbName = module.getModuleId() + "_" + name;
            ManagedBean bean = (ManagedBean)ejbJar.addEnterpriseBean((EnterpriseBean)new ManagedBean(ejbName, name, true));
            bean.localBean();
            bean.setTransactionType(TransactionType.BEAN);
            EjbDeployment ejbDeployment = openejbJar.addEjbDeployment((EnterpriseBean)bean);
            ejbDeployment.setDeploymentId(ejbName);
            EjbModule ejbModule = new EjbModule(ejbJar, openejbJar);
            if (moduleId != null) {
                ejbModule.setWebapp(true);
                ejbModule.getProperties().put("openejb.ejbmodule.webappId", moduleId);
                ejbModule.setClassLoader(loader);
            }
            module.getEjbModules().add(ejbModule);
        }
        return module;
    }

    private static void addTests(Set<Class<? extends Annotation>> testMarkers, IAnnotationFinder finder, Set<Class<?>> testClasses) {
        if (finder == null) {
            return;
        }
        for (Class<? extends Annotation> marker : testMarkers) {
            try {
                List annotatedMethods = finder.findAnnotatedMethods(marker);
                for (Method m : annotatedMethods) {
                    try {
                        testClasses.add(m.getDeclaringClass());
                    }
                    catch (NoClassDefFoundError e) {}
                }
            }
            catch (NoClassDefFoundError ncdfe) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findTestName(File folder, ClassLoader classLoader) {
        Object info;
        File unpacked;
        InputStream is = null;
        File dir = folder;
        if (dir != null && (dir.getName().endsWith(".war") || dir.getName().endsWith(".ear")) && (unpacked = new File(dir.getParentFile(), dir.getName().substring(0, dir.getName().length() - 4))).exists()) {
            dir = unpacked;
        }
        if (dir != null && dir.isDirectory() && ((File)(info = new File(dir, "arquillian-tomee-info.txt"))).exists()) {
            try {
                is = new FileInputStream((File)info);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        if (is == null) {
            is = classLoader.getResourceAsStream("arquillian-tomee-info.txt");
        }
        if (is != null) {
            try {
                info = IO.slurp((InputStream)is);
                return info;
            }
            catch (IOException e) {
            }
            finally {
                IO.close((Closeable)is);
            }
        }
        return null;
    }
}

