/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.embedded;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openejb.arquillian.common.Files;
import org.apache.openejb.arquillian.common.TestClassDiscoverer;
import org.apache.openejb.arquillian.common.TomEEConfiguration;
import org.apache.openejb.arquillian.common.TomEEContainer;
import org.apache.openejb.arquillian.embedded.EmbeddedTomEEConfiguration;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.config.AdditionalBeanDiscoverer;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class EmbeddedTomEEContainer
extends TomEEContainer<EmbeddedTomEEConfiguration> {
    private static final Map<Archive<?>, File> ARCHIVES = new ConcurrentHashMap();
    private Container container;

    public Class<EmbeddedTomEEConfiguration> getConfigurationClass() {
        return EmbeddedTomEEConfiguration.class;
    }

    public void setup(EmbeddedTomEEConfiguration configuration) {
        super.setup((TomEEConfiguration)configuration);
        this.container = new Container();
        this.container.setup(this.convertConfiguration(configuration));
    }

    private Configuration convertConfiguration(EmbeddedTomEEConfiguration tomeeConfiguration) {
        Configuration configuration = new Configuration();
        configuration.setDir(tomeeConfiguration.getDir());
        configuration.setHttpPort(tomeeConfiguration.getHttpPort());
        configuration.setStopPort(tomeeConfiguration.getStopPort());
        configuration.setHost(tomeeConfiguration.getHost());
        configuration.setServerXml(tomeeConfiguration.getServerXml());
        configuration.setProperties(tomeeConfiguration.systemPropertiesAsProperties());
        configuration.setQuickSession(tomeeConfiguration.isQuickSession());
        return configuration;
    }

    public void start() throws LifecycleException {
        try {
            this.container.start();
            SystemInstance.get().setComponent(AdditionalBeanDiscoverer.class, (Object)new TestClassDiscoverer());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LifecycleException("Something went wrong", (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        try {
            this.container.stop();
        }
        catch (Exception e) {
            throw new LifecycleException("Unable to stop server", (Throwable)e);
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Local");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            String name = archive.getName();
            File file = this.dumpFile(archive);
            ARCHIVES.put(archive, file);
            ((ZipExporter)this.archiveWithTestInfo(archive).as(ZipExporter.class)).exportTo(file, true);
            this.container.deploy(name, file);
            AppInfo info = this.container.getInfo(name);
            String context = this.getArchiveNameWithoutExtension(archive);
            HTTPContext httpContext = new HTTPContext(((EmbeddedTomEEConfiguration)this.configuration).getHost(), ((EmbeddedTomEEConfiguration)this.configuration).getHttpPort());
            httpContext.add(new Servlet("ArquillianServletRunner", "/" + context));
            this.addServlets(httpContext, info);
            return new ProtocolMetaData().addContext((Object)httpContext);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentException("Unable to deploy", (Throwable)e);
        }
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        try {
            String name = archive.getName();
            this.container.undeploy(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DeploymentException("Unable to undeploy", (Throwable)e);
        }
        File file = ARCHIVES.remove(archive);
        File folder = new File(file.getParentFile(), file.getName().substring(0, file.getName().length() - 5));
        if (folder.exists()) {
            Files.delete((File)folder);
        }
        Files.delete((File)file);
    }
}

