/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.arquillian.embedded;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.servlet.http.HttpSession;
import org.apache.openejb.arquillian.common.ArquillianFilterRunner;
import org.apache.openejb.arquillian.common.Files;
import org.apache.openejb.arquillian.common.TestClassDiscoverer;
import org.apache.openejb.arquillian.common.TomEEConfiguration;
import org.apache.openejb.arquillian.common.TomEEContainer;
import org.apache.openejb.arquillian.embedded.EmbeddedTomEEConfiguration;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.config.AdditionalBeanDiscoverer;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.tomee.embedded.Configuration;
import org.apache.tomee.embedded.Container;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.web.lifecycle.test.MockHttpSession;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.shrinkwrap.api.Archive;

public class EmbeddedTomEEContainer
extends TomEEContainer<EmbeddedTomEEConfiguration> {
    private static final Map<Archive<?>, File> ARCHIVES = new ConcurrentHashMap();
    private static final Map<String, MockHttpSession> SESSIONS = new ConcurrentHashMap<String, MockHttpSession>();
    private Container container;
    @Inject
    @SuiteScoped
    private InstanceProducer<ClassLoader> classLoader;

    public Class<EmbeddedTomEEConfiguration> getConfigurationClass() {
        return EmbeddedTomEEConfiguration.class;
    }

    public void setup(EmbeddedTomEEConfiguration configuration) {
        super.setup((TomEEConfiguration)configuration);
        this.container = new Container();
        this.container.setup(this.convertConfiguration(configuration));
    }

    private Configuration convertConfiguration(EmbeddedTomEEConfiguration tomeeConfiguration) {
        Configuration configuration = new Configuration();
        configuration.setDir(tomeeConfiguration.getDir());
        configuration.setHttpPort(tomeeConfiguration.getHttpPort());
        configuration.setStopPort(tomeeConfiguration.getStopPort());
        configuration.setHost(tomeeConfiguration.getHost());
        configuration.setServerXml(tomeeConfiguration.getServerXml());
        configuration.setProperties(tomeeConfiguration.systemPropertiesAsProperties());
        configuration.setQuickSession(tomeeConfiguration.isQuickSession());
        configuration.setSsl(tomeeConfiguration.isSsl());
        configuration.setHttpsPort(tomeeConfiguration.getHttpsPort());
        configuration.setKeystoreFile(tomeeConfiguration.getKeystoreFile());
        configuration.setKeystorePass(tomeeConfiguration.getKeystorePass());
        configuration.setKeyAlias(tomeeConfiguration.getKeyAlias());
        configuration.setKeystoreType(tomeeConfiguration.getKeystoreType());
        configuration.setClientAuth(tomeeConfiguration.getClientAuth());
        configuration.setKeyAlias(tomeeConfiguration.getKeyAlias());
        configuration.setSslProtocol(tomeeConfiguration.getSslProtocol());
        if (tomeeConfiguration.getRoles() != null) {
            configuration.setRoles(new HashMap((Map)Map.class.cast(tomeeConfiguration.getRolesAsProperties())));
        }
        if (tomeeConfiguration.getUsers() != null) {
            configuration.setUsers(new HashMap((Map)Map.class.cast(tomeeConfiguration.getUsersAsProperties())));
        }
        return configuration;
    }

    public void start() throws LifecycleException {
        try {
            this.container.start();
            SystemInstance.get().setComponent(AdditionalBeanDiscoverer.class, (Object)new TestClassDiscoverer());
            SystemInstance.get().setProperty("org.apache.openejb.servlet.filters", ArquillianFilterRunner.class.getName() + "=/ArquillianServletRunner");
        }
        catch (Exception e) {
            throw new LifecycleException("Something went wrong", (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        try {
            this.container.stop();
        }
        catch (Exception e) {
            throw new LifecycleException("Unable to stop server", (Throwable)e);
        }
        finally {
            this.resetSerialization();
        }
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Local");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            String name = archive.getName();
            TomEEContainer.Dump dump = this.dumpFile(archive);
            File file = dump.getFile();
            if (dump.isCreated() || !((EmbeddedTomEEConfiguration)this.configuration).isSingleDeploymentByArchiveName(name)) {
                ARCHIVES.put(archive, file);
                this.container.deploy(name, file);
            }
            AppInfo info = this.container.getInfo(name);
            String context = this.getArchiveNameWithoutExtension(archive);
            HTTPContext httpContext = new HTTPContext(((EmbeddedTomEEConfiguration)this.configuration).getHost(), ((EmbeddedTomEEConfiguration)this.configuration).getHttpPort());
            httpContext.add(new Servlet("ArquillianServletRunner", "/" + context));
            this.addServlets(httpContext, info);
            this.startCdiContexts(name);
            this.classLoader.set((Object)((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getAppContext((Object)info.appId).getClassLoader());
            return new ProtocolMetaData().addContext((Object)httpContext);
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to deploy", (Throwable)e);
        }
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        String name = archive.getName();
        this.stopCdiContexts(name);
        if (((EmbeddedTomEEConfiguration)this.configuration).isSingleDeploymentByArchiveName(name)) {
            return;
        }
        try {
            this.container.undeploy(name);
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to undeploy", (Throwable)e);
        }
        File file = ARCHIVES.remove(archive);
        if (!((EmbeddedTomEEConfiguration)this.configuration).isSingleDumpByArchiveName()) {
            File folder = new File(file.getParentFile(), file.getName().substring(0, file.getName().length() - 4));
            if (folder.exists()) {
                Files.delete((File)folder);
            }
            Files.delete((File)file);
            File parentFile = file.getParentFile();
            File[] parentChildren = parentFile.listFiles();
            if (parentChildren == null || parentChildren.length == 0) {
                Files.delete((File)file.getParentFile());
            }
        }
    }

    private void startCdiContexts(String name) {
        WebBeansContext wbc = this.container.getAppContexts(name).getWebBeansContext();
        if (wbc.getBeanManagerImpl().isInUse()) {
            MockHttpSession session = new MockHttpSession();
            wbc.getContextsService().startContext(RequestScoped.class, null);
            wbc.getContextsService().startContext(SessionScoped.class, (Object)session);
            wbc.getContextsService().startContext(ConversationScoped.class, null);
            SESSIONS.put(name, session);
        }
    }

    private void stopCdiContexts(String name) {
        try {
            WebBeansContext wbc;
            HttpSession session = (HttpSession)SESSIONS.remove(name);
            if (session != null && (wbc = this.container.getAppContexts(this.container.getInfo((String)name).appId).getWebBeansContext()).getBeanManagerImpl().isInUse()) {
                wbc.getContextsService().startContext(RequestScoped.class, null);
                wbc.getContextsService().startContext(SessionScoped.class, (Object)session);
                wbc.getContextsService().startContext(ConversationScoped.class, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

