/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.arquillian.remote;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.openejb.arquillian.common.Files;
import org.apache.openejb.arquillian.common.Setup;
import org.apache.openejb.arquillian.common.TomEEConfiguration;
import org.apache.openejb.arquillian.common.TomEEContainer;
import org.apache.openejb.config.RemoteServer;
import org.apache.tomee.arquillian.remote.RemoteTomEEConfiguration;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;

public class RemoteTomEEContainer
extends TomEEContainer<RemoteTomEEConfiguration> {
    private static final Logger logger = Logger.getLogger(RemoteTomEEContainer.class.getName());
    private RemoteServer container;
    private boolean shutdown = false;

    public void start() throws LifecycleException {
        if (Setup.isRunning((int)((RemoteTomEEConfiguration)this.configuration).getHttpPort())) {
            logger.info(String.format("TomEE found running on port %s", ((RemoteTomEEConfiguration)this.configuration).getHttpPort()));
            return;
        }
        this.shutdown = true;
        try {
            this.configure();
            this.container = new RemoteServer();
            this.container.start();
        }
        catch (Exception e) {
            throw new LifecycleException("Unable to start remote container", (Throwable)e);
        }
    }

    private void configure() throws LifecycleException, IOException {
        File workingDirectory = new File(((RemoteTomEEConfiguration)this.configuration).getDir());
        if (workingDirectory.exists()) {
            Files.assertDir((File)workingDirectory);
        } else {
            Files.mkdir((File)workingDirectory);
            Files.deleteOnExit((File)workingDirectory);
        }
        Files.readable((File)workingDirectory);
        Files.writable((File)workingDirectory);
        File openejbHome = Setup.findHome((File)workingDirectory);
        if (openejbHome == null) {
            openejbHome = Setup.downloadAndUnpack((File)workingDirectory, (String)((RemoteTomEEConfiguration)this.configuration).getArtifactName());
        }
        Files.assertDir((File)openejbHome);
        Files.readable((File)openejbHome);
        Files.writable((File)openejbHome);
        Setup.updateServerXml((File)openejbHome, (int)((RemoteTomEEConfiguration)this.configuration).getHttpPort(), (int)((RemoteTomEEConfiguration)this.configuration).getStopPort(), (int)((RemoteTomEEConfiguration)this.configuration).getAjpPort());
        Setup.exportProperties((File)openejbHome, (TomEEConfiguration)this.configuration);
        if (((RemoteTomEEConfiguration)this.configuration).isRemoveUnusedWebapps()) {
            Setup.removeUselessWebapps((File)openejbHome);
        }
    }

    public void stop() throws LifecycleException {
        if (this.shutdown) {
            this.container.stop();
        }
    }

    public Class<RemoteTomEEConfiguration> getConfigurationClass() {
        return RemoteTomEEConfiguration.class;
    }
}

