/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.arquillian.remote;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.apache.openejb.arquillian.common.Files;
import org.apache.openejb.arquillian.common.IO;
import org.apache.openejb.arquillian.common.Setup;
import org.apache.openejb.arquillian.common.TomEEConfiguration;
import org.apache.openejb.arquillian.common.TomEEContainer;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.config.RemoteServer;
import org.apache.tomee.arquillian.remote.RemoteTomEEConfiguration;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;

public class RemoteTomEEContainer
extends TomEEContainer<RemoteTomEEConfiguration> {
    private static final Logger logger = Logger.getLogger(RemoteTomEEContainer.class.getName());
    private RemoteServer container;
    private boolean shutdown = false;

    public void start() throws LifecycleException {
        if (Setup.isRunning((String)((RemoteTomEEConfiguration)this.configuration).getHost(), (int)((RemoteTomEEConfiguration)this.configuration).getHttpPort())) {
            logger.info(String.format("TomEE found running on port %s", ((RemoteTomEEConfiguration)this.configuration).getHttpPort()));
            return;
        }
        this.shutdown = true;
        String shutdownPort = System.getProperty("server.shutdown.port");
        String shutdownHost = System.getProperty("server.shutdown.host");
        String shutdownCommand = System.getProperty("server.shutdown.command");
        String debug = System.getProperty("openejb.server.debug");
        String debugPort = System.getProperty("server.debug.port");
        try {
            this.configure();
            System.setProperty("server.shutdown.port", Integer.toString(((RemoteTomEEConfiguration)this.configuration).getStopPort()));
            System.setProperty("server.shutdown.command", ((RemoteTomEEConfiguration)this.configuration).getStopCommand());
            System.setProperty("server.shutdown.host", ((RemoteTomEEConfiguration)this.configuration).getStopHost());
            if (((RemoteTomEEConfiguration)this.configuration).isDebug()) {
                System.setProperty("openejb.server.debug", "true");
                System.setProperty("server.debug.port", Integer.toString(((RemoteTomEEConfiguration)this.configuration).getDebugPort()));
            }
            this.container = new RemoteServer();
            this.container.start();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to start remote container", e);
            throw new LifecycleException("Unable to start remote container:" + e.getMessage(), (Throwable)e);
        }
        finally {
            RemoteTomEEContainer.resetSystemProperty("server.shutdown.port", shutdownPort);
            RemoteTomEEContainer.resetSystemProperty("server.shutdown.host", shutdownHost);
            RemoteTomEEContainer.resetSystemProperty("server.shutdown.command", shutdownCommand);
            RemoteTomEEContainer.resetSystemProperty("openejb.server.debug", debug);
            RemoteTomEEContainer.resetSystemProperty("server.debug.port", debugPort);
        }
    }

    private static void resetSystemProperty(String key, String value) {
        if (value == null) {
            System.getProperties().remove(key);
        } else {
            System.setProperty(key, value);
        }
    }

    private void configure() throws LifecycleException, IOException {
        File workingDirectory = new File(((RemoteTomEEConfiguration)this.configuration).getDir()).getAbsoluteFile();
        if (((RemoteTomEEConfiguration)this.configuration).getCleanOnStartUp()) {
            Files.delete((File)workingDirectory);
        }
        if (workingDirectory.exists()) {
            Files.assertDir((File)workingDirectory);
        } else {
            Files.mkdir((File)workingDirectory);
            Files.deleteOnExit((File)workingDirectory);
        }
        Files.readable((File)workingDirectory);
        Files.writable((File)workingDirectory);
        File openejbHome = Setup.findHome((File)workingDirectory);
        if (openejbHome == null) {
            openejbHome = Setup.downloadAndUnpack((File)workingDirectory, (String)((RemoteTomEEConfiguration)this.configuration).getArtifactName());
            logger.log(Level.INFO, "Downloaded container to: " + openejbHome);
        }
        Files.assertDir((File)openejbHome);
        Files.readable((File)openejbHome);
        Files.writable((File)openejbHome);
        Setup.configureServerXml((File)openejbHome, (TomEEConfiguration)this.configuration);
        Setup.configureSystemProperties((File)openejbHome, (TomEEConfiguration)this.configuration);
        Setup.synchronizeFolder((File)openejbHome, (String)((RemoteTomEEConfiguration)this.configuration).getConf(), (String)"conf");
        Setup.synchronizeFolder((File)openejbHome, (String)((RemoteTomEEConfiguration)this.configuration).getBin(), (String)"bin");
        Setup.synchronizeFolder((File)openejbHome, (String)((RemoteTomEEConfiguration)this.configuration).getLib(), (String)"lib");
        Setup.exportProperties((File)openejbHome, (TomEEConfiguration)this.configuration);
        if (((RemoteTomEEConfiguration)this.configuration).isRemoveUnusedWebapps()) {
            Setup.removeUselessWebapps((File)openejbHome);
        }
        if (logger.isLoggable(Level.FINE)) {
            TreeMap<Object, Object> map = new TreeMap<Object, Object>(System.getProperties());
            for (Map.Entry entry : map.entrySet()) {
                logger.log(Level.FINE, String.format("%s = %s\n", entry.getKey(), entry.getValue()));
            }
        }
    }

    public void stop() throws LifecycleException {
        if (this.shutdown) {
            this.container.stop();
        }
    }

    public Class<RemoteTomEEConfiguration> getConfigurationClass() {
        return RemoteTomEEConfiguration.class;
    }

    protected Deployer deployer() throws NamingException {
        try {
            return super.deployer();
        }
        catch (RuntimeException ne) {
            if (Boolean.getBoolean("openejb.arquillian.debug")) {
                this.container.kill3UNIX();
                LOGGER.info("Can't connect to deployer through: " + this.providerUrl());
                try {
                    LOGGER.info("Here is the server.xml:\n" + IO.slurp((File)new File(Setup.findHome((File)new File(((RemoteTomEEConfiguration)this.configuration).getDir()).getAbsoluteFile()), "conf/server.xml")));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw ne;
        }
    }
}

