/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.arquillian.remote;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.apache.openejb.arquillian.common.ArquillianUtil;
import org.apache.openejb.arquillian.common.Files;
import org.apache.openejb.arquillian.common.IO;
import org.apache.openejb.arquillian.common.Setup;
import org.apache.openejb.arquillian.common.TomEEConfiguration;
import org.apache.openejb.arquillian.common.TomEEContainer;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.config.RemoteServer;
import org.apache.tomee.arquillian.remote.RemoteTomEEConfiguration;
import org.apache.tomee.arquillian.remote.SimpleTomEEFormatter;
import org.apache.tomee.util.InstallationEnrichers;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.shrinkwrap.api.Archive;

public class RemoteTomEEContainer
extends TomEEContainer<RemoteTomEEConfiguration> {
    private static final Logger logger = Logger.getLogger(RemoteTomEEContainer.class.getName());
    private RemoteServer container;
    private boolean shutdown = false;
    private File tomeeHome;
    private Collection<Archive<?>> containerArchives;

    public void start() throws LifecycleException {
        if (Setup.isRunning((String)((RemoteTomEEConfiguration)this.configuration).getHost(), (int)((RemoteTomEEConfiguration)this.configuration).getHttpPort())) {
            logger.info(String.format("TomEE found running on port %s", ((RemoteTomEEConfiguration)this.configuration).getHttpPort()));
            return;
        }
        this.shutdown = true;
        String shutdownPort = System.getProperty("server.shutdown.port");
        String shutdownHost = System.getProperty("server.shutdown.host");
        String shutdownCommand = System.getProperty("server.shutdown.command");
        String debug = System.getProperty("openejb.server.debug");
        String debugPort = System.getProperty("server.debug.port");
        try {
            this.configure();
            System.setProperty("server.shutdown.port", Integer.toString(((RemoteTomEEConfiguration)this.configuration).getStopPort()));
            System.setProperty("server.shutdown.command", ((RemoteTomEEConfiguration)this.configuration).getStopCommand());
            System.setProperty("server.shutdown.host", ((RemoteTomEEConfiguration)this.configuration).getStopHost());
            if (((RemoteTomEEConfiguration)this.configuration).isDebug()) {
                System.setProperty("openejb.server.debug", "true");
                System.setProperty("server.debug.port", Integer.toString(((RemoteTomEEConfiguration)this.configuration).getDebugPort()));
            }
            this.container = new RemoteServer();
            this.container.setAdditionalClasspath(InstallationEnrichers.addOneLineFormatter((File)this.tomeeHome));
            this.container.start(this.args(), "start", true);
            this.container.killOnExit();
            if (((RemoteTomEEConfiguration)this.configuration).getProperties() != null) {
                Properties props = new Properties();
                IO.readProperties((InputStream)IO.read((byte[])((RemoteTomEEConfiguration)this.configuration).getProperties().getBytes()), (Properties)new Properties());
                this.containerArchives = ArquillianUtil.toDeploy((Properties)props);
                for (Archive<?> archive : this.containerArchives) {
                    this.deploy(archive);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to start remote container", e);
            throw new LifecycleException("Unable to start remote container:" + e.getMessage(), (Throwable)e);
        }
        finally {
            RemoteTomEEContainer.resetSystemProperty("server.shutdown.port", shutdownPort);
            RemoteTomEEContainer.resetSystemProperty("server.shutdown.host", shutdownHost);
            RemoteTomEEContainer.resetSystemProperty("server.shutdown.command", shutdownCommand);
            RemoteTomEEContainer.resetSystemProperty("openejb.server.debug", debug);
            RemoteTomEEContainer.resetSystemProperty("server.debug.port", debugPort);
        }
    }

    private List<String> args() {
        String opts = ((RemoteTomEEConfiguration)this.configuration).getCatalina_opts();
        if (opts == null || (opts = opts.trim()).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> splitOnSpace = new ArrayList<String>();
        opts = opts.replace("\n", " ").trim();
        ArgsIterator it = new ArgsIterator(opts);
        while (it.hasNext()) {
            splitOnSpace.add((String)it.next());
        }
        return splitOnSpace;
    }

    private static void resetSystemProperty(String key, String value) {
        if (value == null) {
            System.getProperties().remove(key);
        } else {
            System.setProperty(key, value);
        }
    }

    private void configure() throws LifecycleException, IOException {
        File workingDirectory = new File(((RemoteTomEEConfiguration)this.configuration).getDir()).getAbsoluteFile();
        if (((RemoteTomEEConfiguration)this.configuration).getCleanOnStartUp()) {
            Files.delete((File)workingDirectory);
        }
        if (workingDirectory.exists()) {
            Files.assertDir((File)workingDirectory);
        } else {
            Files.mkdir((File)workingDirectory);
            Files.deleteOnExit((File)workingDirectory);
        }
        Files.readable((File)workingDirectory);
        Files.writable((File)workingDirectory);
        this.tomeeHome = Setup.findHome((File)workingDirectory);
        if (this.tomeeHome == null) {
            this.tomeeHome = Setup.downloadAndUnpack((File)workingDirectory, (String)((RemoteTomEEConfiguration)this.configuration).getArtifactName());
            logger.log(Level.INFO, "Downloaded container to: " + this.tomeeHome);
        }
        Files.assertDir((File)this.tomeeHome);
        Files.readable((File)this.tomeeHome);
        Files.writable((File)this.tomeeHome);
        Setup.configureServerXml((File)this.tomeeHome, (TomEEConfiguration)this.configuration);
        Setup.synchronizeFolder((File)this.tomeeHome, (String)((RemoteTomEEConfiguration)this.configuration).getConf(), (String)"conf");
        Setup.synchronizeFolder((File)this.tomeeHome, (String)((RemoteTomEEConfiguration)this.configuration).getBin(), (String)"bin");
        Setup.synchronizeFolder((File)this.tomeeHome, (String)((RemoteTomEEConfiguration)this.configuration).getLib(), (String)"lib");
        Setup.configureSystemProperties((File)this.tomeeHome, (TomEEConfiguration)this.configuration);
        String opts = ((RemoteTomEEConfiguration)this.configuration).getCatalina_opts();
        Setup.exportProperties((File)this.tomeeHome, (TomEEConfiguration)this.configuration, (opts == null || !opts.contains("-Xm") && !opts.matches(".*-XX:[^=]*Size=.*") ? 1 : 0) != 0);
        Setup.installArquillianBeanDiscoverer((File)this.tomeeHome);
        if (((RemoteTomEEConfiguration)this.configuration).isRemoveUnusedWebapps()) {
            Setup.removeUselessWebapps((File)this.tomeeHome);
        }
        if (((RemoteTomEEConfiguration)this.configuration).isSimpleLog() && this.noLoggingConfigProvided()) {
            File loggingProperties = Files.path((File)this.tomeeHome, (String[])new String[]{"conf", "logging.properties"});
            Properties logging = new Properties();
            logging.put("handlers", "java.util.logging.ConsoleHandler");
            logging.put(".handlers", "java.util.logging.ConsoleHandler");
            logging.put("java.util.logging.ConsoleHandler.level", "INFO");
            logging.put("java.util.logging.ConsoleHandler.formatter", SimpleTomEEFormatter.class.getName());
            IO.writeProperties((File)loggingProperties, (Properties)logging);
        }
        if (logger.isLoggable(Level.FINE)) {
            TreeMap<Object, Object> map = new TreeMap<Object, Object>(System.getProperties());
            for (Map.Entry entry : map.entrySet()) {
                logger.log(Level.FINE, String.format("%s = %s\n", entry.getKey(), entry.getValue()));
            }
        }
    }

    private boolean noLoggingConfigProvided() {
        if (((RemoteTomEEConfiguration)this.configuration).getConf() == null) {
            return true;
        }
        File conf = new File(((RemoteTomEEConfiguration)this.configuration).getConf());
        return !conf.exists() || !new File(conf, "logging.properties").exists();
    }

    public void stop() throws LifecycleException {
        ArquillianUtil.undeploy((DeployableContainer)this, this.containerArchives);
        if (this.shutdown) {
            Setup.removeArquillianBeanDiscoverer((File)this.tomeeHome);
            this.container.destroy();
        }
    }

    public Class<RemoteTomEEConfiguration> getConfigurationClass() {
        return RemoteTomEEConfiguration.class;
    }

    protected Deployer deployer() throws NamingException {
        try {
            return super.deployer();
        }
        catch (RuntimeException ne) {
            if (Boolean.getBoolean("openejb.arquillian.debug")) {
                this.container.kill3UNIX();
                LOGGER.info("Can't connect to deployer through: " + this.providerUrl());
                try {
                    LOGGER.info("Here is the server.xml:\n" + IO.slurp((File)new File(Setup.findHome((File)new File(((RemoteTomEEConfiguration)this.configuration).getDir()).getAbsoluteFile()), "conf/server.xml")));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw ne;
        }
    }

    private static class ArgsIterator
    implements Iterator<String> {
        private final String string;
        private int currentIndex;

        public ArgsIterator(String opts) {
            this.string = opts;
            this.currentIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.string != null && this.currentIndex < this.string.length();
        }

        @Override
        public String next() {
            int endChar;
            this.skipWhiteCharacters();
            if (this.done()) {
                throw new UnsupportedOperationException("No more element");
            }
            if (this.string.charAt(this.currentIndex) == '\"') {
                ++this.currentIndex;
                endChar = 34;
            } else {
                endChar = 32;
            }
            int start = this.currentIndex;
            int end = this.string.indexOf(endChar, this.currentIndex + 1);
            if (end <= 0) {
                end = this.string.length();
            }
            this.currentIndex = end + 1;
            return this.string.substring(start, end);
        }

        private void skipWhiteCharacters() {
            while (!(this.done() || this.string.charAt(this.currentIndex) != ' ' && this.string.charAt(this.currentIndex) != '\t')) {
                ++this.currentIndex;
            }
        }

        private boolean done() {
            return this.currentIndex >= this.string.length();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

