/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.tck.cdi.tomee.embedded;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.openejb.config.ValidationException;
import org.apache.openejb.tck.OpenEJBTCKRuntimeException;
import org.apache.openejb.tck.cdi.tomee.embedded.ResetStaticValve;
import org.apache.tomee.embedded.Container;
import org.jboss.testharness.api.DeploymentException;
import org.jboss.testharness.spi.Containers;

public class ContainersImpl
implements Containers {
    private static int count = 0;
    private static final String tmpDir = System.getProperty("java.io.tmpdir");
    private Exception exception;
    private final Container container;
    private static final Map<String, File> FILES = new ConcurrentHashMap<String, File>();

    public ContainersImpl() {
        System.out.println("Initialized ContainersImpl " + ++count);
        this.container = new Container();
        System.setProperty("tomee.valves", ResetStaticValve.class.getName());
    }

    public boolean deploy(InputStream archive, String name) throws IOException {
        this.exception = null;
        System.out.println("Deploying " + archive + " with name " + name);
        File application = this.getFile(name);
        System.out.println(application);
        FILES.put(name, application.getParentFile());
        this.writeToFile(application, archive);
        try {
            this.container.deploy(name, application);
        }
        catch (Exception ex) {
            Exception e = ex;
            if (e.getCause() instanceof ValidationException) {
                e = (Exception)e.getCause();
            }
            if (name.contains(".broken.")) {
                this.exception = (DeploymentException)new DeploymentException("deploy failed").initCause((Throwable)e);
            } else {
                System.out.println("FIX Deployment of " + name);
                e.printStackTrace();
                this.exception = e;
            }
            return false;
        }
        return true;
    }

    private void writeToFile(File file, InputStream archive) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = archive.read(buffer)) > -1) {
                fos.write(buffer, 0, bytesRead);
            }
            Util.close(fos);
        }
        catch (Exception e) {
            throw new OpenEJBTCKRuntimeException(e);
        }
    }

    private File getFile(String name) {
        File dir = new File(tmpDir, Math.random() + "");
        dir.mkdirs();
        dir.deleteOnExit();
        return new File(dir, name);
    }

    public DeploymentException getDeploymentException() {
        try {
            return (DeploymentException)this.exception;
        }
        catch (Exception e) {
            System.out.println("BADCAST");
            return new DeploymentException("", (Throwable)this.exception);
        }
    }

    public void undeploy(String name) throws IOException {
        System.out.println("Undeploying " + name);
        try {
            this.container.undeploy(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OpenEJBTCKRuntimeException(e);
        }
        File file = FILES.remove(name);
        System.out.println("deleting " + file.getAbsolutePath());
        FileUtils.deleteDirectory((File)file);
    }

    public void setup() throws IOException {
        try {
            this.container.start();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void cleanup() throws IOException {
        try {
            this.container.stop();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        for (File f : FILES.values()) {
            FileUtils.deleteDirectory((File)f);
        }
        FILES.clear();
    }

    private static final class Util {
        private Util() {
        }

        static void close(Closeable closeable) throws IOException {
            if (closeable == null) {
                return;
            }
            try {
                if (closeable instanceof Flushable) {
                    ((Flushable)((Object)closeable)).flush();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

